/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search.function;

import io.skylite.common.Nullable;
import io.skylite.common.util.BitMixer;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.LeafFieldData;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.lucene.search.function.CombineFunction;
import io.skylite.core.lucene.search.function.Functions;
import io.skylite.core.lucene.search.function.LeafScoreFunction;
import io.skylite.core.lucene.search.function.ScoreFunction;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public class RandomScoreFunction
extends ScoreFunction {
    private final int originalSeed;
    private final int saltedSeed;
    private final IndexFieldData<?> fieldData;
    private final String functionName;

    public RandomScoreFunction(int seed, int salt, IndexFieldData<?> uidFieldData) {
        this(seed, salt, uidFieldData, null);
    }

    public RandomScoreFunction(int seed, int salt, IndexFieldData<?> uidFieldData, @Nullable String functionName) {
        super(CombineFunction.MULTIPLY);
        this.originalSeed = seed;
        this.saltedSeed = BitMixer.mix((int)seed, (int)salt);
        this.fieldData = uidFieldData;
        this.functionName = functionName;
    }

    public LeafScoreFunction getLeafScoreFunction(final LeafReaderContext ctx) {
        SortedBinaryDocValues values;
        if (this.fieldData != null) {
            LeafFieldData leafData = this.fieldData.load(ctx);
            values = leafData.getBytesValues();
            if (values == null) {
                throw new NullPointerException("failed to get fielddata");
            }
        } else {
            values = null;
        }
        return new LeafScoreFunction(){

            public double score(int docId, float subQueryScore) throws IOException {
                int hash = values == null ? BitMixer.mix((int)(ctx.docBase + docId), (int)RandomScoreFunction.this.saltedSeed) : (values.advanceExact(docId) ? StringHelper.murmurhash3_x86_32((BytesRef)values.nextValue(), (int)RandomScoreFunction.this.saltedSeed) : RandomScoreFunction.this.saltedSeed);
                return (float)(hash & 0xFFFFFF) / 1.6777216E7f;
            }

            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                String field = RandomScoreFunction.this.fieldData == null ? null : RandomScoreFunction.this.fieldData.getFieldName();
                return Explanation.match((Number)Float.valueOf((float)this.score(docId, subQueryScore.getValue().floatValue())), (String)("random score function (seed: " + RandomScoreFunction.this.originalSeed + ", field: " + field + Functions.nameOrEmptyArg((String)RandomScoreFunction.this.functionName) + ")"), (Explanation[])new Explanation[0]);
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    protected boolean doEquals(ScoreFunction other) {
        RandomScoreFunction randomScoreFunction = (RandomScoreFunction)other;
        return this.originalSeed == randomScoreFunction.originalSeed && this.saltedSeed == randomScoreFunction.saltedSeed;
    }

    protected int doHashCode() {
        return Objects.hash(this.originalSeed, this.saltedSeed);
    }
}

