/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentBuilderExtension;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class XContentLuceniaExtension
implements XContentBuilderExtension {
    public static final DateFormatter DEFAULT_FORMATTER = DateFormatter.forPattern((String)"strict_date_optional_time_nanos");
    public static final DateFormatter LOCAL_TIME_FORMATTER = DateFormatter.forPattern((String)"HH:mm:ss.SSS");
    public static final DateFormatter OFFSET_TIME_FORMATTER = DateFormatter.forPattern((String)"HH:mm:ss.SSSZZZZZ");

    public Map<Class<?>, XContentBuilder.Writer> getXContentWriters() {
        HashMap writers = new HashMap();
        writers.put(Version.class, (b, v) -> b.value(Objects.toString(v)));
        writers.put(TimeValue.class, (b, v) -> b.value(v.toString()));
        writers.put(ZonedDateTime.class, XContentBuilder::timeValue);
        writers.put(OffsetDateTime.class, XContentBuilder::timeValue);
        writers.put(OffsetTime.class, XContentBuilder::timeValue);
        writers.put(Instant.class, XContentBuilder::timeValue);
        writers.put(LocalDateTime.class, XContentBuilder::timeValue);
        writers.put(LocalDate.class, XContentBuilder::timeValue);
        writers.put(LocalTime.class, XContentBuilder::timeValue);
        writers.put(DayOfWeek.class, (b, v) -> b.value(v.toString()));
        writers.put(Month.class, (b, v) -> b.value(v.toString()));
        writers.put(MonthDay.class, (b, v) -> b.value(v.toString()));
        writers.put(Year.class, (b, v) -> b.value(v.toString()));
        writers.put(Duration.class, (b, v) -> b.value(v.toString()));
        writers.put(Period.class, (b, v) -> b.value(v.toString()));
        writers.put(BytesReference.class, (b, v) -> {
            if (v == null) {
                b.nullValue();
            } else {
                BytesRef bytes = ((BytesReference)v).toBytesRef();
                b.value(bytes.bytes, bytes.offset, bytes.length);
            }
        });
        writers.put(BytesRef.class, (b, v) -> {
            if (v == null) {
                b.nullValue();
            } else {
                BytesRef bytes = (BytesRef)v;
                b.value(bytes.bytes, bytes.offset, bytes.length);
            }
        });
        return writers;
    }

    public Map<Class<?>, XContentBuilder.HumanReadableTransformer> getXContentHumanReadableTransformers() {
        HashMap transformers = new HashMap();
        transformers.put(TimeValue.class, v -> ((TimeValue)v).millis());
        transformers.put(ByteSizeValue.class, v -> ((ByteSizeValue)v).getBytes());
        return transformers;
    }

    public Map<Class<?>, Function<Object, Object>> getDateTransformers() {
        HashMap transformers = new HashMap();
        transformers.put(Date.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)((Date)d).toInstant()));
        transformers.put(Long.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli((Long)d)));
        transformers.put(Calendar.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)((Calendar)d).toInstant()));
        transformers.put(GregorianCalendar.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)((Calendar)d).toInstant()));
        transformers.put(Instant.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)((Instant)d)));
        transformers.put(ZonedDateTime.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)((ZonedDateTime)d)));
        transformers.put(OffsetDateTime.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)((OffsetDateTime)d)));
        transformers.put(OffsetTime.class, d -> OFFSET_TIME_FORMATTER.format((TemporalAccessor)((OffsetTime)d)));
        transformers.put(LocalDateTime.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)((LocalDateTime)d)));
        transformers.put(Instant.class, d -> DEFAULT_FORMATTER.format((TemporalAccessor)ZonedDateTime.ofInstant((Instant)d, ZoneOffset.UTC)));
        transformers.put(LocalDate.class, d -> ((LocalDate)d).toString());
        transformers.put(LocalTime.class, d -> LOCAL_TIME_FORMATTER.format((TemporalAccessor)((LocalTime)d)));
        return transformers;
    }
}

