/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import io.lucenia.plugins.DiscoveryPlugin;
import io.skylite.common.Randomness;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.service.ClusterManagerService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplierServiceInterface;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.network.NetworkService;
import io.skylite.core.discovery.Discovery;
import io.skylite.core.discovery.DiscoveryModuleSettings;
import io.skylite.core.discovery.SeedHostsProvider;
import io.skylite.core.discovery.SettingsBasedSeedHostsProvider;
import io.skylite.core.node.RemoteStoreNodeService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.coordination.Coordinator;
import org.opensearch.cluster.coordination.ElectionStrategy;
import org.opensearch.cluster.coordination.PersistedStateRegistry;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.discovery.FileBasedSeedHostsProvider;
import org.opensearch.gateway.GatewayMetaState;
import org.opensearch.monitor.NodeHealthService;

public class DiscoveryModule {
    private static final Logger logger = LogManager.getLogger(DiscoveryModule.class);
    private final Discovery discovery;

    public DiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, ClusterManagerService clusterManagerService, ClusterStateApplierServiceInterface clusterApplier, ClusterSettings clusterSettings, List<DiscoveryPlugin> plugins, AllocationService allocationService, Path configFile, GatewayMetaState gatewayMetaState, RerouteService rerouteService, NodeHealthService nodeHealthService, PersistedStateRegistry persistedStateRegistry, RemoteStoreNodeService remoteStoreNodeService) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> joinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        HashMap<String, Supplier<SeedHostsProvider>> hostProviders = new HashMap<String, Supplier<SeedHostsProvider>>();
        hostProviders.put("settings", () -> new SettingsBasedSeedHostsProvider(settings, transportService));
        hostProviders.put("file", () -> new FileBasedSeedHostsProvider(configFile));
        HashMap<String, ElectionStrategy> electionStrategies = new HashMap<String, ElectionStrategy>();
        electionStrategies.put("default", ElectionStrategy.DEFAULT_INSTANCE);
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getSeedHostProviders(transportService, networkService).forEach((key, value) -> {
                if (hostProviders.put((String)key, (Supplier<SeedHostsProvider>)value) != null) {
                    throw new IllegalArgumentException("Cannot register seed provider [" + key + "] twice");
                }
            });
            BiConsumer<DiscoveryNode, ClusterState> joinValidator = plugin.getJoinValidator();
            if (joinValidator != null) {
                joinValidators.add(joinValidator);
            }
            plugin.getElectionStrategies().forEach((key, value) -> {
                if (electionStrategies.put((String)key, (ElectionStrategy)value) != null) {
                    throw new IllegalArgumentException("Cannot register election strategy [" + key + "] twice");
                }
            });
        }
        ArrayList<String> seedProviderNames = (ArrayList<String>)DiscoveryModuleSettings.DISCOVERY_SEED_PROVIDERS_SETTING.get(settings);
        if (!seedProviderNames.contains("settings")) {
            ArrayList<String> extendedSeedProviderNames = new ArrayList<String>();
            extendedSeedProviderNames.add("settings");
            extendedSeedProviderNames.addAll(seedProviderNames);
            seedProviderNames = extendedSeedProviderNames;
        }
        HashSet missingProviderNames = new HashSet(seedProviderNames);
        missingProviderNames.removeAll(hostProviders.keySet());
        if (!missingProviderNames.isEmpty()) {
            throw new IllegalArgumentException("Unknown seed providers " + String.valueOf(missingProviderNames));
        }
        List filteredSeedProviders = seedProviderNames.stream().map(hostProviders::get).map(Supplier::get).collect(Collectors.toList());
        String discoveryType = (String)DiscoveryModuleSettings.DISCOVERY_TYPE_SETTING.get(settings);
        SeedHostsProvider seedHostsProvider = hostsResolver -> {
            ArrayList addresses = new ArrayList();
            for (SeedHostsProvider provider : filteredSeedProviders) {
                addresses.addAll(provider.getSeedAddresses(hostsResolver));
            }
            return Collections.unmodifiableList(addresses);
        };
        ElectionStrategy electionStrategy = (ElectionStrategy)electionStrategies.get(DiscoveryModuleSettings.ELECTION_STRATEGY_SETTING.get(settings));
        if (electionStrategy == null) {
            throw new IllegalArgumentException("Unknown election strategy " + (String)DiscoveryModuleSettings.ELECTION_STRATEGY_SETTING.get(settings));
        }
        if (!"zen".equals(discoveryType) && !"single-node".equals(discoveryType)) {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        this.discovery = new Coordinator((String)CommonSettings.NODE_NAME_SETTING.get(settings), settings, clusterSettings, transportService, namedWriteableRegistry, allocationService, clusterManagerService, gatewayMetaState::getPersistedState, seedHostsProvider, clusterApplier, joinValidators, new Random(Randomness.get().nextLong()), rerouteService, electionStrategy, nodeHealthService, persistedStateRegistry, remoteStoreNodeService);
        logger.info("using discovery type [{}] and seed hosts providers {}", (Object)discoveryType, seedProviderNames);
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }
}

