/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.env;

import io.skylite.SkyliteException;
import io.skylite.cli.Terminal;
import io.skylite.common.util.io.IOUtils;
import io.skylite.common.util.set.Sets;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.PersistedClusterStateService;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MetadataStateFormat;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.opensearch.cluster.coordination.LuceniaNodeCommand;

public class NodeRepurposeCommand
extends LuceniaNodeCommand {
    static final String ABORTED_BY_USER_MSG = "aborted by user";
    static final String FAILED_TO_OBTAIN_NODE_LOCK_MSG = "failed to lock node's directory, is Lucenia still running?";
    static final String NO_CLEANUP = "Node has node.data=true and node.search=true -> no clean up necessary";
    static final String NO_DATA_TO_CLEAN_UP_FOUND = "No data to clean-up found";
    static final String NO_SHARD_DATA_TO_CLEAN_UP_FOUND = "No shard data to clean-up found";
    static final String NO_FILE_CACHE_DATA_TO_CLEAN_UP_FOUND = "No file cache to clean-up found";
    private static final int FILE_CACHE_NODE_PATH_LOCATION = 0;

    public NodeRepurposeCommand() {
        super("Repurpose this node to another cluster-manager/data/search role, cleaning up any excess persisted data");
    }

    void testExecute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        this.execute(terminal, options, env);
    }

    @Override
    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        Settings settings = env.settings();
        if (DiscoveryNode.isDataNode((Settings)settings) && DiscoveryNode.isSearchNode((Settings)settings)) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_CLEANUP);
            return false;
        }
        return true;
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException {
        boolean repurposeSearch;
        assert (!DiscoveryNode.isDataNode((Settings)env.settings()) || !DiscoveryNode.isSearchNode((Settings)env.settings()));
        boolean repurposeData = !DiscoveryNode.isDataNode((Settings)env.settings());
        boolean bl = repurposeSearch = !DiscoveryNode.isSearchNode((Settings)env.settings());
        if (!DiscoveryNode.isClusterManagerNode((Settings)env.settings())) {
            this.processNoClusterManagerRepurposeNode(terminal, dataPaths, env, repurposeData, repurposeSearch);
        } else {
            this.processClusterManagerRepurposeNode(terminal, dataPaths, env, repurposeData, repurposeSearch);
        }
    }

    private void processNoClusterManagerRepurposeNode(Terminal terminal, Path[] dataPaths, Environment env, boolean repurposeData, boolean repurposeSearch) throws IOException {
        NodeEnvironment.NodePath[] nodePaths = this.toNodePaths(dataPaths);
        NodeEnvironment.NodePath fileCacheNodePath = this.toNodePaths(dataPaths)[0];
        PersistedClusterStateService persistedClusterStateService = NodeRepurposeCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Metadata metadata = this.loadClusterState(terminal, env, persistedClusterStateService).metadata();
        Set<Path> indexPaths = Set.of();
        List shardDataPaths = List.of();
        Set<Path> fileCachePaths = Set.of();
        List fileCacheDataPaths = List.of();
        terminal.println(Terminal.Verbosity.VERBOSE, "Collecting index metadata paths");
        List indexMetadataPaths = NodeEnvironment.collectIndexMetadataPaths((NodeEnvironment.NodePath[])nodePaths);
        if (repurposeData) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting shard data paths");
            shardDataPaths = NodeEnvironment.collectShardDataPaths((NodeEnvironment.NodePath[])nodePaths);
            indexPaths = this.uniqueParentPaths(shardDataPaths, indexMetadataPaths);
        }
        if (repurposeSearch) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting file cache data paths");
            fileCacheDataPaths = NodeEnvironment.collectFileCacheDataPath((NodeEnvironment.NodePath)fileCacheNodePath);
            fileCachePaths = this.uniqueParentPaths(fileCacheDataPaths, indexMetadataPaths);
        }
        if (repurposeData && repurposeSearch && fileCacheDataPaths.isEmpty() && indexPaths.isEmpty() && metadata.indices().isEmpty()) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (repurposeData && !repurposeSearch && indexPaths.isEmpty() && metadata.indices().isEmpty()) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (!repurposeData && repurposeSearch && fileCacheDataPaths.isEmpty() && metadata.indices().isEmpty()) {
            terminal.println(NO_FILE_CACHE_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        Set indexUUIDs = Sets.union(this.indexUUIDsFor(fileCachePaths), (Set)Sets.union(this.indexUUIDsFor(indexPaths), StreamSupport.stream(metadata.indices().values().spliterator(), false).map(imd -> imd.getIndexUUID()).collect(Collectors.toSet())));
        ArrayList<Path> cleanUpPaths = new ArrayList<Path>(shardDataPaths);
        cleanUpPaths.addAll(fileCacheDataPaths);
        this.outputVerboseInformation(terminal, cleanUpPaths, indexUUIDs, metadata);
        terminal.println(NodeRepurposeCommand.noClusterManagerMessage(indexUUIDs.size(), cleanUpPaths.size(), indexMetadataPaths.size()));
        this.outputHowToSeeVerboseInformation(terminal);
        if (repurposeData && repurposeSearch) {
            terminal.println("Node is being re-purposed as no-cluster-manager, no-data and no-search. Clean-up of index data and file cache will be performed.");
        } else if (repurposeData) {
            terminal.println("Node is being re-purposed as no-cluster-manager and no-data. Clean-up of index data will be performed.");
        } else if (repurposeSearch) {
            terminal.println("Node is being re-purposed as no-cluster-manager and no-search. Clean-up of file cache and corresponding index metadata will be performed.");
        }
        this.confirm(terminal, "Do you want to proceed?");
        MetadataStateFormat.deleteMetaState((Path[])dataPaths);
        if (repurposeData) {
            this.removePaths(terminal, indexPaths);
            IOUtils.rm((Path[])((Path[])Stream.of(dataPaths).map(path -> path.resolve("indices")).toArray(Path[]::new)));
        }
        if (repurposeSearch) {
            this.removePaths(terminal, fileCachePaths);
            IOUtils.rm((Path[])new Path[]{dataPaths[0].resolve("cache")});
        }
        if (repurposeData && repurposeSearch) {
            terminal.println("Node successfully repurposed to no-cluster-manager, no-data and no-search.");
        } else if (repurposeData) {
            terminal.println("Node successfully repurposed to no-cluster-manager and no-data.");
        } else if (repurposeSearch) {
            terminal.println("Node successfully repurposed to no-cluster-manager and no-search.");
        }
    }

    private void processClusterManagerRepurposeNode(Terminal terminal, Path[] dataPaths, Environment env, boolean repurposeData, boolean repurposeSearch) throws IOException {
        NodeEnvironment.NodePath[] nodePaths = this.toNodePaths(dataPaths);
        NodeEnvironment.NodePath fileCacheNodePath = this.toNodePaths(dataPaths)[0];
        PersistedClusterStateService persistedClusterStateService = NodeRepurposeCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Metadata metadata = this.loadClusterState(terminal, env, persistedClusterStateService).metadata();
        Set<Path> indexPaths = Set.of();
        List shardDataPaths = List.of();
        Set<Path> fileCachePaths = Set.of();
        List fileCacheDataPaths = List.of();
        if (repurposeData) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting shard data paths");
            shardDataPaths = NodeEnvironment.collectShardDataPaths((NodeEnvironment.NodePath[])nodePaths);
            indexPaths = this.uniqueParentPaths(shardDataPaths);
        }
        if (repurposeSearch) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting file cache data paths");
            fileCacheDataPaths = NodeEnvironment.collectFileCacheDataPath((NodeEnvironment.NodePath)fileCacheNodePath);
            fileCachePaths = this.uniqueParentPaths(fileCacheDataPaths);
        }
        if (repurposeData && repurposeSearch && shardDataPaths.isEmpty() && fileCacheDataPaths.isEmpty()) {
            terminal.println(NO_SHARD_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (repurposeData && !repurposeSearch && shardDataPaths.isEmpty()) {
            terminal.println(NO_SHARD_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (!repurposeData && repurposeSearch && fileCacheDataPaths.isEmpty()) {
            terminal.println(NO_FILE_CACHE_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        Set indexUUIDs = Sets.union(this.indexUUIDsFor(indexPaths), this.indexUUIDsFor(fileCachePaths));
        ArrayList<Path> cleanUpPaths = new ArrayList<Path>(shardDataPaths);
        cleanUpPaths.addAll(fileCacheDataPaths);
        this.outputVerboseInformation(terminal, cleanUpPaths, indexUUIDs, metadata);
        terminal.println(NodeRepurposeCommand.shardMessage(cleanUpPaths.size(), indexUUIDs.size()));
        this.outputHowToSeeVerboseInformation(terminal);
        if (repurposeData && repurposeSearch) {
            terminal.println("Node is being re-purposed as cluster-manager, no-data and no-search. Clean-up of shard data and file cache data will be performed.");
        } else if (repurposeData) {
            terminal.println("Node is being re-purposed as cluster-manager and no-data. Clean-up of shard data will be performed.");
        } else if (repurposeSearch) {
            terminal.println("Node is being re-purposed as cluster-manager and no-search. Clean-up of file cache data will be performed.");
        }
        this.confirm(terminal, "Do you want to proceed?");
        if (repurposeData) {
            this.removePaths(terminal, shardDataPaths);
        }
        if (repurposeSearch) {
            this.removePaths(terminal, fileCacheDataPaths);
        }
        if (repurposeData && repurposeSearch) {
            terminal.println("Node successfully repurposed to cluster-manager, no-data and no-search.");
        } else if (repurposeData) {
            terminal.println("Node successfully repurposed to cluster-manager and no-data.");
        } else if (repurposeSearch) {
            terminal.println("Node successfully repurposed to cluster-manager and no-search.");
        }
    }

    private ClusterState loadClusterState(Terminal terminal, Environment env, PersistedClusterStateService psf) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        return NodeRepurposeCommand.clusterState(env, psf.loadBestOnDiskState());
    }

    private void outputVerboseInformation(Terminal terminal, Collection<Path> pathsToCleanup, Set<String> indexUUIDs, Metadata metadata) {
        if (terminal.isPrintable(Terminal.Verbosity.VERBOSE)) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Paths to clean up:");
            pathsToCleanup.forEach(p -> terminal.println(Terminal.Verbosity.VERBOSE, "  " + p.toString()));
            terminal.println(Terminal.Verbosity.VERBOSE, "Indices affected:");
            indexUUIDs.forEach(uuid -> terminal.println(Terminal.Verbosity.VERBOSE, "  " + this.toIndexName((String)uuid, metadata)));
        }
    }

    private void outputHowToSeeVerboseInformation(Terminal terminal) {
        if (!terminal.isPrintable(Terminal.Verbosity.VERBOSE)) {
            terminal.println("Use -v to see list of paths and indices affected");
        }
    }

    private String toIndexName(String uuid, Metadata metadata) {
        if (metadata != null) {
            for (IndexMetadata indexMetadata : metadata.indices().values()) {
                if (!indexMetadata.getIndexUUID().equals(uuid)) continue;
                return indexMetadata.getIndex().getName();
            }
        }
        return "no name for uuid: " + uuid;
    }

    private Set<String> indexUUIDsFor(Set<Path> indexPaths) {
        return indexPaths.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
    }

    static String noClusterManagerMessage(int indexes, int shards, int indexMetadata) {
        return "Found " + indexes + " indices (" + shards + " shards/file cache folders and " + indexMetadata + " index meta data) to clean up";
    }

    static String shardMessage(int shards, int indices) {
        return "Found " + shards + " shards/file cache folders in " + indices + " indices to clean up";
    }

    private void removePaths(Terminal terminal, Collection<Path> paths) {
        terminal.println(Terminal.Verbosity.VERBOSE, "Removing data");
        paths.forEach(this::removePath);
    }

    private void removePath(Path path) {
        try {
            IOUtils.rm((Path[])new Path[]{path});
        }
        catch (IOException e) {
            throw new SkyliteException("Unable to clean up path: " + String.valueOf(path) + ": " + e.getMessage(), new Object[0]);
        }
    }

    @SafeVarargs
    private final Set<Path> uniqueParentPaths(Collection<Path> ... paths) {
        return Arrays.stream(paths).flatMap(Collection::stream).map(Path::getParent).collect(Collectors.toSet());
    }

    OptionParser getParser() {
        return this.parser;
    }
}

