/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.WriteableSetting;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.extensions.DiscoveryExtensionNode;

public class AddSettingsUpdateConsumerRequest
extends TransportRequest {
    private final DiscoveryExtensionNode extensionNode;
    private final List<WriteableSetting> componentSettings;

    public AddSettingsUpdateConsumerRequest(DiscoveryExtensionNode extensionNode, List<Setting<?>> componentSettings) {
        this.extensionNode = extensionNode;
        this.componentSettings = new ArrayList<WriteableSetting>(componentSettings.size());
        for (Setting<?> setting : componentSettings) {
            this.componentSettings.add(new WriteableSetting(setting));
        }
    }

    public AddSettingsUpdateConsumerRequest(StreamInput in) throws IOException {
        super(in);
        this.extensionNode = new DiscoveryExtensionNode(in);
        int componentSettingsCount = in.readVInt();
        this.componentSettings = new ArrayList<WriteableSetting>(componentSettingsCount);
        for (int i = 0; i < componentSettingsCount; ++i) {
            this.componentSettings.add(new WriteableSetting(in));
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.extensionNode.writeTo(out);
        out.writeVInt(this.componentSettings.size());
        for (WriteableSetting componentSetting : this.componentSettings) {
            componentSetting.writeTo(out);
        }
    }

    public List<WriteableSetting> getComponentSettings() {
        return new ArrayList<WriteableSetting>(this.componentSettings);
    }

    public DiscoveryExtensionNode getExtensionNode() {
        return this.extensionNode;
    }

    public String toString() {
        return "AddSettingsUpdateConsumerRequest{extensionNode=" + this.extensionNode.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AddSettingsUpdateConsumerRequest that = (AddSettingsUpdateConsumerRequest)((Object)obj);
        return Objects.equals((Object)this.extensionNode, (Object)that.extensionNode) && Objects.equals(this.componentSettings, that.componentSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extensionNode, this.componentSettings});
    }
}

