/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.action;

import io.lucenia.action.ActionModule;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.transport.ActionNotFoundTransportException;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.extensions.AcknowledgedResponse;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.extensions.action.ExtensionAction;
import org.opensearch.extensions.action.ExtensionActionRequest;
import org.opensearch.extensions.action.ExtensionActionResponse;
import org.opensearch.extensions.action.ExtensionHandleTransportRequest;
import org.opensearch.extensions.action.ExtensionTransportAction;
import org.opensearch.extensions.action.RegisterTransportActionsRequest;
import org.opensearch.extensions.action.RemoteExtensionActionResponse;
import org.opensearch.extensions.action.TransportActionRequestFromExtension;

public class ExtensionTransportActionsHandler {
    private static final Logger logger = LogManager.getLogger(ExtensionTransportActionsHandler.class);
    private final Map<String, String> actionToIdMap = new ConcurrentHashMap<String, String>();
    private final Map<String, DiscoveryExtensionNode> extensionIdMap;
    private final TransportService transportService;
    private final NodeClient client;
    private final ActionFilters actionFilters;
    private final ActionModule.DynamicActionRegistry dynamicActionRegistry;
    private final ExtensionsManager extensionsManager;

    public ExtensionTransportActionsHandler(Map<String, DiscoveryExtensionNode> extensionIdMap, TransportService transportService, NodeClient client, ActionModule actionModule, ExtensionsManager extensionsManager) {
        this.extensionIdMap = extensionIdMap;
        this.transportService = transportService;
        this.client = client;
        this.actionFilters = actionModule.getActionFilters();
        this.dynamicActionRegistry = actionModule.getDynamicActionRegistry();
        this.extensionsManager = extensionsManager;
    }

    void registerAction(String action, String uniqueId) throws IllegalArgumentException {
        if (this.actionToIdMap.putIfAbsent(action, uniqueId) != null) {
            throw new IllegalArgumentException("The action [" + action + "] you are trying to register is already registered");
        }
        this.dynamicActionRegistry.registerDynamicAction(new ExtensionAction(uniqueId, action), new ExtensionTransportAction(action, this.actionFilters, this.transportService.getTaskManager(), this.extensionsManager));
    }

    public DiscoveryExtensionNode getExtension(String action) {
        String uniqueId = this.actionToIdMap.get(action);
        if (uniqueId == null) {
            throw new ActionNotFoundTransportException(action);
        }
        return this.extensionIdMap.get(uniqueId);
    }

    public TransportResponse handleRegisterTransportActionsRequest(RegisterTransportActionsRequest transportActionsRequest) {
        try {
            for (String action : transportActionsRequest.getTransportActions()) {
                this.registerAction(action, transportActionsRequest.getUniqueId());
            }
        }
        catch (Exception e) {
            logger.error("Could not register Transport Action: " + e.getMessage());
            return new AcknowledgedResponse(false);
        }
        return new AcknowledgedResponse(true);
    }

    public RemoteExtensionActionResponse handleTransportActionRequestFromExtension(TransportActionRequestFromExtension request) throws Exception {
        String actionName = request.getAction();
        String uniqueId = this.actionToIdMap.get(actionName);
        final RemoteExtensionActionResponse response = new RemoteExtensionActionResponse(false, new byte[0]);
        if (uniqueId == null) {
            response.setResponseBytesAsString("Request failed: action [" + actionName + "] is not registered for any extension.");
            return response;
        }
        ExtensionAction extensionAction = new ExtensionAction(uniqueId, actionName);
        if (this.dynamicActionRegistry.get(extensionAction) == null) {
            response.setResponseBytesAsString("Request failed: action [" + actionName + "] is not registered for extension [" + uniqueId + "].");
            return response;
        }
        DiscoveryExtensionNode extension = this.extensionIdMap.get(uniqueId);
        if (extension == null) {
            response.setResponseBytesAsString("Request failed: extension [" + uniqueId + "] can not be reached.");
            return response;
        }
        final CompletableFuture inProgressFuture = new CompletableFuture();
        this.client.execute((ActionType)extensionAction, (ActionRequest)new ExtensionActionRequest(request.getAction(), request.getRequestBytes()), (ActionListener)new ActionListener<RemoteExtensionActionResponse>(){

            public void onResponse(RemoteExtensionActionResponse actionResponse) {
                response.setSuccess(actionResponse.isSuccess());
                response.setResponseBytes(actionResponse.getResponseBytes());
                inProgressFuture.complete(actionResponse);
            }

            public void onFailure(Exception exp) {
                logger.debug("Transport request failed", (Throwable)exp);
                response.setResponseBytesAsString("Request failed: " + exp.getMessage());
                inProgressFuture.completeExceptionally(exp);
            }
        });
        try {
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                logger.info("No response from extension to request.");
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return response;
    }

    public ExtensionActionResponse sendTransportRequestToExtension(ExtensionActionRequest request) throws Exception {
        DiscoveryExtensionNode extension = this.getExtension(request.getAction());
        final CompletableFuture inProgressFuture = new CompletableFuture();
        final ExtensionActionResponse extensionActionResponse = new ExtensionActionResponse(new byte[0]);
        TransportResponseHandler<ExtensionActionResponse> extensionActionResponseTransportResponseHandler = new TransportResponseHandler<ExtensionActionResponse>(){

            public ExtensionActionResponse read(StreamInput in) throws IOException {
                return new ExtensionActionResponse(in);
            }

            public void handleResponse(ExtensionActionResponse response) {
                extensionActionResponse.setResponseBytes(response.getResponseBytes());
                inProgressFuture.complete(response);
            }

            public void handleException(TransportException exp) {
                logger.debug("Transport request failed", (Throwable)exp);
                inProgressFuture.completeExceptionally((Throwable)exp);
            }

            public String executor() {
                return "generic";
            }
        };
        try {
            this.transportService.sendRequest((DiscoveryNode)extension, "internal:extensions/handle-transportaction", (TransportRequest)new ExtensionHandleTransportRequest(request.getAction(), request.getRequestBytes()), (TransportResponseHandler)extensionActionResponseTransportResponseHandler);
        }
        catch (Exception e) {
            logger.info("Failed to send transport action to extension " + extension.getName(), (Throwable)e);
        }
        try {
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                logger.info("No response from extension to request.");
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return extensionActionResponse;
    }

    public RemoteExtensionActionResponse sendRemoteTransportRequestToExtension(ExtensionActionRequest request) {
        DiscoveryExtensionNode extension = this.getExtension(request.getAction());
        final CompletableFuture inProgressFuture = new CompletableFuture();
        final RemoteExtensionActionResponse extensionActionResponse = new RemoteExtensionActionResponse(false, new byte[0]);
        TransportResponseHandler<RemoteExtensionActionResponse> extensionActionResponseTransportResponseHandler = new TransportResponseHandler<RemoteExtensionActionResponse>(){

            public RemoteExtensionActionResponse read(StreamInput in) throws IOException {
                return new RemoteExtensionActionResponse(in);
            }

            public void handleResponse(RemoteExtensionActionResponse response) {
                extensionActionResponse.setSuccess(response.isSuccess());
                extensionActionResponse.setResponseBytes(response.getResponseBytes());
                inProgressFuture.complete(response);
            }

            public void handleException(TransportException exp) {
                logger.debug("Transport request failed", (Throwable)exp);
                extensionActionResponse.setResponseBytesAsString("Request failed: " + exp.getMessage());
                inProgressFuture.completeExceptionally((Throwable)exp);
            }

            public String executor() {
                return "generic";
            }
        };
        try {
            this.transportService.sendRequest((DiscoveryNode)extension, "internal:extensions/handle-remote-transportaction", (TransportRequest)new ExtensionHandleTransportRequest(request.getAction(), request.getRequestBytes()), (TransportResponseHandler)extensionActionResponseTransportResponseHandler);
        }
        catch (Exception e) {
            logger.info("Failed to send transport action to extension " + extension.getName(), (Throwable)e);
        }
        try {
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                logger.info("No response from extension to request.");
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return extensionActionResponse;
    }
}

