/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.extensions.proto.ExtensionIdentityProto;
import org.opensearch.extensions.proto.RegisterRestActionsProto;

public class RegisterRestActionsRequest
extends TransportRequest {
    private final RegisterRestActionsProto.RegisterRestActions request;

    public RegisterRestActionsRequest(String uniqueId, List<String> restActions, List<String> deprecatedRestActions) {
        ExtensionIdentityProto.ExtensionIdentity identity = ExtensionIdentityProto.ExtensionIdentity.newBuilder().setUniqueId(uniqueId).build();
        this.request = RegisterRestActionsProto.RegisterRestActions.newBuilder().setIdentity(identity).addAllRestActions(restActions).addAllDeprecatedRestActions(deprecatedRestActions).build();
    }

    public RegisterRestActionsRequest(StreamInput in) throws IOException {
        super(in);
        this.request = RegisterRestActionsProto.RegisterRestActions.parseFrom(in.readByteArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByteArray(this.request.toByteArray());
    }

    public String getUniqueId() {
        return this.request.getIdentity().getUniqueId();
    }

    public List<String> getRestActions() {
        return List.copyOf(this.request.getRestActionsList());
    }

    public List<String> getDeprecatedRestActions() {
        return List.copyOf(this.request.getDeprecatedRestActionsList());
    }

    public String toString() {
        return "RestActionsRequest{Identity=" + String.valueOf(this.request.getIdentity()) + ", restActions=" + String.valueOf(this.request.getRestActionsList()) + ", deprecatedRestActions=" + String.valueOf(this.request.getDeprecatedRestActionsList()) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RegisterRestActionsRequest that = (RegisterRestActionsRequest)((Object)obj);
        return Objects.equals(this.request.getIdentity().getUniqueId(), that.request.getIdentity().getUniqueId()) && Objects.equals(this.request.getRestActionsList(), that.request.getRestActionsList()) && Objects.equals(this.request.getDeprecatedRestActionsList(), that.request.getDeprecatedRestActionsList());
    }

    public int hashCode() {
        return Objects.hash(this.request.getIdentity(), this.request.getRestActionsList(), this.request.getDeprecatedRestActionsList());
    }
}

