/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import io.skylite.Version;
import io.skylite.common.collect.Tuple;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.opensearch.extensions.ExtensionDependency;
import org.opensearch.extensions.ExtensionScopedSettings;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.extensions.ExtensionsSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.NamedRoute;

public class RestInitializeExtensionAction
extends BaseRestHandler {
    private final ExtensionsManager extensionsManager;

    @Override
    public String getName() {
        return "internal:discovery/extensions";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new NamedRoute.Builder().method(RestRequest.Method.POST).path("/_extensions/initialize").uniqueName("extensions:initialize").build());
    }

    public RestInitializeExtensionAction(ExtensionsManager extensionsManager) {
        this.extensionsManager = extensionsManager;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String name = null;
        String uniqueId = null;
        String hostAddress = null;
        String port = null;
        String version = null;
        String luceniaVersion = null;
        String minimumCompatibleVersion = null;
        ArrayList<ExtensionDependency> dependencies = new ArrayList<ExtensionDependency>();
        Set additionalSettingsKeys = this.extensionsManager.getAdditionalSettings().stream().map(s -> s.getKey()).collect(Collectors.toSet());
        Tuple unreadExtensionTuple = XContentHelper.convertToMap((BytesReference)request.content(), (boolean)false, (MediaType)request.getMediaType().xContent().mediaType());
        Map extensionMap = (Map)unreadExtensionTuple.v2();
        ExtensionScopedSettings extAdditionalSettings = new ExtensionScopedSettings(this.extensionsManager.getAdditionalSettings());
        try {
            String[] requiredFields = new String[]{"name", "uniqueId", "hostAddress", "port", "version", "luceniaVersion", "minimumCompatibleVersion"};
            List missingFields = Arrays.stream(requiredFields).filter(field -> !extensionMap.containsKey(field)).collect(Collectors.toList());
            if (!missingFields.isEmpty()) {
                throw new IOException("Extension is missing these required fields : " + String.valueOf(missingFields));
            }
            ArrayList<ExtensionDependency> extensionDependencyList = new ArrayList<ExtensionDependency>();
            if (extensionMap.get("dependencies") != null) {
                ArrayList extensionDependencies = new ArrayList((Collection)extensionMap.get("dependencies"));
                for (HashMap dependency : extensionDependencies) {
                    if (Strings.isNullOrEmpty((String)((String)dependency.get("uniqueId")))) {
                        throw new IOException("Required field [uniqueId] is missing in the request for the dependent extension");
                    }
                    if (dependency.get("version") == null) {
                        throw new IOException("Required field [version] is missing in the request for the dependent extension");
                    }
                    extensionDependencyList.add(new ExtensionDependency(dependency.get("uniqueId").toString(), Version.fromString((String)dependency.get("version").toString())));
                }
            }
            Map<String, Object> additionalSettingsMap = extensionMap.entrySet().stream().filter(kv -> additionalSettingsKeys.contains(kv.getKey())).collect(Collectors.toMap(map -> (String)map.getKey(), map -> map.getValue()));
            Settings.Builder output = Settings.builder();
            output.loadFromMap(additionalSettingsMap);
            extAdditionalSettings.applySettings(output.build());
            name = extensionMap.get("name").toString();
            uniqueId = extensionMap.get("uniqueId").toString();
            hostAddress = extensionMap.get("hostAddress").toString();
            port = extensionMap.get("port").toString();
            version = extensionMap.get("version").toString();
            luceniaVersion = extensionMap.get("luceniaVersion").toString();
            minimumCompatibleVersion = extensionMap.get("minimumCompatibleVersion").toString();
            dependencies = extensionDependencyList;
        }
        catch (IOException e) {
            this.logger.warn("loading extension has been failed because of exception : " + e.getMessage());
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
        ExtensionsSettings.Extension extension = new ExtensionsSettings.Extension(name, uniqueId, hostAddress, port, version, luceniaVersion, minimumCompatibleVersion, dependencies, extAdditionalSettings);
        try {
            this.extensionsManager.initializeExtension(extension);
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, "No response from extension to request."));
            }
            if (cause instanceof ConnectTransportException || cause instanceof RuntimeException) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, "Connection failed with the extension."));
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
        }
        catch (Exception e) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("success", "A request to initialize an extension has been sent.");
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.ACCEPTED, builder));
            }
        };
    }
}

