/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.cluster.metadata.IndexGraveyard;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.Index;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.gateway.LocalAllocateDangledIndices;
import org.opensearch.gateway.MetaStateService;

public class DanglingIndicesState
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(DanglingIndicesState.class);
    public static final Setting<Boolean> AUTO_IMPORT_DANGLING_INDICES_SETTING = Setting.boolSetting((String)"gateway.auto_import_dangling_indices", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    private final LocalAllocateDangledIndices danglingIndicesAllocator;
    private final boolean isAutoImportDanglingIndicesEnabled;
    private final ClusterService clusterService;
    private final Map<Index, IndexMetadata> danglingIndices = ConcurrentCollections.newConcurrentMap();

    @Inject
    public DanglingIndicesState(NodeEnvironment nodeEnv, MetaStateService metaStateService, LocalAllocateDangledIndices danglingIndicesAllocator, ClusterService clusterService) {
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        this.danglingIndicesAllocator = danglingIndicesAllocator;
        this.clusterService = clusterService;
        this.isAutoImportDanglingIndicesEnabled = (Boolean)AUTO_IMPORT_DANGLING_INDICES_SETTING.get(clusterService.getSettings());
        if (this.isAutoImportDanglingIndicesEnabled) {
            clusterService.addListener((ClusterStateListener)this);
        } else {
            logger.warn(AUTO_IMPORT_DANGLING_INDICES_SETTING.getKey() + " is disabled, dangling indices will not be automatically detected or imported and must be managed manually");
        }
    }

    boolean isAutoImportDanglingIndicesEnabled() {
        return this.isAutoImportDanglingIndicesEnabled;
    }

    public void processDanglingIndices(Metadata metadata) {
        assert (this.isAutoImportDanglingIndicesEnabled);
        if (!this.nodeEnv.hasNodeFile()) {
            return;
        }
        this.cleanupAllocatedDangledIndices(metadata);
        this.findNewAndAddDanglingIndices(metadata);
        this.allocateDanglingIndices(metadata);
    }

    public Map<Index, IndexMetadata> getDanglingIndices() {
        if (this.isAutoImportDanglingIndicesEnabled) {
            return Collections.unmodifiableMap(new HashMap<Index, IndexMetadata>(this.danglingIndices));
        }
        return this.findNewDanglingIndices(Collections.emptyMap(), this.clusterService.state().metadata());
    }

    void cleanupAllocatedDangledIndices(Metadata metadata) {
        for (Index index : this.danglingIndices.keySet()) {
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null || !indexMetadata.getIndex().getName().equals(index.getName())) continue;
            if (!indexMetadata.getIndex().getUUID().equals(index.getUUID())) {
                logger.warn("[{}] can not be imported as a dangling index, as there is already another index with the same name but a different uuid. local index will be ignored (but not deleted)", (Object)index);
            } else {
                logger.debug("[{}] no longer dangling (created), removing from dangling list", (Object)index);
            }
            this.danglingIndices.remove(index);
        }
    }

    void findNewAndAddDanglingIndices(Metadata metadata) {
        IndexGraveyard graveyard = metadata.indexGraveyard();
        this.danglingIndices.keySet().removeIf(arg_0 -> ((IndexGraveyard)graveyard).containsIndex(arg_0));
        this.danglingIndices.putAll(this.findNewDanglingIndices(this.danglingIndices, metadata));
    }

    public Map<Index, IndexMetadata> findNewDanglingIndices(Map<Index, IndexMetadata> existingDanglingIndices, Metadata metadata) {
        HashSet<String> excludeIndexPathIds = new HashSet<String>(metadata.indices().size() + this.danglingIndices.size());
        for (IndexMetadata indexMetadata : metadata.indices().values()) {
            excludeIndexPathIds.add(indexMetadata.getIndex().getUUID());
        }
        for (Index index : existingDanglingIndices.keySet()) {
            excludeIndexPathIds.add(index.getUUID());
        }
        try {
            List<IndexMetadata> indexMetadataList = this.metaStateService.loadIndicesStates(excludeIndexPathIds::contains);
            HashMap<Index, IndexMetadata> newIndices = new HashMap<Index, IndexMetadata>(indexMetadataList.size());
            IndexGraveyard graveyard = metadata.indexGraveyard();
            for (IndexMetadata indexMetadata : indexMetadataList) {
                Index index = indexMetadata.getIndex();
                if (graveyard.containsIndex(index)) continue;
                newIndices.put(index, this.stripAliases(indexMetadata));
            }
            return newIndices;
        }
        catch (IOException e) {
            logger.warn("failed to list dangling indices", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    List<IndexMetadata> filterDanglingIndices(Metadata metadata, Map<Index, IndexMetadata> allIndices) {
        ArrayList<IndexMetadata> filteredIndices = new ArrayList<IndexMetadata>(allIndices.size());
        allIndices.forEach((index, indexMetadata) -> {
            if (metadata.hasIndex(indexMetadata.getIndex().getName())) {
                logger.warn("[{}] can not be imported as a dangling index, as index with same name already exists in cluster metadata", (Object)indexMetadata.getIndex());
            } else {
                logger.info("[{}] dangling index exists on local file system, but not in cluster metadata, auto import to cluster state", (Object)indexMetadata.getIndex());
                filteredIndices.add(this.stripAliases((IndexMetadata)indexMetadata));
            }
        });
        return filteredIndices;
    }

    private IndexMetadata stripAliases(IndexMetadata indexMetadata) {
        if (indexMetadata.getAliases().isEmpty()) {
            return indexMetadata;
        }
        logger.info("[{}] stripping aliases: {} from index before importing", (Object)indexMetadata.getIndex(), indexMetadata.getAliases().keySet());
        return IndexMetadata.builder((IndexMetadata)indexMetadata).removeAllAliases().build();
    }

    void allocateDanglingIndices(Metadata metadata) {
        if (this.danglingIndices.isEmpty()) {
            return;
        }
        List<IndexMetadata> filteredIndices = this.filterDanglingIndices(metadata, this.danglingIndices);
        if (filteredIndices.isEmpty()) {
            return;
        }
        try {
            this.danglingIndicesAllocator.allocateDangled(filteredIndices, new ActionListener<LocalAllocateDangledIndices.AllocateDangledResponse>(this){

                public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse response) {
                    logger.trace("allocated dangled");
                }

                public void onFailure(Exception e) {
                    logger.info("failed to send allocated dangled", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.warn("failed to send allocate dangled", (Throwable)e);
        }
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (!event.state().blocks().disableStatePersistence()) {
            this.processDanglingIndices(event.state().metadata());
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(AUTO_IMPORT_DANGLING_INDICES_SETTING);
        }
    }
}

