/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.skylite.core.action.FailedNodeException;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.index.Index;
import io.skylite.core.settings.Settings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.gateway.ClusterStateUpdaters;
import org.opensearch.gateway.GatewayException;
import org.opensearch.gateway.TransportNodesListGatewayMetaState;

public class Gateway {
    private static final Logger logger = LogManager.getLogger(Gateway.class);
    private final ClusterService clusterService;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;

    public Gateway(Settings settings, ClusterService clusterService, TransportNodesListGatewayMetaState listGatewayMetaState) {
        this.clusterService = clusterService;
        this.listGatewayMetaState = listGatewayMetaState;
    }

    public void performStateRecovery(GatewayStateRecoveredListener listener) throws GatewayException {
        Object[] nodesIds = this.clusterService.state().nodes().getClusterManagerNodes().keySet().toArray(new String[0]);
        logger.trace("performing state recovery from {}", (Object)Arrays.toString(nodesIds));
        TransportNodesListGatewayMetaState.NodesGatewayMetaState nodesState = (TransportNodesListGatewayMetaState.NodesGatewayMetaState)((Object)this.listGatewayMetaState.list((String[])nodesIds, null).actionGet());
        boolean requiredAllocation = true;
        if (nodesState.hasFailures()) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                logger.warn("failed to fetch state from node", (Throwable)failedNodeException);
            }
        }
        HashMap<Index, Float> indices = new HashMap<Index, Float>();
        Metadata electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
            if (nodeState.metadata() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metadata();
            } else if (nodeState.metadata().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metadata();
            }
            for (IndexMetadata cursor : nodeState.metadata().indices().values()) {
                indices.merge(cursor.getIndex(), Float.valueOf(1.0f), Float::sum);
            }
        }
        if (found < 1) {
            listener.onFailure("found [" + found + "] metadata states, required [1]");
            return;
        }
        Metadata.Builder metadataBuilder = Metadata.builder(electedGlobalState).removeAllIndices();
        assert (!indices.containsKey(null));
        Object[] keys = indices.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            Index index = (Index)keys[i];
            IndexMetadata electedIndexMetadata = null;
            int indexMetadataCount = 0;
            for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
                IndexMetadata indexMetadata;
                if (nodeState.metadata() == null || (indexMetadata = nodeState.metadata().index(index)) == null) continue;
                if (electedIndexMetadata == null) {
                    electedIndexMetadata = indexMetadata;
                } else if (indexMetadata.getVersion() > electedIndexMetadata.getVersion()) {
                    electedIndexMetadata = indexMetadata;
                }
                ++indexMetadataCount;
            }
            if (electedIndexMetadata == null) continue;
            if (indexMetadataCount < 1) {
                logger.debug("[{}] found [{}], required [{}], not adding", (Object)index, (Object)indexMetadataCount, (Object)1);
            }
            metadataBuilder.put(electedIndexMetadata, false);
        }
        ClusterState recoveredState = Function.identity().andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, this.clusterService.getClusterSettings())).apply(ClusterState.builder((ClusterName)this.clusterService.getClusterName()).metadata(metadataBuilder).build());
        listener.onSuccess(recoveredState);
    }

    public static interface GatewayStateRecoveredListener {
        public void onSuccess(ClusterState var1);

        public void onFailure(String var1);
    }
}

