/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.set.Sets;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.AllocateUnassignedDecision;
import io.skylite.core.cluster.routing.allocation.FailedShard;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import io.skylite.core.cluster.routing.allocation.UnassignedAllocationHandler;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.shard.ShardId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.PrimaryShardAllocator;
import org.opensearch.gateway.ReplicaShardAllocator;
import org.opensearch.gateway.TransportNodesListGatewayStartedShards;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadata;

public class GatewayAllocator
implements ExistingShardsAllocator {
    public static final String ALLOCATOR_NAME = "gateway_allocator";
    private static final Logger logger = LogManager.getLogger(GatewayAllocator.class);
    private final RerouteService rerouteService;
    private final PrimaryShardAllocator primaryShardAllocator;
    private final ReplicaShardAllocator replicaShardAllocator;
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> asyncFetchStarted = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata>> asyncFetchStore = ConcurrentCollections.newConcurrentMap();
    private Set<String> lastSeenEphemeralIds = Collections.emptySet();

    @Inject
    public GatewayAllocator(RerouteService rerouteService, TransportNodesListGatewayStartedShards startedAction, TransportNodesListShardStoreMetadata storeAction) {
        this.rerouteService = rerouteService;
        this.primaryShardAllocator = new InternalPrimaryShardAllocator(startedAction);
        this.replicaShardAllocator = new InternalReplicaShardAllocator(storeAction);
    }

    @Override
    public void cleanCaches() {
        Releasables.close(this.asyncFetchStarted.values());
        this.asyncFetchStarted.clear();
        Releasables.close(this.asyncFetchStore.values());
        this.asyncFetchStore.clear();
    }

    protected GatewayAllocator() {
        this.rerouteService = null;
        this.primaryShardAllocator = null;
        this.replicaShardAllocator = null;
    }

    @Override
    public int getNumberOfInFlightFetches() {
        int count = 0;
        for (AsyncShardFetch fetch : this.asyncFetchStarted.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        for (AsyncShardFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        return count;
    }

    @Override
    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        for (ShardRouting startedShard : startedShards) {
            Releasables.close((Releasable)((Releasable)this.asyncFetchStarted.remove(startedShard.shardId())));
            Releasables.close((Releasable)((Releasable)this.asyncFetchStore.remove(startedShard.shardId())));
        }
    }

    @Override
    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        for (FailedShard failedShard : failedShards) {
            Releasables.close((Releasable)((Releasable)this.asyncFetchStarted.remove(failedShard.getRoutingEntry().shardId())));
            Releasables.close((Releasable)((Releasable)this.asyncFetchStore.remove(failedShard.getRoutingEntry().shardId())));
        }
    }

    @Override
    public void beforeAllocation(RoutingAllocation allocation) {
        assert (this.primaryShardAllocator != null);
        assert (this.replicaShardAllocator != null);
        this.ensureAsyncFetchStorePrimaryRecency(allocation);
    }

    @Override
    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
        assert (this.replicaShardAllocator != null);
        if (allocation.routingNodes().hasInactiveShards()) {
            this.replicaShardAllocator.processExistingRecoveries(allocation);
        }
    }

    @Override
    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, UnassignedAllocationHandler unassignedAllocationHandler) {
        assert (this.primaryShardAllocator != null);
        assert (this.replicaShardAllocator != null);
        GatewayAllocator.innerAllocatedUnassigned(allocation, this.primaryShardAllocator, this.replicaShardAllocator, shardRouting, unassignedAllocationHandler);
    }

    protected static void innerAllocatedUnassigned(RoutingAllocation allocation, PrimaryShardAllocator primaryShardAllocator, ReplicaShardAllocator replicaShardAllocator, ShardRouting shardRouting, UnassignedAllocationHandler unassignedAllocationHandler) {
        assert (shardRouting.unassigned());
        if (shardRouting.primary()) {
            primaryShardAllocator.allocateUnassigned(shardRouting, allocation, unassignedAllocationHandler);
        } else {
            replicaShardAllocator.allocateUnassigned(shardRouting, allocation, unassignedAllocationHandler);
        }
    }

    @Override
    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation routingAllocation) {
        assert (unassignedShard.unassigned());
        assert (routingAllocation.debugDecision());
        if (unassignedShard.primary()) {
            assert (this.primaryShardAllocator != null);
            return this.primaryShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, logger);
        }
        assert (this.replicaShardAllocator != null);
        return this.replicaShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, logger);
    }

    private void ensureAsyncFetchStorePrimaryRecency(RoutingAllocation allocation) {
        DiscoveryNodes nodes = allocation.nodes();
        if (this.hasNewNodes(nodes)) {
            Set newEphemeralIds = StreamSupport.stream(Spliterators.spliterator(nodes.getDataNodes().entrySet(), 0), false).map(node -> ((DiscoveryNode)node.getValue()).getEphemeralId()).collect(Collectors.toSet());
            logger.trace(() -> new ParameterizedMessage("new nodes {} found, clearing primary async-fetch-store cache", (Object)Sets.difference((Set)newEphemeralIds, this.lastSeenEphemeralIds)));
            this.asyncFetchStore.values().forEach(fetch -> GatewayAllocator.clearCacheForPrimary(fetch, allocation));
            this.lastSeenEphemeralIds = newEphemeralIds;
        }
    }

    private static void clearCacheForPrimary(AsyncShardFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetch, RoutingAllocation allocation) {
        assert (fetch.shardAttributesMap.size() == 1) : "expected only one shard";
        ShardId shardId = fetch.shardAttributesMap.keySet().iterator().next();
        ShardRouting primary = allocation.routingNodes().activePrimary(shardId);
        if (primary != null) {
            fetch.clearCacheForNode(primary.currentNodeId());
        }
    }

    private boolean hasNewNodes(DiscoveryNodes nodes) {
        for (DiscoveryNode node : nodes.getDataNodes().values()) {
            if (this.lastSeenEphemeralIds.contains(node.getEphemeralId())) continue;
            return true;
        }
        return false;
    }

    class InternalPrimaryShardAllocator
    extends PrimaryShardAllocator {
        private final TransportNodesListGatewayStartedShards startedAction;

        InternalPrimaryShardAllocator(TransportNodesListGatewayStartedShards startedAction) {
            this.startedAction = startedAction;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(final ShardRouting shard, final RoutingAllocation allocation) {
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStarted.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>(this.logger, "shard_started", (ShardId)shardId, (String)IndexMetadata.INDEX_DATA_PATH_SETTING.get(allocation.metadata().index(shard.index()).getSettings()), this.startedAction));
            AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = fetch.fetchData(allocation.nodes(), (Map<ShardId, Set<String>>)new HashMap<ShardId, Set<String>>(){
                {
                    this.put(shard.shardId(), allocation.getIgnoreNodes(shard.shardId()));
                }
            });
            if (shardState.hasData()) {
                shardState.processAllocation(allocation);
            }
            return shardState;
        }
    }

    class InternalReplicaShardAllocator
    extends ReplicaShardAllocator {
        private final TransportNodesListShardStoreMetadata storeAction;

        InternalReplicaShardAllocator(TransportNodesListShardStoreMetadata storeAction) {
            this.storeAction = storeAction;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(final ShardRouting shard, final RoutingAllocation allocation) {
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStore.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata>(this.logger, "shard_store", shard.shardId(), (String)IndexMetadata.INDEX_DATA_PATH_SETTING.get(allocation.metadata().index(shard.index()).getSettings()), this.storeAction));
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores = fetch.fetchData(allocation.nodes(), (Map<ShardId, Set<String>>)new HashMap<ShardId, Set<String>>(){
                {
                    this.put(shard.shardId(), allocation.getIgnoreNodes(shard.shardId()));
                }
            });
            if (shardStores.hasData()) {
                shardStores.processAllocation(allocation);
            }
            return shardStores;
        }

        @Override
        protected boolean hasInitiatedFetching(ShardRouting shard) {
            return GatewayAllocator.this.asyncFetchStore.get(shard.shardId()) != null;
        }
    }

    class InternalAsyncFetch<T extends BaseNodeResponse>
    extends AsyncShardFetch<T> {
        InternalAsyncFetch(Logger logger, String type, ShardId shardId, String customDataPath, AsyncShardFetch.Lister<? extends BaseNodesResponse<T>, T> action) {
            super(logger, type, shardId, customDataPath, action);
        }

        @Override
        protected void reroute(String reroutingKey, String reason) {
            this.logger.trace("{} scheduling reroute for {}", (Object)reroutingKey, (Object)reason);
            assert (GatewayAllocator.this.rerouteService != null);
            GatewayAllocator.this.rerouteService.reroute("async_shard_fetch", Priority.HIGH, ActionListenerHelper.wrap(r -> this.logger.trace("{} scheduled reroute completed for {}", (Object)reroutingKey, (Object)reason), e -> this.logger.debug((Message)new ParameterizedMessage("{} scheduled reroute failed for {}", (Object)reroutingKey, (Object)reason), (Throwable)e)));
        }
    }
}

