/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.allocation.AllocateUnassignedDecision;
import io.skylite.core.cluster.routing.allocation.RoutingAllocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.PrimaryShardAllocator;
import org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.opensearch.gateway.TransportNodesListGatewayStartedShards;
import org.opensearch.gateway.TransportNodesListGatewayStartedShardsBatch;

public abstract class PrimaryShardBatchAllocator
extends PrimaryShardAllocator {
    protected abstract AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> fetchData(List<ShardRouting> var1, List<ShardRouting> var2, RoutingAllocation var3);

    @Override
    protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
        this.logger.error("fetchData for single shard called via batch allocator, shard id {}", (Object)shard.shardId());
        throw new IllegalStateException("PrimaryShardBatchAllocator should only be used for a batch of shards");
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        return this.makeAllocationDecision(Collections.singletonList(unassignedShard), allocation, logger).get(unassignedShard);
    }

    @Override
    public HashMap<ShardRouting, AllocateUnassignedDecision> makeAllocationDecision(List<ShardRouting> shards, RoutingAllocation allocation, Logger logger) {
        HashMap<ShardRouting, AllocateUnassignedDecision> shardAllocationDecisions = new HashMap<ShardRouting, AllocateUnassignedDecision>();
        ArrayList<ShardRouting> eligibleShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> inEligibleShards = new ArrayList<ShardRouting>();
        for (ShardRouting shard : shards) {
            AllocateUnassignedDecision decision = this.getInEligibleShardDecision(shard, allocation);
            if (decision != null) {
                inEligibleShards.add(shard);
                shardAllocationDecisions.put(shard, decision);
                continue;
            }
            eligibleShards.add(shard);
        }
        if (eligibleShards.isEmpty()) {
            return shardAllocationDecisions;
        }
        AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> shardsState = this.fetchData(eligibleShards, inEligibleShards, allocation);
        for (ShardRouting unassignedShard : eligibleShards) {
            List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates = PrimaryShardBatchAllocator.adaptToNodeShardStates(unassignedShard, shardsState);
            shardAllocationDecisions.put(unassignedShard, this.getAllocationDecision(unassignedShard, allocation, nodeShardStates, logger));
        }
        return shardAllocationDecisions;
    }

    private static List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> adaptToNodeShardStates(ShardRouting unassignedShard, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> shardsState) {
        if (!shardsState.hasData()) {
            return null;
        }
        ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates = new ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard>();
        Map<DiscoveryNode, TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> nodeResponses = shardsState.getData();
        nodeResponses.forEach((node, nodeGatewayStartedShardsBatch) -> {
            TransportNodesGatewayStartedShardHelper.GatewayStartedShard shardData = nodeGatewayStartedShardsBatch.getNodeGatewayStartedShardsBatch().get(unassignedShard.shardId());
            nodeShardStates.add(new TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard(shardData.allocationId(), shardData.primary(), shardData.replicationCheckpoint(), shardData.storeException(), (DiscoveryNode)node));
        });
        return nodeShardStates;
    }
}

