/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.store.ShardAttributes;

public class TransportNodesListGatewayStartedShardsBatch
extends TransportNodesAction<Request, NodesGatewayStartedShardsBatch, NodeRequest, NodeGatewayStartedShardsBatch>
implements AsyncShardFetch.Lister<NodesGatewayStartedShardsBatch, NodeGatewayStartedShardsBatch> {
    public static final String ACTION_NAME = "internal:gateway/local/started_shards_batch";
    public static final ActionType<NodesGatewayStartedShardsBatch> TYPE = new ActionType("internal:gateway/local/started_shards_batch", NodesGatewayStartedShardsBatch::new);
    private final Settings settings;
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportNodesListGatewayStartedShardsBatch(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeEnvironment env, IndicesService indicesService, NamedXContentRegistry namedXContentRegistry) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_started", NodeGatewayStartedShardsBatch.class);
        this.settings = settings;
        this.nodeEnv = env;
        this.indicesService = indicesService;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    @Override
    public void list(Map<ShardId, ShardAttributes> shardAttributesMap, DiscoveryNode[] nodes, ActionListener<NodesGatewayStartedShardsBatch> listener) {
        this.execute((ActionRequest)new Request(nodes, shardAttributesMap), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeGatewayStartedShardsBatch newNodeResponse(StreamInput in) throws IOException {
        return new NodeGatewayStartedShardsBatch(in);
    }

    @Override
    protected NodesGatewayStartedShardsBatch newResponse(Request request, List<NodeGatewayStartedShardsBatch> responses, List<FailedNodeException> failures) {
        return new NodesGatewayStartedShardsBatch(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeGatewayStartedShardsBatch nodeOperation(NodeRequest request) {
        HashMap<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> shardsOnNode = new HashMap<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard>();
        for (Map.Entry<ShardId, ShardAttributes> shardAttr : request.shardAttributes.entrySet()) {
            ShardId shardId = shardAttr.getKey();
            try {
                shardsOnNode.put(shardId, TransportNodesGatewayStartedShardHelper.getShardInfoOnLocalNode(this.logger, shardId, this.namedXContentRegistry, this.nodeEnv, this.indicesService, shardAttr.getValue().getCustomDataPath(), this.settings, this.clusterService));
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException || e.getMessage().contains("node doesn't have meta data for index") || e instanceof IOException) {
                    shardsOnNode.put(shardId, null);
                    continue;
                }
                shardsOnNode.put(shardId, new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(null, false, null, e));
            }
        }
        return new NodeGatewayStartedShardsBatch(this.clusterService.localNode(), shardsOnNode);
    }

    public static class NodeGatewayStartedShardsBatch
    extends BaseNodeResponse {
        private final Map<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> nodeGatewayStartedShardsBatch;

        public Map<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> getNodeGatewayStartedShardsBatch() {
            return this.nodeGatewayStartedShardsBatch;
        }

        public NodeGatewayStartedShardsBatch(StreamInput in) throws IOException {
            super(in);
            this.nodeGatewayStartedShardsBatch = in.readMap(ShardId::new, i -> {
                if (i.readBoolean()) {
                    return new TransportNodesGatewayStartedShardHelper.GatewayStartedShard(i);
                }
                return null;
            });
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.nodeGatewayStartedShardsBatch, (o, k) -> k.writeTo(o), (o, v) -> {
                if (v != null) {
                    o.writeBoolean(true);
                    v.writeTo(o);
                } else {
                    o.writeBoolean(false);
                }
            });
        }

        public NodeGatewayStartedShardsBatch(DiscoveryNode node, Map<ShardId, TransportNodesGatewayStartedShardHelper.GatewayStartedShard> nodeGatewayStartedShardsBatch) {
            super(node);
            this.nodeGatewayStartedShardsBatch = nodeGatewayStartedShardsBatch;
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final Map<ShardId, ShardAttributes> shardAttributes;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardAttributes = in.readMap(ShardId::new, ShardAttributes::new);
        }

        public Request(DiscoveryNode[] nodes, Map<ShardId, ShardAttributes> shardAttributes) {
            super(nodes);
            this.shardAttributes = Objects.requireNonNull(shardAttributes);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.shardAttributes, (o, k) -> k.writeTo(o), (o, v) -> v.writeTo(o));
        }

        public Map<ShardId, ShardAttributes> getShardAttributes() {
            return this.shardAttributes;
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private final Map<ShardId, ShardAttributes> shardAttributes;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardAttributes = in.readMap(ShardId::new, ShardAttributes::new);
        }

        public NodeRequest(Request request) {
            this.shardAttributes = Objects.requireNonNull(request.getShardAttributes());
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.shardAttributes, (o, k) -> k.writeTo(o), (o, v) -> v.writeTo(o));
        }
    }

    public static class NodesGatewayStartedShardsBatch
    extends BaseNodesResponse<NodeGatewayStartedShardsBatch> {
        public NodesGatewayStartedShardsBatch(StreamInput in) throws IOException {
            super(in);
        }

        public NodesGatewayStartedShardsBatch(ClusterName clusterName, List<NodeGatewayStartedShardsBatch> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeGatewayStartedShardsBatch> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeGatewayStartedShardsBatch::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeGatewayStartedShardsBatch> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

