/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import io.skylite.Build;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.ReleasableBytesStreamOutput;
import io.skylite.core.common.network.CloseableChannel;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.http.HttpRequest;
import io.skylite.core.http.HttpResponse;
import io.skylite.core.http.HttpUtils;
import io.skylite.core.rest.AbstractRestChannel;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.http.CorsHandler;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpTracer;

public class DefaultRestChannel
extends AbstractRestChannel
implements RestChannel {
    static final String CLOSE = "close";
    static final String CONNECTION = "connection";
    static final String KEEP_ALIVE = "keep-alive";
    static final String CONTENT_TYPE = "content-type";
    static final String CONTENT_LENGTH = "content-length";
    static final String SET_COOKIE = "set-cookie";
    static final String SERVER_VERSION = "X-OpenSearch-Version";
    static final String SERVER_VERSION_VALUE = "OpenSearch/" + Build.CURRENT.getQualifiedVersion() + " (" + Build.CURRENT.getDistribution() + ")";
    private final HttpRequest httpRequest;
    private final BigArrays bigArrays;
    private final HttpHandlingSettings settings;
    private final ThreadContext threadContext;
    private final HttpChannel httpChannel;
    private final CorsHandler corsHandler;
    private final Map<String, List<String>> SERVER_VERSION_HEADER = Map.of("X-OpenSearch-Version", List.of(SERVER_VERSION_VALUE));
    @Nullable
    private final HttpTracer tracerLog;

    DefaultRestChannel(HttpChannel httpChannel, HttpRequest httpRequest, RestRequest request, BigArrays bigArrays, HttpHandlingSettings settings, ThreadContext threadContext, CorsHandler corsHandler, @Nullable HttpTracer tracerLog) {
        super(request, settings.getDetailedErrorsEnabled());
        this.httpChannel = httpChannel;
        this.httpRequest = httpRequest;
        this.bigArrays = bigArrays;
        this.settings = settings;
        this.threadContext = threadContext;
        this.corsHandler = corsHandler;
        this.tracerLog = tracerLog;
    }

    protected BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(RestResponse restResponse) {
        String contentLength;
        String opaque;
        boolean success;
        block13: {
            Releasable[] releasableArray = new Releasable[1];
            releasableArray[0] = () -> ((HttpRequest)this.httpRequest).release();
            Releasables.closeWhileHandlingException((Releasable[])releasableArray);
            ArrayList<Releasable> toClose = new ArrayList<Releasable>(3);
            if (HttpUtils.shouldCloseConnection((HttpRequest)this.httpRequest)) {
                toClose.add(() -> CloseableChannel.closeChannel((CloseableChannel)this.httpChannel));
            }
            success = false;
            opaque = null;
            contentLength = null;
            try {
                BytesReference finalContent;
                block12: {
                    BytesReference content = restResponse.content();
                    if (content instanceof Releasable) {
                        toClose.add((Releasable)content);
                    }
                    finalContent = content;
                    try {
                        if (this.request.method() == RestRequest.Method.HEAD) {
                            finalContent = BytesArray.EMPTY;
                        }
                    }
                    catch (IllegalArgumentException ignored) {
                        if ($assertionsDisabled || restResponse.status() == RestStatus.METHOD_NOT_ALLOWED) break block12;
                        throw new AssertionError((Object)"request HTTP method is unsupported but HTTP status is not METHOD_NOT_ALLOWED(405)");
                    }
                }
                HttpResponse httpResponse = this.httpRequest.createResponse(restResponse.status(), finalContent);
                this.corsHandler.setCorsResponseHeaders(this.httpRequest, httpResponse);
                opaque = this.request.header("X-Opaque-Id");
                if (opaque != null) {
                    this.setHeaderField(httpResponse, "X-Opaque-Id", opaque);
                }
                this.addCustomHeaders(httpResponse, restResponse.getHeaders());
                this.addCustomHeaders(httpResponse, this.threadContext.getResponseHeaders());
                this.addCustomHeaders(httpResponse, this.SERVER_VERSION_HEADER);
                this.setHeaderField(httpResponse, CONTENT_TYPE, restResponse.contentType(), false);
                contentLength = String.valueOf(restResponse.content().length());
                this.setHeaderField(httpResponse, CONTENT_LENGTH, contentLength, false);
                this.addCookies(httpResponse);
                BytesStreamOutput bytesStreamOutput = this.bytesOutputOrNull();
                if (bytesStreamOutput instanceof ReleasableBytesStreamOutput) {
                    toClose.add((Releasable)bytesStreamOutput);
                }
                ActionListener listener = ActionListenerHelper.wrap(() -> Releasables.close((Iterable)toClose));
                this.httpChannel.sendResponse(httpResponse, listener);
                success = true;
                if (success) break block13;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close(toClose);
                }
                if (this.tracerLog != null) {
                    this.tracerLog.traceResponse(restResponse, this.httpChannel, contentLength, opaque, this.request.getRequestId(), success);
                }
                throw throwable;
            }
            Releasables.close(toClose);
        }
        if (this.tracerLog != null) {
            this.tracerLog.traceResponse(restResponse, this.httpChannel, contentLength, opaque, this.request.getRequestId(), success);
        }
    }

    private void setHeaderField(HttpResponse response, String headerField, String value) {
        this.setHeaderField(response, headerField, value, true);
    }

    private void setHeaderField(HttpResponse response, String headerField, String value, boolean override) {
        if (override || !response.containsHeader(headerField)) {
            response.addHeader(headerField, value);
        }
    }

    private void addCustomHeaders(HttpResponse response, Map<String, List<String>> customHeaders) {
        if (customHeaders != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    this.setHeaderField(response, headerEntry.getKey(), headerValue);
                }
            }
        }
    }

    private void addCookies(HttpResponse response) {
        List cookies;
        if (this.settings.isResetCookies() && !(cookies = this.request.getHttpRequest().strictCookies()).isEmpty()) {
            for (String cookie : cookies) {
                response.addHeader(SET_COOKIE, cookie);
            }
        }
    }
}

