/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.ReleasableBytesStreamOutput;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.http.HttpChunk;
import io.skylite.core.http.HttpRequest;
import io.skylite.core.http.StreamingHttpChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.rest.StreamingRestChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.http.CorsHandler;
import org.opensearch.http.DefaultRestChannel;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpTracer;
import org.reactivestreams.Subscriber;

class DefaultStreamingRestChannel
extends DefaultRestChannel
implements StreamingRestChannel {
    private final StreamingHttpChannel streamingHttpChannel;
    @Nullable
    private final HttpTracer tracerLog;

    DefaultStreamingRestChannel(StreamingHttpChannel streamingHttpChannel, HttpRequest httpRequest, RestRequest request, BigArrays bigArrays, HttpHandlingSettings settings, ThreadContext threadContext, CorsHandler corsHandler, @Nullable HttpTracer tracerLog) {
        super((HttpChannel)streamingHttpChannel, httpRequest, request, bigArrays, settings, threadContext, corsHandler, tracerLog);
        this.streamingHttpChannel = streamingHttpChannel;
        this.tracerLog = tracerLog;
    }

    public void subscribe(Subscriber<? super HttpChunk> subscriber) {
        this.streamingHttpChannel.subscribe(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChunk(HttpChunk chunk) {
        String opaque = null;
        boolean success = false;
        ArrayList<Object> toClose = new ArrayList<Object>(3);
        String contentLength = null;
        try {
            opaque = this.request.header("X-Opaque-Id");
            contentLength = String.valueOf(chunk.content().length());
            toClose.add(chunk);
            BytesStreamOutput bytesStreamOutput = this.newBytesOutput();
            if (bytesStreamOutput instanceof ReleasableBytesStreamOutput) {
                toClose.add((Releasable)bytesStreamOutput);
            }
            ActionListener listener = ActionListenerHelper.wrap(() -> Releasables.close((Iterable)toClose));
            this.streamingHttpChannel.sendChunk(chunk, listener);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close(toClose);
            }
            if (this.tracerLog != null) {
                this.tracerLog.traceChunk(chunk, this.streamingHttpChannel, contentLength, opaque, this.request.getRequestId(), success);
            }
        }
    }

    public void prepareResponse(RestStatus status, Map<String, List<String>> headers) {
        this.streamingHttpChannel.prepareResponse(status.getStatus(), headers);
    }

    public boolean isReadable() {
        return this.streamingHttpChannel.isReadable();
    }

    public boolean isWritable() {
        return this.streamingHttpChannel.isWritable();
    }
}

