/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import io.skylite.common.Nullable;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.common.logging.Loggers;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.cluster.AllocatedIndicesInterface;
import io.skylite.core.settings.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

final class CompositeIndexEventListener
implements IndexEventListener {
    private final List<IndexEventListener> listeners;
    private final Logger logger;

    CompositeIndexEventListener(IndexSettings indexSettings, Collection<IndexEventListener> listeners) {
        for (IndexEventListener listener : listeners) {
            if (listener != null) continue;
            throw new IllegalArgumentException("listeners must be non-null");
        }
        this.listeners = Collections.unmodifiableList(new ArrayList<IndexEventListener>(listeners));
        this.logger = Loggers.getLogger(this.getClass(), (Index)indexSettings.getIndex(), (String[])new String[0]);
    }

    public void shardRoutingChanged(BaseIndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.shardRoutingChanged(indexShard, oldRouting, newRouting);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke shard touring changed callback", (Object)indexShard.shardId().getId()), (Throwable)e);
            }
        }
    }

    public void afterIndexShardCreated(BaseIndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardCreated(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard created callback", (Object)indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    public void afterIndexShardStarted(BaseIndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardStarted(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard started callback", (Object)indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeIndexShardClosed(ShardId shardId, @Nullable BaseIndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke before shard closed callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    public void afterIndexShardClosed(ShardId shardId, @Nullable BaseIndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard closed callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    public void indexShardStateChanged(BaseIndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.indexShardStateChanged(indexShard, previousState, indexShard.state(), reason);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke index shard state changed callback", (Object)indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeIndexCreated(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexCreated(index, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index created callback", (Throwable)e);
                throw e;
            }
        }
    }

    public void afterIndexCreated(BaseIndexService indexService) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexCreated(indexService);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke after index created callback", (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardCreated(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke before shard created callback", (Object)shardId), (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeIndexRemoved(BaseIndexService indexService, AllocatedIndicesInterface.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexRemoved(indexService, reason);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index removed callback", (Throwable)e);
                throw e;
            }
        }
    }

    public void afterIndexRemoved(Index index, IndexSettings indexSettings, AllocatedIndicesInterface.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexRemoved(index, indexSettings, reason);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke after index removed callback", (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardDeleted(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke before shard deleted callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardDeleted(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard deleted callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexAddedToCluster(index, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index added to cluster callback", (Throwable)e);
                throw e;
            }
        }
    }

    public void onStoreCreated(ShardId shardId) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.onStoreCreated(shardId);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke on store created", (Throwable)e);
                throw e;
            }
        }
    }

    public void onStoreClosed(ShardId shardId) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.onStoreClosed(shardId);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke on store closed", (Throwable)e);
                throw e;
            }
        }
    }

    public void beforeIndexShardRecovery(BaseIndexShard indexShard, IndexSettings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardRecovery(indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to invoke the listener before the shard recovery starts for {}", (Object)indexShard.shardId()), (Throwable)e);
                throw e;
            }
        }
    }
}

