/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.common.SetOnce;
import io.skylite.common.TriFunction;
import io.skylite.common.annotation.PublicApi;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.index.cache.query.DisabledQueryCache;
import io.skylite.core.index.cache.query.QueryCache;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.SearchOperationListener;
import io.skylite.core.index.similarity.SimilarityProviders;
import io.skylite.core.index.similarity.SimilarityService;
import io.skylite.core.index.store.FsDirectoryFactory;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.index.store.remote.directory.RemoteSnapshotDirectoryFactory;
import io.skylite.core.index.translog.TranslogFactory;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.fielddata.cache.IndicesFieldDataCache;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.mapper.MapperRegistry;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.plugins.IndexStorePlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.similarities.Similarity;
import org.opensearch.index.CompositeIndexEventListener;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexingSlowLog;
import org.opensearch.index.SearchSlowLog;
import org.opensearch.index.cache.query.IndexQueryCache;
import org.opensearch.index.engine.EngineConfigFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.indices.IndicesQueryCache;

@PublicApi(since="1.0.0")
public final class IndexModule {
    private static final FsDirectoryFactory DEFAULT_DIRECTORY_FACTORY = new FsDirectoryFactory();
    private static final IndexStorePlugin.RecoveryStateFactory DEFAULT_RECOVERY_STATE_FACTORY = RecoveryState::new;
    private final IndexSettings indexSettings;
    private final AnalysisRegistry analysisRegistry;
    private final EngineFactory engineFactory;
    private final EngineConfigFactory engineConfigFactory;
    private SetOnce<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> indexReaderWrapper = new SetOnce();
    private final Set<IndexEventListener> indexEventListeners = new HashSet<IndexEventListener>();
    private final Map<String, TriFunction<Settings, Version, Object, Similarity>> similarities = new HashMap<String, TriFunction<Settings, Version, Object, Similarity>>();
    private final Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories;
    private final SetOnce<BiFunction<IndexSettings, IndicesQueryCache, QueryCache>> forceQueryCacheProvider = new SetOnce();
    private final List<SearchOperationListener> searchOperationListeners = new ArrayList<SearchOperationListener>();
    private final List<IndexingOperationListener> indexOperationListeners = new ArrayList<IndexingOperationListener>();
    private final IndexNameExpressionResolver expressionResolver;
    private final AtomicBoolean frozen = new AtomicBoolean(false);
    private final BooleanSupplier allowExpensiveQueries;
    private final Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories;

    public IndexModule(IndexSettings indexSettings, AnalysisRegistry analysisRegistry, EngineFactory engineFactory, EngineConfigFactory engineConfigFactory, Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories, BooleanSupplier allowExpensiveQueries, IndexNameExpressionResolver expressionResolver, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories) {
        this.indexSettings = indexSettings;
        this.analysisRegistry = analysisRegistry;
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.engineConfigFactory = Objects.requireNonNull(engineConfigFactory);
        this.searchOperationListeners.add(new SearchSlowLog(indexSettings));
        this.indexOperationListeners.add(new IndexingSlowLog(indexSettings));
        this.directoryFactories = Collections.unmodifiableMap(directoryFactories);
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.expressionResolver = expressionResolver;
        this.recoveryStateFactories = recoveryStateFactories;
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer);
    }

    public <T> void addSettingsUpdateConsumer(Setting<T> setting, Consumer<T> consumer, Consumer<T> validator) {
        this.ensureNotFrozen();
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.indexSettings.getScopedSettings().addSettingsUpdateConsumer(setting, consumer, validator);
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public Index getIndex() {
        return this.indexSettings.getIndex();
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    public void addIndexEventListener(IndexEventListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexEventListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexEventListeners.add(listener);
    }

    public void addSearchOperationListener(SearchOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.searchOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.searchOperationListeners.add(listener);
    }

    public void addIndexOperationListener(IndexingOperationListener listener) {
        this.ensureNotFrozen();
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.indexOperationListeners.contains(listener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.indexOperationListeners.add(listener);
    }

    public void addSimilarity(String name, TriFunction<Settings, Version, Object, Similarity> similarity) {
        this.ensureNotFrozen();
        if (this.similarities.containsKey(name) || SimilarityProviders.BUILT_IN.containsKey(name)) {
            throw new IllegalArgumentException("similarity for name: [" + name + " is already registered");
        }
        this.similarities.put(name, similarity);
    }

    public void setReaderWrapper(Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> indexReaderWrapperFactory) {
        this.ensureNotFrozen();
        this.indexReaderWrapper.set(indexReaderWrapperFactory);
    }

    IndexEventListener freeze() {
        if (this.frozen.compareAndSet(false, true)) {
            return new CompositeIndexEventListener(this.indexSettings, this.indexEventListeners);
        }
        throw new IllegalStateException("already frozen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexService newIndexService(BaseIndexService.IndexCreationContext indexCreationContext, NodeEnvironment environment, NamedXContentRegistry xContentRegistry, IndexService.ShardStoreDeleter shardStoreDeleter, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, ClusterService clusterService, Client client, IndicesQueryCache indicesQueryCache, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, NamedWriteableRegistry namedWriteableRegistry, BooleanSupplier idFieldDataEnabled, AggregationRegistry aggregationRegistry, IndexStorePlugin.DirectoryFactory remoteDirectoryFactory, BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier, Supplier<TimeValue> clusterDefaultRefreshIntervalSupplier, RecoverySettings recoverySettings, RemoteStoreSettings remoteStoreSettings) throws IOException {
        IndexService indexService;
        block4: {
            IndexEventListener eventListener = this.freeze();
            Function readerWrapperFactory = this.indexReaderWrapper.get() == null ? shard -> null : (Function)this.indexReaderWrapper.get();
            eventListener.beforeIndexCreated(this.indexSettings.getIndex(), this.indexSettings.getSettings());
            IndexStorePlugin.DirectoryFactory directoryFactory = IndexModule.getDirectoryFactory(this.indexSettings, this.directoryFactories);
            IndexStorePlugin.RecoveryStateFactory recoveryStateFactory = IndexModule.getRecoveryStateFactory(this.indexSettings, this.recoveryStateFactories);
            Object queryCache = null;
            IndexAnalyzers indexAnalyzers = null;
            boolean success = false;
            try {
                BiFunction queryCacheProvider;
                queryCache = ((Boolean)this.indexSettings.getValue(IndexModuleSettings.INDEX_QUERY_CACHE_ENABLED_SETTING)).booleanValue() ? ((queryCacheProvider = (BiFunction)this.forceQueryCacheProvider.get()) == null ? new IndexQueryCache(this.indexSettings, indicesQueryCache) : (QueryCache)queryCacheProvider.apply(this.indexSettings, indicesQueryCache)) : new DisabledQueryCache(this.indexSettings);
                if (BaseIndexService.needsMapperService((IndexSettings)this.indexSettings, (BaseIndexService.IndexCreationContext)indexCreationContext)) {
                    indexAnalyzers = this.analysisRegistry.build(this.indexSettings);
                }
                IndexService indexService2 = new IndexService(this.indexSettings, indexCreationContext, environment, xContentRegistry, new SimilarityService(this.indexSettings, scriptService, this.similarities), shardStoreDeleter, indexAnalyzers, this.engineFactory, this.engineConfigFactory, circuitBreakerService, bigArrays, threadPool, scriptService, clusterService, client, (QueryCache)queryCache, directoryFactory, remoteDirectoryFactory, eventListener, readerWrapperFactory, mapperRegistry, indicesFieldDataCache, this.searchOperationListeners, this.indexOperationListeners, namedWriteableRegistry, idFieldDataEnabled, this.allowExpensiveQueries, this.expressionResolver, aggregationRegistry, recoveryStateFactory, translogFactorySupplier, clusterDefaultRefreshIntervalSupplier, recoverySettings, remoteStoreSettings);
                success = true;
                indexService = indexService2;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{queryCache, indexAnalyzers});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{queryCache, indexAnalyzers});
        }
        return indexService;
    }

    private static IndexStorePlugin.DirectoryFactory getDirectoryFactory(IndexSettings indexSettings, Map<String, IndexStorePlugin.DirectoryFactory> indexStoreFactories) {
        FsDirectoryFactory factory;
        String storeType = (String)indexSettings.getValue(IndexStoreSettings.INDEX_STORE_TYPE_SETTING);
        Boolean allowMmap = (Boolean)IndexStoreSettings.NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings());
        Object type = storeType.isEmpty() || IndexModuleSettings.Type.FS.getSettingsKey().equals(storeType) ? IndexModuleSettings.defaultStoreType((boolean)allowMmap) : (IndexModuleSettings.Type.containsSettingsKey((String)storeType) ? IndexModuleSettings.Type.fromSettingsKey((String)storeType) : null);
        if (!(allowMmap.booleanValue() || type != IndexModuleSettings.Type.MMAPFS && type != IndexModuleSettings.Type.HYBRIDFS)) {
            throw new IllegalArgumentException("store type [" + storeType + "] is not allowed because mmap is disabled");
        }
        if (storeType.isEmpty()) {
            factory = DEFAULT_DIRECTORY_FACTORY;
        } else {
            factory = indexStoreFactories.get(storeType);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown store type [" + storeType + "]");
            }
        }
        return factory;
    }

    private static IndexStorePlugin.RecoveryStateFactory getRecoveryStateFactory(IndexSettings indexSettings, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories) {
        String recoveryType = (String)indexSettings.getValue(IndexModuleSettings.INDEX_RECOVERY_TYPE_SETTING);
        if (recoveryType.isEmpty()) {
            return DEFAULT_RECOVERY_STATE_FACTORY;
        }
        IndexStorePlugin.RecoveryStateFactory factory = recoveryStateFactories.get(recoveryType);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown recovery type [" + recoveryType + "]");
        }
        return factory;
    }

    public MapperService newIndexMapperService(NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, ScriptService scriptService) throws IOException {
        return new MapperService(this.indexSettings, this.analysisRegistry.build(this.indexSettings), xContentRegistry, new SimilarityService(this.indexSettings, scriptService, this.similarities), mapperRegistry, () -> {
            throw new UnsupportedOperationException("no index query shard context available");
        }, () -> false, scriptService);
    }

    public void forceQueryCacheProvider(BiFunction<IndexSettings, IndicesQueryCache, QueryCache> queryCacheProvider) {
        this.ensureNotFrozen();
        this.forceQueryCacheProvider.set(queryCacheProvider);
    }

    private void ensureNotFrozen() {
        if (this.frozen.get()) {
            throw new IllegalStateException("Can't modify IndexModule once the index service has been created");
        }
    }

    public static Map<String, IndexStorePlugin.DirectoryFactory> createBuiltInDirectoryFactories(Supplier<RepositoriesService> repositoriesService, ThreadPool threadPool, FileCache remoteStoreFileCache) {
        HashMap<String, IndexStorePlugin.DirectoryFactory> factories = new HashMap<String, IndexStorePlugin.DirectoryFactory>();
        block4: for (IndexModuleSettings.Type type : IndexModuleSettings.Type.values()) {
            switch (type) {
                case HYBRIDFS: 
                case NIOFS: 
                case FS: 
                case MMAPFS: 
                case SIMPLEFS: {
                    factories.put(type.getSettingsKey(), (IndexStorePlugin.DirectoryFactory)DEFAULT_DIRECTORY_FACTORY);
                    continue block4;
                }
                case REMOTE_SNAPSHOT: {
                    factories.put(type.getSettingsKey(), (IndexStorePlugin.DirectoryFactory)new RemoteSnapshotDirectoryFactory(repositoriesService, threadPool, remoteStoreFileCache));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("No directory factory mapping for built-in type " + String.valueOf(type));
                }
            }
        }
        return factories;
    }
}

