/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.Index;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.index.IndexModule;

public class IndicesModuleRequest
extends TransportRequest {
    private final Index index;
    private final Settings indexSettings;

    public IndicesModuleRequest(IndexModule indexModule) {
        this.index = indexModule.getIndex();
        this.indexSettings = indexModule.getSettings();
    }

    public IndicesModuleRequest(StreamInput in) throws IOException {
        super(in);
        this.index = new Index(in);
        this.indexSettings = Settings.readSettingsFromStream((StreamInput)in);
    }

    public IndicesModuleRequest(Index index, Settings settings) {
        this.index = index;
        this.indexSettings = settings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.index.writeTo(out);
        Settings.writeSettingsToStream((Settings)this.indexSettings, (StreamOutput)out);
    }

    public String toString() {
        return "IndicesModuleRequest{index=" + String.valueOf(this.index) + ", indexSettings=" + String.valueOf(this.indexSettings) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndicesModuleRequest that = (IndicesModuleRequest)((Object)o);
        return Objects.equals(this.index, that.index) && Objects.equals(this.indexSettings, that.indexSettings);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.indexSettings);
    }
}

