/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.AbstractAsyncTask;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.SegmentReplicationPerGroupStats;
import io.skylite.core.index.SegmentReplicationShardStats;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.index.IndexService;
import org.opensearch.index.SegmentReplicationStats;
import org.opensearch.index.SegmentReplicationStatsTracker;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class SegmentReplicationPressureService
implements Closeable {
    private volatile boolean isSegmentReplicationBackpressureEnabled;
    private volatile int maxCheckpointsBehind;
    private volatile double maxAllowedStaleReplicas;
    private volatile TimeValue replicationTimeLimitBackpressure;
    private volatile TimeValue replicationTimeLimitFailReplica;
    private static final Logger logger = LogManager.getLogger(SegmentReplicationPressureService.class);
    public static final Setting<Boolean> SEGMENT_REPLICATION_INDEXING_PRESSURE_ENABLED = Setting.boolSetting((String)"segrep.pressure.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> MAX_INDEXING_CHECKPOINTS = Setting.intSetting((String)"segrep.pressure.checkpoint.limit", (int)4, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> MAX_REPLICATION_TIME_BACKPRESSURE_SETTING = Setting.positiveTimeSetting((String)"segrep.pressure.time.limit", (TimeValue)TimeValue.timeValueMinutes((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> MAX_REPLICATION_LIMIT_STALE_REPLICA_SETTING = Setting.positiveTimeSetting((String)"segrep.replication.time.limit", (TimeValue)TimeValue.timeValueMinutes((long)0L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Double> MAX_ALLOWED_STALE_SHARDS = Setting.doubleSetting((String)"segrep.pressure.replica.stale.limit", (double)0.5, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final IndicesService indicesService;
    private final ThreadPool threadPool;
    private final SegmentReplicationStatsTracker tracker;
    private final ShardStateAction shardStateAction;
    private final AsyncFailStaleReplicaTask failStaleReplicaTask;

    @Inject
    public SegmentReplicationPressureService(Settings settings, ClusterService clusterService, IndicesService indicesService, ShardStateAction shardStateAction, SegmentReplicationStatsTracker tracker, ThreadPool threadPool) {
        this.indicesService = indicesService;
        this.tracker = tracker;
        this.shardStateAction = shardStateAction;
        this.threadPool = threadPool;
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.isSegmentReplicationBackpressureEnabled = (Boolean)SEGMENT_REPLICATION_INDEXING_PRESSURE_ENABLED.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SEGMENT_REPLICATION_INDEXING_PRESSURE_ENABLED, this::setSegmentReplicationBackpressureEnabled);
        this.maxCheckpointsBehind = (Integer)MAX_INDEXING_CHECKPOINTS.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MAX_INDEXING_CHECKPOINTS, this::setMaxCheckpointsBehind);
        this.replicationTimeLimitBackpressure = (TimeValue)MAX_REPLICATION_TIME_BACKPRESSURE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MAX_REPLICATION_TIME_BACKPRESSURE_SETTING, this::setReplicationTimeLimitBackpressure);
        this.replicationTimeLimitFailReplica = (TimeValue)MAX_REPLICATION_LIMIT_STALE_REPLICA_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MAX_REPLICATION_LIMIT_STALE_REPLICA_SETTING, this::setReplicationTimeLimitFailReplica);
        this.maxAllowedStaleReplicas = (Double)MAX_ALLOWED_STALE_SHARDS.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MAX_ALLOWED_STALE_SHARDS, this::setMaxAllowedStaleReplicas);
        this.failStaleReplicaTask = new AsyncFailStaleReplicaTask(this);
    }

    AsyncFailStaleReplicaTask getFailStaleReplicaTask() {
        return this.failStaleReplicaTask;
    }

    public void isSegrepLimitBreached(ShardId shardId) {
        IndexService indexService = this.indicesService.indexService(shardId.getIndex());
        if (indexService != null) {
            IndexShard shard = (IndexShard)indexService.getShard(shardId.id());
            if (this.isSegmentReplicationBackpressureEnabled && shard.indexSettings().isSegRepEnabledOrRemoteNode() && shard.routingEntry().primary()) {
                this.validateReplicationGroup(shard);
            }
        }
    }

    private void validateReplicationGroup(IndexShard shard) {
        double maxStaleLimit;
        float percentStale;
        Set<SegmentReplicationShardStats> replicaStats = shard.getReplicationStatsForTrackedReplicas();
        Set<SegmentReplicationShardStats> staleReplicas = this.getStaleReplicas(replicaStats);
        if (!staleReplicas.isEmpty() && (double)(percentStale = (float)staleReplicas.size() * 100.0f / (float)(shard.getReplicationGroup().getInSyncAllocationIds().size() - 1)) >= (maxStaleLimit = this.maxAllowedStaleReplicas * 100.0)) {
            this.tracker.incrementRejectionCount(shard.shardId());
            logger.warn("Rejecting write requests for shard, stale shards [{}%] shards: {}", (Object)Float.valueOf(percentStale), staleReplicas);
            throw new SkyliteRejectedExecutionException("rejected execution on primary shard: " + String.valueOf(shard.shardId()) + " Stale Replicas: " + String.valueOf(staleReplicas) + "]", false);
        }
    }

    private Set<SegmentReplicationShardStats> getStaleReplicas(Set<SegmentReplicationShardStats> replicas) {
        return replicas.stream().filter(entry -> entry.getCheckpointsBehindCount() > (long)this.maxCheckpointsBehind).filter(entry -> entry.getCurrentReplicationTimeMillis() > this.replicationTimeLimitBackpressure.millis()).collect(Collectors.toSet());
    }

    public SegmentReplicationStats nodeStats() {
        return this.tracker.getStats();
    }

    public SegmentReplicationPerGroupStats getStatsForShard(IndexShard indexShard) {
        return this.tracker.getStatsForShard(indexShard);
    }

    public boolean isSegmentReplicationBackpressureEnabled() {
        return this.isSegmentReplicationBackpressureEnabled;
    }

    public void setSegmentReplicationBackpressureEnabled(boolean segmentReplicationBackpressureEnabled) {
        this.isSegmentReplicationBackpressureEnabled = segmentReplicationBackpressureEnabled;
    }

    public void setMaxCheckpointsBehind(int maxCheckpointsBehind) {
        this.maxCheckpointsBehind = maxCheckpointsBehind;
    }

    public void setMaxAllowedStaleReplicas(double maxAllowedStaleReplicas) {
        this.maxAllowedStaleReplicas = maxAllowedStaleReplicas;
    }

    public void setReplicationTimeLimitFailReplica(TimeValue replicationTimeLimitFailReplica) {
        this.replicationTimeLimitFailReplica = replicationTimeLimitFailReplica;
    }

    public void setReplicationTimeLimitBackpressure(TimeValue replicationTimeLimitBackpressure) {
        this.replicationTimeLimitBackpressure = replicationTimeLimitBackpressure;
    }

    @Override
    public void close() throws IOException {
        this.failStaleReplicaTask.close();
    }

    static final class AsyncFailStaleReplicaTask
    extends AbstractAsyncTask {
        final SegmentReplicationPressureService pressureService;
        static final TimeValue INTERVAL = TimeValue.timeValueSeconds((long)30L);

        AsyncFailStaleReplicaTask(SegmentReplicationPressureService pressureService) {
            super(logger, pressureService.threadPool, INTERVAL, true);
            this.pressureService = pressureService;
            this.rescheduleIfNecessary();
        }

        protected boolean mustReschedule() {
            return true;
        }

        protected void runInternal() {
            if (!TimeValue.ZERO.equals((Object)this.pressureService.replicationTimeLimitFailReplica)) {
                SegmentReplicationStats stats = this.pressureService.tracker.getStats();
                stats.getShardStats().entrySet().stream().flatMap(entry -> this.pressureService.getStaleReplicas(((SegmentReplicationPerGroupStats)entry.getValue()).getReplicaStats()).stream().map(r -> Tuple.tuple((Object)((ShardId)entry.getKey()), (Object)r.getCurrentReplicationTimeMillis()))).max(Comparator.comparingLong(Tuple::v2)).map(Tuple::v1).ifPresent(shardId -> {
                    Set<SegmentReplicationShardStats> staleReplicas = this.pressureService.getStaleReplicas(stats.getShardStats().get(shardId).getReplicaStats());
                    IndexService indexService = this.pressureService.indicesService.indexService(shardId.getIndex());
                    if (indexService.getIndexSettings() != null && !indexService.getIndexSettings().isSegRepEnabledOrRemoteNode()) {
                        return;
                    }
                    BaseIndexShard basePrimaryShard = indexService.getShard(shardId.getId());
                    IndexShard primaryShard = (IndexShard)basePrimaryShard;
                    for (final SegmentReplicationShardStats staleReplica : staleReplicas) {
                        if (staleReplica.getCurrentReplicationTimeMillis() <= this.pressureService.replicationTimeLimitFailReplica.millis()) continue;
                        this.pressureService.shardStateAction.remoteShardFailed((ShardId)shardId, staleReplica.getAllocationId(), primaryShard.getOperationPrimaryTerm(), true, "replica too far behind primary, marking as stale", null, new ActionListener<Void>(this){

                            public void onResponse(Void unused) {
                                logger.trace("Successfully failed remote shardId [{}] allocation id [{}]", (Object)shardId, (Object)staleReplica.getAllocationId());
                            }

                            public void onFailure(Exception e) {
                                logger.error("Failed to send remote shard failure", (Throwable)e);
                            }
                        });
                    }
                });
            }
        }

        protected String getThreadPool() {
            return "generic";
        }

        public String toString() {
            return "fail_stale_replica";
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(SEGMENT_REPLICATION_INDEXING_PRESSURE_ENABLED, MAX_INDEXING_CHECKPOINTS, MAX_REPLICATION_TIME_BACKPRESSURE_SETTING, MAX_REPLICATION_LIMIT_STALE_REPLICA_SETTING, MAX_ALLOWED_STALE_SHARDS);
        }
    }
}

