/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import io.skylite.Version;
import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.index.engine.CompletionStatsCache;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.engine.EngineConfig;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.engine.LuceniaReaderManager;
import io.skylite.core.index.engine.SafeCommitInfo;
import io.skylite.core.index.engine.Segment;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.seqno.SequenceNumbers;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.translog.DefaultTranslogDeletionPolicy;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogConfig;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogManager;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.index.translog.TranslogStats;
import io.skylite.core.lucene.XLucene;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.mapper.DocumentParser;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.search.suggest.completion.CompletionStats;
import io.skylite.core.transport.Transports;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.opensearch.index.translog.NoOpTranslogManager;

public class ReadOnlyEngine
extends Engine {
    private final SegmentInfos lastCommittedSegmentInfos;
    private final SeqNoStats seqNoStats;
    private final LuceniaReaderManager readerManager;
    private final IndexCommit indexCommit;
    private final Lock indexWriterLock;
    private final SafeCommitInfo safeCommitInfo;
    private final CompletionStatsCache completionStatsCache;
    private final boolean requireCompleteHistory;
    private final TranslogManager translogManager;
    private final Version minimumSupportedVersion;
    protected volatile TranslogStats translogStats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadOnlyEngine(EngineConfig config, SeqNoStats seqNoStats, TranslogStats translogStats, boolean obtainLock, Function<DirectoryReader, DirectoryReader> readerWrapperFunction, boolean requireCompleteHistory) {
        super(config);
        this.requireCompleteHistory = requireCompleteHistory;
        this.minimumSupportedVersion = config.getIndexSettings().getExtendedCompatibilitySnapshotVersion();
        try {
            Store store = config.getStore();
            store.incRef();
            SkyliteDirectoryReader reader = null;
            Directory directory = store.directory();
            Lock indexWriterLock = null;
            boolean success = false;
            try {
                indexWriterLock = obtainLock ? directory.obtainLock("write.lock") : null;
                this.lastCommittedSegmentInfos = this.isExtendedCompatibility() ? XLucene.readSegmentInfos((Directory)directory, (Version)this.minimumSupportedVersion) : XLucene.readSegmentInfos((Directory)directory);
                if (seqNoStats == null) {
                    seqNoStats = ReadOnlyEngine.buildSeqNoStats(config, this.lastCommittedSegmentInfos);
                    this.ensureMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats);
                }
                this.seqNoStats = seqNoStats;
                this.indexCommit = XLucene.getIndexCommit((SegmentInfos)this.lastCommittedSegmentInfos, (Directory)directory);
                reader = this.wrapReader(this.open(this.indexCommit), readerWrapperFunction);
                this.readerManager = new LuceniaReaderManager(reader);
                assert (translogStats != null || obtainLock) : "mutiple translogs instances should not be opened at the same time";
                this.translogStats = translogStats != null ? translogStats : ReadOnlyEngine.translogStats(config, this.lastCommittedSegmentInfos);
                this.indexWriterLock = indexWriterLock;
                this.safeCommitInfo = new SafeCommitInfo(seqNoStats.getLocalCheckpoint(), this.lastCommittedSegmentInfos.totalMaxDoc());
                this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
                this.translogManager = new NoOpTranslogManager(this.shardId, this.readLock, () -> ((ReadOnlyEngine)this).ensureOpen(), this.translogStats, new TranslogSnapshotIterator(this){

                    public void close() {
                    }

                    public int totalOperations() {
                        return 0;
                    }

                    public TranslogOperation next() {
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = reader;
                closeableArray[1] = indexWriterLock;
                closeableArray[2] = () -> ((Store)store).decRef();
                IOUtils.close((Closeable[])closeableArray);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void ensureMaxSeqNoEqualsToGlobalCheckpoint(SeqNoStats seqNoStats) {
        if (!this.requireCompleteHistory) {
            return;
        }
        assert (this.assertMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats.getMaxSeqNo(), seqNoStats.getGlobalCheckpoint()));
        if (seqNoStats.getMaxSeqNo() != seqNoStats.getGlobalCheckpoint()) {
            throw new IllegalStateException("Maximum sequence number [" + seqNoStats.getMaxSeqNo() + "] from last commit does not match global checkpoint [" + seqNoStats.getGlobalCheckpoint() + "]");
        }
    }

    protected boolean assertMaxSeqNoEqualsToGlobalCheckpoint(long maxSeqNo, long globalCheckpoint) {
        assert (maxSeqNo == globalCheckpoint) : "max seq. no. [" + maxSeqNo + "] does not match [" + globalCheckpoint + "]";
        return true;
    }

    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
    }

    protected final SkyliteDirectoryReader wrapReader(DirectoryReader reader, Function<DirectoryReader, DirectoryReader> readerWrapperFunction) throws IOException {
        reader = readerWrapperFunction.apply(reader);
        return SkyliteDirectoryReader.wrap((DirectoryReader)reader, (ShardId)this.engineConfig.getShardId());
    }

    protected DirectoryReader open(IndexCommit commit) throws IOException {
        assert (Transports.assertNotTransportThread((String)"opening index commit of a read-only engine"));
        DirectoryReader reader = this.isExtendedCompatibility() ? DirectoryReader.open((IndexCommit)commit, (int)this.minimumSupportedVersion.luceneVersion.major, null) : DirectoryReader.open((IndexCommit)commit);
        return new SoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
    }

    private boolean isExtendedCompatibility() {
        return Version.CURRENT.minimumIndexCompatibilityVersion().onOrAfter(this.minimumSupportedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = this.readerManager;
                closeableArray[1] = this.indexWriterLock;
                closeableArray[2] = () -> ((Store)this.store).decRef();
                IOUtils.close((Closeable[])closeableArray);
            }
            catch (Exception ex) {
                this.logger.warn("failed to close reader", (Throwable)ex);
            }
            finally {
                closedLatch.countDown();
            }
        }
    }

    private static SeqNoStats buildSeqNoStats(EngineConfig config, SegmentInfos infos) {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(infos.userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        return new SeqNoStats(maxSeqNo, localCheckpoint, config.getGlobalCheckpointSupplier().getAsLong());
    }

    private static TranslogStats translogStats(EngineConfig config, SegmentInfos infos) throws IOException {
        String translogUuid = (String)infos.getUserData().get("translog_uuid");
        if (translogUuid == null) {
            throw new IllegalStateException("commit doesn't contain translog unique id");
        }
        TranslogConfig translogConfig = config.getTranslogConfig();
        DefaultTranslogDeletionPolicy translogDeletionPolicy = new DefaultTranslogDeletionPolicy(config.getIndexSettings().getTranslogRetentionSize().getBytes(), config.getIndexSettings().getTranslogRetentionAge().getMillis(), config.getIndexSettings().getTranslogRetentionTotalFiles());
        long localCheckpoint = Long.parseLong((String)infos.getUserData().get("local_checkpoint"));
        translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpoint);
        try (Translog translog = config.getTranslogFactory().newTranslog(translogConfig, translogUuid, (TranslogDeletionPolicy)translogDeletionPolicy, config.getGlobalCheckpointSupplier(), config.getPrimaryTermSupplier(), seqNo -> {}, config.getStartedPrimarySupplier());){
            TranslogStats translogStats = translog.stats();
            return translogStats;
        }
    }

    public Engine.GetResult get(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) throws EngineException {
        return this.getFromSearcher(get, this.acquireSearcher("get", Engine.SearcherScope.EXTERNAL, searcherWrapper), false);
    }

    protected ReferenceManager<SkyliteDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return this.readerManager;
    }

    public TranslogManager translogManager() {
        return this.translogManager;
    }

    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    protected SegmentInfos getLatestSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    public String getHistoryUUID() {
        return (String)this.lastCommittedSegmentInfos.userData.get("history_uuid");
    }

    public long getWritingBytes() {
        return 0L;
    }

    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    public boolean isThrottled() {
        return false;
    }

    public EngineResult.IndexResult index(EngineOperation.Index index) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("indexing is not supported on a read-only engine");
    }

    public EngineResult.DeleteResult delete(EngineOperation.Delete delete) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("deletes are not supported on a read-only engine");
    }

    public EngineResult.NoOpResult noOp(EngineOperation.NoOp noOp) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("no-ops are not supported on a read-only engine");
    }

    public Closeable acquireHistoryRetentionLock() {
        return () -> {};
    }

    public TranslogSnapshotIterator newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accurateCount) {
        return this.newEmptySnapshot();
    }

    public int countNumberOfHistoryOperations(String source, long fromSeqNo, long toSeqNo) throws IOException {
        try (TranslogSnapshotIterator snapshot = this.newChangesSnapshot(source, fromSeqNo, toSeqNo, false, true);){
            int n = snapshot.totalOperations();
            return n;
        }
    }

    public boolean hasCompleteOperationHistory(String reason, long startingSeqNo) {
        return startingSeqNo > this.seqNoStats.getMaxSeqNo();
    }

    public long getMinRetainedSeqNo() {
        throw new UnsupportedOperationException();
    }

    public long getPersistedLocalCheckpoint() {
        return this.seqNoStats.getLocalCheckpoint();
    }

    public long getProcessedLocalCheckpoint() {
        return this.getPersistedLocalCheckpoint();
    }

    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return new SeqNoStats(this.seqNoStats.getMaxSeqNo(), this.seqNoStats.getLocalCheckpoint(), globalCheckpoint);
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.seqNoStats.getGlobalCheckpoint();
    }

    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    public List<Segment> segments(boolean verbose) {
        return Arrays.asList(this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose));
    }

    public void refresh(String source) {
    }

    public boolean maybeRefresh(String source) throws EngineException {
        return false;
    }

    public void writeIndexingBuffer() throws EngineException {
    }

    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    public void flush(boolean force, boolean waitIfOngoing) throws EngineException {
    }

    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments, String forceMergeUUID) {
    }

    public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) {
        this.store.incRef();
        return new GatedCloseable((Object)this.indexCommit, () -> ((Store)this.store).decRef());
    }

    public GatedCloseable<IndexCommit> acquireSafeIndexCommit() {
        return this.acquireLastIndexCommit(false);
    }

    public SafeCommitInfo getSafeCommitInfo() {
        return this.safeCommitInfo;
    }

    public void activateThrottling() {
    }

    public void deactivateThrottling() {
    }

    public int fillSeqNoGaps(long primaryTerm) {
        return 0;
    }

    public void maybePruneDeletes() {
    }

    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    public boolean refreshNeeded() {
        return false;
    }

    private TranslogSnapshotIterator newEmptySnapshot() {
        return new TranslogSnapshotIterator(this){

            public void close() {
            }

            public int totalOperations() {
                return 0;
            }

            public TranslogOperation next() {
                return null;
            }
        };
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.seqNoStats.getMaxSeqNo();
    }

    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
        assert (maxSeqNoOfUpdatesOnPrimary <= this.getMaxSeqNoOfUpdatesOrDeletes()) : maxSeqNoOfUpdatesOnPrimary + ">" + this.getMaxSeqNoOfUpdatesOrDeletes();
    }

    protected static DirectoryReader openDirectory(Directory directory, boolean wrapSoftDeletes) throws IOException {
        assert (Transports.assertNotTransportThread((String)"opening directory reader of a read-only engine"));
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        if (wrapSoftDeletes) {
            return new SoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
        }
        return reader;
    }

    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }
}

