/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import io.skylite.common.util.set.Sets;
import io.skylite.core.ParseField;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.mapper.Uid;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public final class TranslogLeafReader
extends LeafReader {
    private final TranslogOperation.Index operation;
    private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo(ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName(), 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName(), 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    private static final FieldInfo FAKE_ID_FIELD = new FieldInfo(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), 3, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
    public static Set<String> ALL_FIELD_NAMES = Sets.newHashSet((Object[])new String[]{TranslogLeafReader.FAKE_SOURCE_FIELD.name, TranslogLeafReader.FAKE_ROUTING_FIELD.name, TranslogLeafReader.FAKE_ID_FIELD.name});

    TranslogLeafReader(TranslogOperation.Index operation) {
        this.operation = operation;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        throw new UnsupportedOperationException();
    }

    public Terms terms(String field) {
        throw new UnsupportedOperationException();
    }

    public NumericDocValues getNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public BinaryDocValues getBinaryDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedDocValues getSortedDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public SortedSetDocValues getSortedSetDocValues(String field) {
        throw new UnsupportedOperationException();
    }

    public DocValuesSkipper getDocValuesSkipper(String field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public NumericDocValues getNormValues(String field) {
        throw new UnsupportedOperationException();
    }

    public FieldInfos getFieldInfos() {
        throw new UnsupportedOperationException();
    }

    public Bits getLiveDocs() {
        throw new UnsupportedOperationException();
    }

    public PointValues getPointValues(String field) {
        throw new UnsupportedOperationException();
    }

    public void checkIntegrity() {
    }

    public LeafMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public TermVectors termVectors() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int numDocs() {
        return 1;
    }

    public int maxDoc() {
        return 1;
    }

    public StoredFields storedFields() throws IOException {
        return new StoredFields(){

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                if (docID != 0) {
                    throw new IllegalArgumentException("no such doc ID " + docID);
                }
                if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
                    assert (TranslogLeafReader.this.operation.source().toBytesRef().offset == 0);
                    assert (TranslogLeafReader.this.operation.source().toBytesRef().length == TranslogLeafReader.this.operation.source().toBytesRef().bytes.length);
                    visitor.binaryField(FAKE_SOURCE_FIELD, TranslogLeafReader.this.operation.source().toBytesRef().bytes);
                }
                if (TranslogLeafReader.this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
                    visitor.stringField(FAKE_ROUTING_FIELD, TranslogLeafReader.this.operation.routing());
                }
                if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
                    BytesRef bytesRef = Uid.encodeId((String)TranslogLeafReader.this.operation.id());
                    byte[] id = new byte[bytesRef.length];
                    System.arraycopy(bytesRef.bytes, bytesRef.offset, id, 0, bytesRef.length);
                    visitor.binaryField(FAKE_ID_FIELD, id);
                }
            }
        };
    }

    protected void doClose() {
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        throw new UnsupportedOperationException();
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.getFloatVectorValues(field);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.getByteVectorValues(field);
    }

    public void searchNearestVectors(String field, byte[] target, KnnCollector k, AcceptDocs acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void searchNearestVectors(String field, float[] target, KnnCollector k, AcceptDocs acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }
}

