/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.get;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.common.collect.Tuple;
import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.metrics.MeanMetric;
import io.skylite.common.util.set.Sets;
import io.skylite.core.ParseField;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.document.DocumentField;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.VersionType;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.get.GetResult;
import io.skylite.core.index.get.GetStats;
import io.skylite.core.index.shard.AbstractIndexShardComponent;
import io.skylite.core.index.storedfieldloader.CustomStoredFieldsLoader;
import io.skylite.core.index.storedfieldloader.StoredFieldsLoader;
import io.skylite.core.lucene.uid.VersionsAndSeqNoResolver;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.DocumentMapper;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.Uid;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.opensearch.index.shard.IndexShard;

public final class ShardGetService
extends AbstractIndexShardComponent {
    private final MapperService mapperService;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();
    private final IndexShard indexShard;

    public ShardGetService(IndexSettings indexSettings, IndexShard indexShard, MapperService mapperService) {
        super(indexShard.shardId(), indexSettings);
        this.mapperService = mapperService;
        this.indexShard = indexShard;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public GetResult get(String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext) {
        return this.get(id, gFields, realtime, version, versionType, -2L, 0L, fetchSourceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult get(String id, String[] gFields, boolean realtime, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext) {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(id, gFields, realtime, version, versionType, ifSeqNo, ifPrimaryTerm, fetchSourceContext);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    public GetResult getForUpdate(String id, long ifSeqNo, long ifPrimaryTerm) {
        return this.get(id, new String[]{ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName()}, true, -3L, VersionType.INTERNAL, ifSeqNo, ifPrimaryTerm, FetchSourceContext.FETCH_SOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String[] fields, FetchSourceContext fetchSourceContext) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.getIndexName(), id, -2L, 0L, -1L, false, null, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, fields);
            GetResult getResult = this.innerGetLoadFromStoredFields(id, fields, fetchSourceContext, engineGetResult, this.mapperService);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    private FetchSourceContext normalizeFetchSourceContent(@Nullable FetchSourceContext context, @Nullable String[] gFields) {
        if (context != null) {
            return context;
        }
        if (gFields == null) {
            return FetchSourceContext.FETCH_SOURCE;
        }
        for (String field : gFields) {
            if (!ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName().equals(field)) continue;
            return FetchSourceContext.FETCH_SOURCE;
        }
        return FetchSourceContext.DO_NOT_FETCH_SOURCE;
    }

    private GetResult innerGet(String id, String[] gFields, boolean realtime, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext) {
        fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, gFields);
        Term uidTerm = new Term(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), Uid.encodeId((String)id));
        try (Engine.GetResult get = this.indexShard.get(new Engine.Get(realtime, true, id, uidTerm).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm));){
            if (get == null || !get.exists()) {
                GetResult getResult = new GetResult(this.shardId.getIndexName(), id, -2L, 0L, -1L, false, null, null, null);
                return getResult;
            }
            GetResult getResult = this.innerGetLoadFromStoredFields(id, gFields, fetchSourceContext, get, this.mapperService);
            return getResult;
        }
    }

    private GetResult innerGetLoadFromStoredFields(String id, String[] storedFields, FetchSourceContext fetchSourceContext, Engine.GetResult get, MapperService mapperService) {
        assert (get.exists()) : "method should only be called if document could be retrieved";
        DocumentMapper docMapper = mapperService.documentMapper();
        if (storedFields != null) {
            for (String field : storedFields) {
                Mapper fieldMapper = docMapper.mappers().getMapper(field);
                if (fieldMapper != null || docMapper.mappers().objectMappers().get(field) == null) continue;
                throw new IllegalArgumentException("field [" + field + "] isn't a leaf field");
            }
        }
        HashMap<String, DocumentField> documentFields = null;
        HashMap<String, DocumentField> metadataFields = null;
        BytesReference source = null;
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
        StoredFieldsLoader storedFieldsLoader = ShardGetService.buildFieldsVisitors(storedFields, fetchSourceContext);
        if (storedFieldsLoader != null) {
            try {
                docIdAndVersion.reader.storedFields().document(docIdAndVersion.docId, (StoredFieldVisitor)storedFieldsLoader);
            }
            catch (IOException e) {
                throw new SkyliteException("Failed to get id [" + id + "]", (Throwable)e, new Object[0]);
            }
            source = storedFieldsLoader.source();
            if (!storedFieldsLoader.fields().isEmpty()) {
                ShardGetService.loadStoredFields(storedFieldsLoader, arg_0 -> ((MapperService)mapperService).fieldType(arg_0));
                documentFields = new HashMap<String, DocumentField>();
                metadataFields = new HashMap<String, DocumentField>();
                for (Map.Entry entry : storedFieldsLoader.fields().entrySet()) {
                    if (mapperService.isMetadataField((String)entry.getKey())) {
                        metadataFields.put((String)entry.getKey(), new DocumentField((String)entry.getKey(), (List)entry.getValue()));
                        continue;
                    }
                    documentFields.put((String)entry.getKey(), new DocumentField((String)entry.getKey(), (List)entry.getValue()));
                }
            }
        }
        if (source != null) {
            if (!fetchSourceContext.fetchSource()) {
                source = null;
            } else if (fetchSourceContext.includes().length > 0 || fetchSourceContext.excludes().length > 0) {
                Tuple typeMapTuple = XContentHelper.convertToMap((BytesReference)source, (boolean)true);
                MediaType sourceContentType = (MediaType)typeMapTuple.v1();
                Map sourceAsMap = (Map)typeMapTuple.v2();
                sourceAsMap = XContentMapValuesUtil.filter((Map)sourceAsMap, (String[])fetchSourceContext.includes(), (String[])fetchSourceContext.excludes());
                try {
                    source = BytesReference.bytes((XContentBuilder)MediaTypeRegistry.contentBuilder((MediaType)sourceContentType).map(sourceAsMap));
                }
                catch (IOException e) {
                    throw new SkyliteException("Failed to get id [" + id + "] with includes/excludes set", (Throwable)e, new Object[0]);
                }
            }
        }
        return new GetResult(this.shardId.getIndexName(), id, get.docIdAndVersion().seqNo, get.docIdAndVersion().primaryTerm, get.version(), get.exists(), source, documentFields, metadataFields);
    }

    private static StoredFieldsLoader buildFieldsVisitors(String[] fields, FetchSourceContext fetchSourceContext) {
        if (fields == null || fields.length == 0) {
            return fetchSourceContext.fetchSource() ? new StoredFieldsLoader(true) : null;
        }
        return new CustomStoredFieldsLoader((Set)Sets.newHashSet((Object[])fields), fetchSourceContext.fetchSource());
    }

    public static void loadStoredFields(StoredFieldsLoader storedFieldsLoader, Function<String, BaseMappedFieldType> fieldTypeLookup) {
        for (Map.Entry entry : storedFieldsLoader.fields().entrySet()) {
            BaseMappedFieldType fieldType = fieldTypeLookup.apply((String)entry.getKey());
            List fieldValues = (List)entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldType.valueForDisplay(fieldValues.get(i)));
            }
        }
    }
}

