/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.SkyliteParseException;
import io.skylite.common.CheckedBiFunction;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.Explicit;
import io.skylite.common.TriFunction;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Point;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;

public abstract class AbstractPointGeometryFieldMapper<T>
extends AbstractGeometryFieldMapper<T> {
    protected final ParsedPoint nullValue;

    public static FieldMapper.Parameter<ParsedPoint> nullValueParam(Function<FieldMapper, ParsedPoint> initializer, TriFunction<String, MappingParserContext, Object, ParsedPoint> parser, Supplier<ParsedPoint> def) {
        return new FieldMapper.Parameter("null_value", false, def, parser, initializer);
    }

    protected AbstractPointGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, ParsedPoint nullValue, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser) {
        super(simpleName, mappedFieldType, ignoreMalformed, ignoreZValue, multiFields, copyTo, parser);
        this.nullValue = nullValue;
    }

    public final boolean parsesArrayValue() {
        return true;
    }

    public ParsedPoint nullValue() {
        return this.nullValue;
    }

    public static interface ParsedPoint {
        public void validate(String var1);

        public void normalize(String var1);

        public void resetCoords(double var1, double var3);

        public Point asGeometry();

        default public boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }
    }

    public static class PointParser<P extends ParsedPoint>
    extends AbstractGeometryFieldMapper.Parser<P> {
        private final GeometryParser geometryParser;
        private final String field;
        private final Supplier<P> pointSupplier;
        private final CheckedBiFunction<XContentParser, P, P, IOException> objectParser;
        private final P nullValue;
        private final boolean ignoreZValue;
        private final boolean ignoreMalformed;

        public PointParser(String field, Supplier<P> pointSupplier, CheckedBiFunction<XContentParser, P, P, IOException> objectParser, P nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            this.field = field;
            this.pointSupplier = pointSupplier;
            this.objectParser = objectParser;
            this.nullValue = nullValue == null ? null : this.process(nullValue);
            this.ignoreZValue = ignoreZValue;
            this.ignoreMalformed = ignoreMalformed;
            this.geometryParser = new GeometryParser(true, true, true);
        }

        private P process(P in) {
            if (!this.ignoreMalformed) {
                in.validate(this.field);
            } else {
                in.normalize(this.field);
            }
            return in;
        }

        @Override
        public void parse(XContentParser parser, CheckedConsumer<P, IOException> consumer, Consumer<Exception> onMalformed) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token = parser.nextToken();
                ParsedPoint point = (ParsedPoint)this.pointSupplier.get();
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    double x = parser.doubleValue();
                    parser.nextToken();
                    double y = parser.doubleValue();
                    token = parser.nextToken();
                    if (token == XContentParser.Token.VALUE_NUMBER) {
                        GeoPoint.assertZValue((boolean)this.ignoreZValue, (double)parser.doubleValue());
                    } else if (token != XContentParser.Token.END_ARRAY) {
                        throw new SkyliteParseException("field type does not accept > 3 dimensions", new Object[0]);
                    }
                    point.resetCoords(x, y);
                    consumer.accept((Object)this.process(point));
                } else {
                    while (token != XContentParser.Token.END_ARRAY) {
                        this.parseAndConsumeFromObject(parser, point, consumer, onMalformed);
                        point = (ParsedPoint)this.pointSupplier.get();
                        token = parser.nextToken();
                    }
                }
            } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    consumer.accept(this.nullValue);
                }
            } else {
                this.parseAndConsumeFromObject(parser, (ParsedPoint)this.pointSupplier.get(), consumer, onMalformed);
            }
        }

        private void parseAndConsumeFromObject(XContentParser parser, P point, CheckedConsumer<P, IOException> consumer, Consumer<Exception> onMalformed) {
            try {
                point = (ParsedPoint)this.objectParser.apply((Object)parser, point);
                consumer.accept(this.process(point));
            }
            catch (Exception e) {
                onMalformed.accept(e);
            }
        }

        @Override
        public Object format(P point, String format) {
            GeometryFormat<Geometry> geometryFormat = this.geometryParser.geometryFormat(format);
            return geometryFormat.toXContentAsObject((Object)point.asGeometry());
        }
    }
}

