/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class DataStreamFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_data_stream_timestamp";
    public static final String CONTENT_TYPE = "_data_stream_timestamp";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(context -> new DataStreamFieldMapper(false, Defaults.TIMESTAMP_FIELD), context -> new Builder());
    private final boolean enabled;
    private final DataStream.TimestampField timestampField;

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init((FieldMapper)this);
    }

    private static DataStreamFieldMapper toType(FieldMapper in) {
        return (DataStreamFieldMapper)in;
    }

    protected DataStreamFieldMapper(boolean enabled, DataStream.TimestampField timestampField) {
        super((MappedFieldType)DataStreamFieldType.INSTANCE);
        this.enabled = enabled;
        this.timestampField = timestampField;
    }

    protected String contentType() {
        return "_data_stream_timestamp";
    }

    public void postParse(ParseContext context) throws IOException {
        if (!this.enabled) {
            return;
        }
        LuceneDocument document = context.doc();
        IndexableField[] fields = document.getFields(this.timestampField.getName());
        long numTimestampValues = Arrays.stream(fields).filter(field -> field.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC).count();
        if (numTimestampValues != 1L) {
            throw new IllegalArgumentException("documents must contain a single-valued timestamp field '" + this.timestampField.getName() + "' of date type");
        }
    }

    public static final class Builder
    extends MetadataFieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> enabledParam = FieldMapper.Parameter.boolParam((String)"enabled", (boolean)false, mapper -> DataStreamFieldMapper.toType((FieldMapper)mapper).enabled, (boolean)false);
        final FieldMapper.Parameter<DataStream.TimestampField> timestampFieldParam = new FieldMapper.Parameter("timestamp_field", false, () -> Defaults.TIMESTAMP_FIELD, (n, c, o) -> new DataStream.TimestampField((String)((Map)o).get("name")), mapper -> DataStreamFieldMapper.toType((FieldMapper)mapper).timestampField);

        protected Builder() {
            super("_data_stream_timestamp");
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.unmodifiableList(Arrays.asList(this.enabledParam, this.timestampFieldParam));
        }

        public MetadataFieldMapper build(ContentPath contentPath) {
            return new DataStreamFieldMapper((Boolean)this.enabledParam.getValue(), (DataStream.TimestampField)this.timestampFieldParam.getValue());
        }
    }

    public static final class DataStreamFieldType
    extends MappedFieldType {
        public static final DataStreamFieldType INSTANCE = new DataStreamFieldType();

        private DataStreamFieldType() {
            super("_data_stream_timestamp", false, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.typeName() + "]");
        }

        public String typeName() {
            return "_data_stream_timestamp";
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run term query on internal field [" + this.typeName() + "]");
        }

        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists query on internal field [" + this.typeName() + "]");
        }
    }

    public static final class Defaults {
        public static final boolean ENABLED = false;
        public static final DataStream.TimestampField TIMESTAMP_FIELD = DataStream.DEFAULT_TIMESTAMP_FIELD;
    }
}

