/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.NumberFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.SourceValueFetcher;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;

public class DocCountFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_doc_count";
    public static final String CONTENT_TYPE = "_doc_count";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new DocCountFieldMapper(), c -> new Builder());

    private DocCountFieldMapper() {
        super((MappedFieldType)DocCountFieldType.INSTANCE);
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        long value = parser.longValue(false);
        if (value <= 0L) {
            throw new IllegalArgumentException("Field [" + this.fieldType().name() + "] must be a positive integer.");
        }
        NumericDocValuesField docCount = new NumericDocValuesField("_doc_count", value);
        context.doc().add((IndexableField)docCount);
    }

    public void preParse(ParseContext context) {
    }

    public DocCountFieldType fieldType() {
        return (DocCountFieldType)super.fieldType();
    }

    protected String contentType() {
        return "_doc_count";
    }

    public static final class DocCountFieldType
    extends MappedFieldType {
        public static final DocCountFieldType INSTANCE = new DocCountFieldType();
        private static final Long defaultValue = 1L;

        public DocCountFieldType() {
            super("_doc_count", false, false, true, TextSearchInfo.NONE, Collections.emptyMap());
        }

        public String typeName() {
            return "_doc_count";
        }

        public String familyTypeName() {
            return NumberFieldMapper.NumberType.LONG.typeName();
        }

        public Query existsQuery(QueryShardContext context) {
            return new FieldExistsQuery("_doc_count");
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "Field [" + this.name() + "] of type [" + this.typeName() + "] is not searchable", new Object[0]);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this, this.name(), context, defaultValue){

                protected Object parseSourceValue(Object value) {
                    if ("".equals(value)) {
                        return defaultValue;
                    }
                    return NumberFieldMapper.NumberType.objectToLong((Object)value, (boolean)false);
                }
            };
        }
    }

    static class Builder
    extends MetadataFieldMapper.Builder {
        Builder() {
            super("_doc_count");
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.emptyList();
        }

        public DocCountFieldMapper build(ContentPath contentPath) {
            return new DocCountFieldMapper();
        }
    }
}

