/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.common.Explicit;
import io.skylite.common.geometry.Geometry;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.geo.GeoShapeIndexer;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.geo.AbstractGeoShapeIndexFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.opensearch.index.mapper.GeoShapeParser;
import org.opensearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.opensearch.index.mapper.ShapeQueryable;
import org.opensearch.index.query.VectorGeoShapeQueryProcessor;

public class GeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    public static final String CONTENT_TYPE = "geo_shape";
    public static Mapper.TypeParser PARSER = (name, node, parserContext) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(parserContext.getSettings());
        boolean coerceByDefault = (Boolean)COERCE_SETTING.get(parserContext.getSettings());
        FieldMapper.Builder builder = LegacyGeoShapeFieldMapper.containsDeprecatedParameter(node.keySet()) ? new LegacyGeoShapeFieldMapper.Builder(name, parserContext.indexVersionCreated(), ignoreMalformedByDefault, coerceByDefault) : new Builder(name, ignoreMalformedByDefault, coerceByDefault);
        builder.parse(name, parserContext, node);
        return builder;
    };
    private final Builder builder;
    private final GeoShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((GeoShapeFieldMapper)in).builder;
    }

    public GeoShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, GeoShapeIndexer indexer, AbstractGeometryFieldMapper.Parser<Geometry> parser, Builder builder) {
        super(simpleName, mappedFieldType, (Explicit<Boolean>)((Explicit)builder.ignoreMalformed.get()), (Explicit<Boolean>)((Explicit)builder.coerce.get()), (Explicit<Boolean>)((Explicit)builder.ignoreZValue.get()), (Explicit<ShapeBuilder.Orientation>)((Explicit)builder.orientation.get()), multiFields, copyTo, parser);
        this.builder = builder;
        this.indexer = indexer;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value(), (Boolean)((Explicit)this.builder.coerce.getDefaultValue()).value()).init(this);
    }

    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (mergeWith instanceof LegacyGeoShapeFieldMapper) {
            String strategy = ((LegacyGeoShapeFieldMapper)mergeWith).strategy();
            throw new IllegalArgumentException("mapper [" + this.name() + "] of type [geo_shape] cannot change strategy from [BKD] to [" + strategy + "]");
        }
        super.checkIncomingMergeType(mergeWith);
    }

    @Override
    protected void index(ParseContext context, Geometry geometry) throws IOException {
        List indexableFields = this.indexer.indexShape(geometry);
        if (this.fieldType().isSearchable()) {
            context.doc().addAll(indexableFields);
        }
        if (this.fieldType().hasDocValues()) {
            if (indexableFields.size() > 0) {
                Field[] fieldsArray = new Field[indexableFields.size()];
                fieldsArray = indexableFields.toArray(fieldsArray);
                context.doc().add((IndexableField)LatLonShape.createDocValueField((String)this.fieldType().name(), (Field[])fieldsArray));
            }
        } else {
            context.addFieldToFieldNamesField(this.fieldType().name());
        }
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)GeoShapeFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)GeoShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<ShapeBuilder.Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> (Explicit)GeoShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)GeoShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> (Explicit)GeoShapeFieldMapper.builder((FieldMapper)m).coerce.get(), coerceByDefault);
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue.setValue((Object)new Explicit((Object)ignoreZValue, true));
            return this;
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.meta);
        }

        public GeoShapeFieldMapper build(ContentPath contentPath) {
            GeometryParser geometryParser = new GeometryParser(((ShapeBuilder.Orientation)((Object)((Explicit)this.orientation.get()).value())).getAsBoolean(), (Boolean)((Explicit)this.coerce.get()).value(), (Boolean)((Explicit)this.ignoreZValue.get()).value());
            GeoShapeParser geoShapeParser = new GeoShapeParser(geometryParser);
            GeoShapeFieldType ft = new GeoShapeFieldType(this.buildFullName(contentPath), (Boolean)this.indexed.get(), (ShapeBuilder.Orientation)((Object)((Explicit)this.orientation.get()).value()), geoShapeParser, (Map)this.meta.get());
            return new GeoShapeFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), new GeoShapeIndexer(((ShapeBuilder.Orientation)((Object)((Explicit)this.orientation.get()).value())).getAsBoolean(), this.buildFullName(contentPath)), geoShapeParser, this);
        }
    }

    public static class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType
    implements ShapeQueryable {
        private final VectorGeoShapeQueryProcessor queryProcessor = new VectorGeoShapeQueryProcessor();

        public GeoShapeFieldType(String name, boolean indexed, ShapeBuilder.Orientation orientation, AbstractGeometryFieldMapper.Parser<Geometry> parser, Map<String, String> meta) {
            super(name, indexed, false, true, false, parser, orientation, meta);
        }

        public GeoShapeFieldType(String name) {
            this(name, true, ShapeBuilder.Orientation.RIGHT, null, Collections.emptyMap());
        }

        public String typeName() {
            return GeoShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, relation, context);
        }

        public BaseIndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractGeoShapeIndexFieldData.Builder(this.name(), (ValuesSourceType)GeoValuesSourceType.GEO_SHAPE);
        }
    }
}

