/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.StringFieldType;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;

public final class IgnoredFieldMapper
extends MetadataFieldMapper {
    public static final String CONTENT_TYPE = "_ignored";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new IgnoredFieldMapper());

    private IgnoredFieldMapper() {
        super((MappedFieldType)IgnoredFieldType.INSTANCE);
    }

    public void postParse(ParseContext context) {
        for (String field : context.getIgnoredFields()) {
            context.doc().add((IndexableField)new Field(ParseField.CommonMetaFields.IGNORED_FIELD.getPreferredName(), (CharSequence)field, (IndexableFieldType)Defaults.FIELD_TYPE));
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class IgnoredFieldType
    extends StringFieldType {
        public static final IgnoredFieldType INSTANCE = new IgnoredFieldType();

        private IgnoredFieldType() {
            super(ParseField.CommonMetaFields.IGNORED_FIELD.getPreferredName(), true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        public String typeName() {
            return IgnoredFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            return new TermRangeQuery(this.name(), null, null, true, true);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }
    }

    public static class Defaults {
        public static final String NAME = ParseField.CommonMetaFields.IGNORED_FIELD.getPreferredName();
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

