/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.LegacyESVersion;
import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.Explicit;
import io.skylite.common.geometry.Geometry;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.geo.GeoUtils;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.common.geo.ShapesAvailability;
import org.opensearch.common.geo.SpatialStrategy;
import org.opensearch.common.geo.XShapeCollection;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.common.geo.parsers.ShapeParser;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.opensearch.index.mapper.GeoShapeFieldMapper;
import org.opensearch.index.mapper.ShapeQueryable;
import org.opensearch.index.query.LegacyGeoShapeQueryProcessor;

@Deprecated
public class LegacyGeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<ShapeBuilder<?, ?, ?>> {
    public static final String CONTENT_TYPE = "geo_shape";
    public static final Set<String> DEPRECATED_PARAMETERS = Set.of("strategy", "tree", "tree_levels", "precision", "distance_error_pct", "points only");
    private final Version indexCreatedVersion;
    private final Builder builder;

    public static boolean containsDeprecatedParameter(Set<String> paramKeys) {
        return DEPRECATED_PARAMETERS.stream().anyMatch(paramKeys::contains);
    }

    private static Builder builder(FieldMapper in) {
        return ((LegacyGeoShapeFieldMapper)in).builder;
    }

    public LegacyGeoShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, LegacyGeoShapeParser parser, Builder builder) {
        super(simpleName, mappedFieldType, Collections.singletonMap(mappedFieldType.name(), Lucene.KEYWORD_ANALYZER), (Explicit<Boolean>)((Explicit)builder.ignoreMalformed.get()), (Explicit<Boolean>)((Explicit)builder.coerce.get()), (Explicit<Boolean>)((Explicit)builder.ignoreZValue.get()), (Explicit<ShapeBuilder.Orientation>)((Explicit)builder.orientation.get()), multiFields, copyTo, parser);
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.builder = builder;
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    String strategy() {
        return this.fieldType().strategy().getStrategyName();
    }

    @Override
    protected void index(ParseContext context, ShapeBuilder<?, ?, ?> shapeBuilder) throws IOException {
        Object shape = shapeBuilder.buildS4J();
        if (this.fieldType().pointsOnly()) {
            if (shape instanceof XShapeCollection && ((XShapeCollection)((Object)shape)).pointsOnly()) {
                List shapes = ((XShapeCollection)((Object)shape)).getShapes();
                for (Shape s : shapes) {
                    context.doc().addAll(Arrays.asList(this.fieldType().defaultPrefixTreeStrategy().createIndexableFields(s)));
                }
                return;
            }
            if (!(shape instanceof Point)) {
                throw new MapperParsingException("[{" + this.fieldType().name() + "}] is configured for points only but a " + String.valueOf(shape instanceof JtsGeometry ? ((JtsGeometry)shape).getGeom().getGeometryType() : shape.getClass()) + " was found");
            }
        }
        context.doc().addAll(Arrays.asList(this.fieldType().defaultPrefixTreeStrategy().createIndexableFields(shape)));
        context.addFieldToFieldNamesField(this.fieldType().name());
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion, (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value(), (Boolean)((Explicit)this.builder.coerce.getDefaultValue()).value()).init(this);
    }

    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (mergeWith instanceof GeoShapeFieldMapper) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] of type [geo_shape] cannot change strategy from [" + this.strategy() + "] to [BKD]");
        }
        super.checkIncomingMergeType(mergeWith);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<ShapeBuilder.Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<SpatialStrategy> strategy = new FieldMapper.Parameter("strategy", false, () -> SpatialStrategy.RECURSIVE, (n, c, o) -> SpatialStrategy.fromString(o.toString()), m -> (SpatialStrategy)((Object)((Object)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).strategy.get()))).deprecated();
        final FieldMapper.Parameter<String> tree = FieldMapper.Parameter.stringParam((String)"tree", (boolean)false, m -> (String)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).tree.get(), (String)"quadtree").deprecated();
        FieldMapper.Parameter<Integer> treeLevels = new FieldMapper.Parameter("tree_levels", false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValuesUtil.nodeIntegerValue((Object)o)), m -> (Integer)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).treeLevels.get()).deprecated();
        FieldMapper.Parameter<DistanceUnit.Distance> precision = new FieldMapper.Parameter("precision", false, () -> null, (n, c, o) -> o == null ? null : DistanceUnit.Distance.parseDistance((String)o.toString()), m -> (DistanceUnit.Distance)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).precision.get()).deprecated();
        FieldMapper.Parameter<Double> distanceErrorPct = new FieldMapper.Parameter("distance_error_pct", true, () -> null, (n, c, o) -> o == null ? null : Double.valueOf(XContentMapValuesUtil.nodeDoubleValue((Object)o)), m -> (Double)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).distanceErrorPct.get()).deprecated().acceptsNull();
        FieldMapper.Parameter<Boolean> pointsOnly = new FieldMapper.Parameter("points_only", false, () -> null, (n, c, o) -> XContentMapValuesUtil.nodeBooleanValue((Object)o), m -> (Boolean)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).pointsOnly.get()).deprecated().acceptsNull();
        FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final Version indexCreatedVersion;

        public Builder(String name, Version version, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            if (!ShapesAvailability.JTS_AVAILABLE || !ShapesAvailability.SPATIAL4J_AVAILABLE) {
                throw new SkyliteParseException("Non-BKD field parameters are not supported for [{}] field type", new Object[]{LegacyGeoShapeFieldMapper.CONTENT_TYPE});
            }
            this.indexCreatedVersion = version;
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> (Explicit)LegacyGeoShapeFieldMapper.builder((FieldMapper)m).coerce.get(), coerceByDefault);
            this.pointsOnly.setValidator(v -> {
                if (v == null) {
                    return;
                }
                if (!v.booleanValue() && SpatialStrategy.TERM == this.strategy.get()) {
                    throw new IllegalArgumentException("points_only cannot be set to false for term strategy");
                }
            });
            if (version.onOrAfter(LegacyESVersion.fromId((int)7000099))) {
                this.strategy.alwaysSerialize();
            }
            this.strategy.setSerializer((b, f, v) -> b.field(f, v.getStrategyName()), SpatialStrategy::getStrategyName);
            this.treeLevels.setSerializerCheck((id, ic, v) -> ic || id && this.precision.get() == null);
            this.treeLevels.setSerializer((b, f, v) -> {
                if (v != null && v != 0) {
                    b.field(f, v);
                } else {
                    b.field(f, Defaults.defaultTreeLevel((String)this.tree.get()));
                }
            }, Objects::toString);
            this.precision.setSerializerCheck((id, ic, v) -> ic || id && this.treeLevels.get() == null);
            this.precision.setSerializer((b, f, v) -> {
                if (v == null) {
                    b.field(f, "50.0m");
                } else {
                    b.field(f, v.toString());
                }
            }, Objects::toString);
            this.pointsOnly.setSerializer((b, f, v) -> {
                if (v == null) {
                    b.field(f, this.strategy.get() == SpatialStrategy.TERM);
                } else {
                    b.field(f, v);
                }
            }, Objects::toString);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.strategy, this.tree, this.treeLevels, this.precision, this.distanceErrorPct, this.pointsOnly, this.meta);
        }

        public Builder coerce(boolean coerce) {
            this.coerce.setValue((Object)new Explicit((Object)coerce, true));
            return this;
        }

        private void setupFieldTypeDeprecatedParameters(ContentPath contentPath, GeoShapeFieldType ft) {
            ft.setStrategy((SpatialStrategy)((Object)this.strategy.get()));
            ft.setTree((String)this.tree.get());
            if (this.treeLevels.get() != null) {
                ft.setTreeLevels((Integer)this.treeLevels.get());
            }
            if (this.precision.get() != null) {
                ft.setPrecisionInMeters(((DistanceUnit.Distance)this.precision.get()).value);
            }
            if (this.pointsOnly.get() != null) {
                ft.setPointsOnly((Boolean)this.pointsOnly.get());
            }
            if (this.distanceErrorPct.get() != null) {
                ft.setDistanceErrorPct((Double)this.distanceErrorPct.get());
            }
            if (ft.treeLevels() == 0 && ft.precisionInMeters() < 0.0) {
                ft.setDefaultDistanceErrorPct(0.025);
            }
        }

        private void setupPrefixTrees(GeoShapeFieldType ft) {
            GeohashPrefixTree prefixTree;
            if (ft.tree().equals("geohash")) {
                prefixTree = new GeohashPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.GEOHASH_TREE_LEVELS, true));
            } else if (ft.tree().equals("legacyquadtree")) {
                prefixTree = new QuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.QUADTREE_LEVELS, false));
            } else if (ft.tree().equals("quadtree")) {
                prefixTree = new PackedQuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.QUADTREE_LEVELS, false));
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + ft.tree() + "]");
            }
            RecursivePrefixTreeStrategy rpts = new RecursivePrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            rpts.setDistErrPct(ft.distanceErrorPct());
            rpts.setPruneLeafyBranches(false);
            ft.recursiveStrategy = rpts;
            TermQueryPrefixTreeStrategy termStrategy = new TermQueryPrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            termStrategy.setDistErrPct(ft.distanceErrorPct());
            ft.termStrategy = termStrategy;
            ft.defaultPrefixTreeStrategy = ft.resolvePrefixTreeStrategy(ft.strategy());
            ft.defaultPrefixTreeStrategy.setPointsOnly(ft.pointsOnly());
        }

        private GeoShapeFieldType buildFieldType(LegacyGeoShapeParser parser, ContentPath contentPath) {
            GeoShapeFieldType ft = new GeoShapeFieldType(this.buildFullName(contentPath), (Boolean)this.indexed.get(), (ShapeBuilder.Orientation)((Object)((Explicit)this.orientation.get()).value()), parser, (Map)this.meta.get());
            this.setupFieldTypeDeprecatedParameters(contentPath, ft);
            this.setupPrefixTrees(ft);
            return ft;
        }

        private static int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
            if (treeLevels > 0 || precisionInMeters >= 0.0) {
                return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision((double)precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision((double)precisionInMeters)) : 0);
            }
            return defaultLevels;
        }

        public LegacyGeoShapeFieldMapper build(ContentPath contentPath) {
            if (this.name.isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            LegacyGeoShapeParser parser = new LegacyGeoShapeParser();
            GeoShapeFieldType ft = this.buildFieldType(parser, contentPath);
            return new LegacyGeoShapeFieldMapper(this.name, ft, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), parser, this);
        }
    }

    public static final class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType
    implements ShapeQueryable {
        private String tree = "quadtree";
        private SpatialStrategy strategy = Defaults.STRATEGY;
        private boolean pointsOnly = false;
        private int treeLevels = 0;
        private double precisionInMeters = -1.0;
        private Double distanceErrorPct;
        private double defaultDistanceErrorPct = 0.0;
        private PrefixTreeStrategy defaultPrefixTreeStrategy;
        private RecursivePrefixTreeStrategy recursiveStrategy;
        private TermQueryPrefixTreeStrategy termStrategy;
        private final LegacyGeoShapeQueryProcessor queryProcessor = new LegacyGeoShapeQueryProcessor(this);

        private GeoShapeFieldType(String name, boolean indexed, ShapeBuilder.Orientation orientation, LegacyGeoShapeParser parser, Map<String, String> meta) {
            super(name, indexed, false, false, false, parser, orientation, meta);
        }

        public GeoShapeFieldType(String name) {
            this(name, true, ShapeBuilder.Orientation.RIGHT, null, Collections.emptyMap());
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            throw new UnsupportedOperationException("process method should not be called for PrefixTree based geo_shapes");
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, strategy, relation, context);
        }

        public String typeName() {
            return LegacyGeoShapeFieldMapper.CONTENT_TYPE;
        }

        public String tree() {
            return this.tree;
        }

        public void setTree(String tree) {
            this.tree = tree;
        }

        public SpatialStrategy strategy() {
            return this.strategy;
        }

        public void setStrategy(SpatialStrategy strategy) {
            this.strategy = strategy;
            if (this.strategy.equals((Object)SpatialStrategy.TERM)) {
                this.pointsOnly = true;
            }
        }

        public boolean pointsOnly() {
            return this.pointsOnly;
        }

        public void setPointsOnly(boolean pointsOnly) {
            this.pointsOnly = pointsOnly;
        }

        public int treeLevels() {
            return this.treeLevels;
        }

        public void setTreeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
        }

        public double precisionInMeters() {
            return this.precisionInMeters;
        }

        public void setPrecisionInMeters(double precisionInMeters) {
            this.precisionInMeters = precisionInMeters;
        }

        public double distanceErrorPct() {
            return this.distanceErrorPct == null ? this.defaultDistanceErrorPct : this.distanceErrorPct;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
        }

        public void setDefaultDistanceErrorPct(double defaultDistanceErrorPct) {
            this.defaultDistanceErrorPct = defaultDistanceErrorPct;
        }

        public PrefixTreeStrategy defaultPrefixTreeStrategy() {
            return this.defaultPrefixTreeStrategy;
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(SpatialStrategy strategy) {
            return this.resolvePrefixTreeStrategy(strategy.getStrategyName());
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(String strategyName) {
            if (SpatialStrategy.RECURSIVE.getStrategyName().equals(strategyName)) {
                return this.recursiveStrategy;
            }
            if (SpatialStrategy.TERM.getStrategyName().equals(strategyName)) {
                return this.termStrategy;
            }
            throw new IllegalArgumentException("Unknown prefix tree strategy [" + strategyName + "]");
        }
    }

    private static class LegacyGeoShapeParser
    extends AbstractGeometryFieldMapper.Parser<ShapeBuilder<?, ?, ?>> {
        private final GeometryParser geometryParser = new GeometryParser(true, true, true);

        private LegacyGeoShapeParser() {
        }

        @Override
        public void parse(XContentParser parser, CheckedConsumer<ShapeBuilder<?, ?, ?>, IOException> consumer, Consumer<Exception> onMalformed) throws IOException {
            try {
                consumer.accept((Object)ShapeParser.parse(parser));
            }
            catch (SkyliteParseException e) {
                onMalformed.accept((Exception)((Object)e));
            }
        }

        @Override
        public Object format(ShapeBuilder<?, ?, ?> value, String format) {
            Object geometry = value.buildGeometry();
            return this.geometryParser.geometryFormat(format).toXContentAsObject(geometry);
        }
    }

    public static class PrefixTrees {
        public static final String LEGACY_QUADTREE = "legacyquadtree";
        public static final String QUADTREE = "quadtree";
        public static final String GEOHASH = "geohash";
    }

    public static class Defaults {
        public static final SpatialStrategy STRATEGY = SpatialStrategy.RECURSIVE;
        public static final String TREE = "quadtree";
        public static final String PRECISION = "50m";
        public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision((String)"50m");
        public static final int GEOHASH_TREE_LEVELS = GeoUtils.geoHashLevelsForPrecision((String)"50m");
        public static final boolean POINTS_ONLY = false;
        public static final double DISTANCE_ERROR_PCT = 0.025;

        public static int defaultTreeLevel(String tree) {
            switch (tree) {
                case "geohash": {
                    return GEOHASH_TREE_LEVELS;
                }
                case "legacyquadtree": 
                case "quadtree": {
                    return QUADTREE_LEVELS;
                }
            }
            throw new IllegalArgumentException("Unknown prefix type [" + tree + "]");
        }
    }
}

