/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import io.skylite.core.ParseField;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.MetadataFieldsUtil;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.mapper.TextSearchInfo;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.lookup.SearchLookup;
import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class VersionFieldMapper
extends MetadataFieldMapper {
    public static final String CONTENT_TYPE = ParseField.CommonMetaFields.VERSION_FIELD.getPreferredName();
    public static final VersionFieldMapper INSTANCE = new VersionFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new VersionFieldMapper());

    private VersionFieldMapper() {
        super((MappedFieldType)VersionFieldType.INSTANCE);
    }

    public void preParse(ParseContext context) {
        Field version = VersionFieldMapper.versionField();
        context.version(version);
        context.doc().add((IndexableField)version);
    }

    public static Field versionField() {
        return MetadataFieldsUtil.versionField();
    }

    public void postParse(ParseContext context) {
        Field version = context.version();
        assert (version != null);
        for (LuceneDocument doc : context.nonRootDocuments()) {
            doc.add((IndexableField)version);
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    static final class VersionFieldType
    extends MappedFieldType {
        public static final VersionFieldType INSTANCE = new VersionFieldType();

        private VersionFieldType() {
            super(ParseField.CommonMetaFields.VERSION_FIELD.getPreferredName(), false, false, true, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, Collections.emptyMap());
        }

        public String typeName() {
            return CONTENT_TYPE;
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "The _version field is not searchable", new Object[0]);
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }
    }
}

