/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.MatchNoneQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryBuilderVisitor;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;

public class ConstantScoreQueryBuilder
extends AbstractQueryBuilder<ConstantScoreQueryBuilder> {
    public static final String NAME = "constant_score";
    private static final ParseField INNER_QUERY_FIELD = new ParseField("filter", new String[0]);
    private final QueryBuilder filterBuilder;

    public ConstantScoreQueryBuilder(QueryBuilder filterBuilder) {
        if (filterBuilder == null) {
            throw new IllegalArgumentException("inner clause [filter] cannot be null.");
        }
        this.filterBuilder = filterBuilder;
    }

    public ConstantScoreQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.filterBuilder = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.filterBuilder);
    }

    public QueryBuilder innerQuery() {
        return this.filterBuilder;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(INNER_QUERY_FIELD.getPreferredName());
        this.filterBuilder.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static ConstantScoreQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        QueryBuilder query = null;
        boolean queryFound = false;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (INNER_QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    query = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    queryFound = true;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[constant_score] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[constant_score] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf(token) + "]", new Object[0]);
        }
        if (!queryFound) {
            throw new ParsingException(parser.getTokenLocation(), "[constant_score] requires a 'filter' element", new Object[0]);
        }
        ConstantScoreQueryBuilder constantScoreBuilder = new ConstantScoreQueryBuilder(query);
        constantScoreBuilder.boost(boost);
        constantScoreBuilder.queryName(queryName);
        return constantScoreBuilder;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerFilter = this.filterBuilder.toQuery((QueryRewriteContext)context);
        return new ConstantScoreQuery(innerFilter);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected int doHashCode() {
        return Objects.hash(this.filterBuilder);
    }

    protected boolean doEquals(ConstantScoreQueryBuilder other) {
        return Objects.equals(this.filterBuilder, other.filterBuilder);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewrite = this.filterBuilder.rewrite(queryRewriteContext);
        if (rewrite instanceof MatchNoneQueryBuilder) {
            return rewrite;
        }
        if (rewrite != this.filterBuilder) {
            return new ConstantScoreQueryBuilder(rewrite);
        }
        return this;
    }

    public void extractInnerHitBuilders(AbstractQueryBuilder.InnerHitCollector<?> collector, AbstractQueryBuilder.InnerHitExtractor extractor) {
        extractor.extract(this.filterBuilder, collector);
    }

    public void visit(QueryBuilderVisitor visitor) {
        visitor.accept((QueryBuilder)this);
        visitor.getChildVisitor(BooleanClause.Occur.FILTER).accept(this.filterBuilder);
    }
}

