/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoUtils;
import io.skylite.core.geo.GeoValidationMethod;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.index.mapper.GeoPointFieldMapper;

public class GeoPolygonQueryBuilder
extends AbstractQueryBuilder<GeoPolygonQueryBuilder> {
    public static final String NAME = "geo_polygon";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField VALIDATION_METHOD = new ParseField("validation_method", new String[0]);
    private static final ParseField POINTS_FIELD = new ParseField("points", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private final List<GeoPoint> shell;
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private boolean ignoreUnmapped = false;

    public GeoPolygonQueryBuilder(String fieldName, List<GeoPoint> points) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (points == null || points.isEmpty()) {
            throw new IllegalArgumentException("polygon must not be null or empty");
        }
        GeoPoint start = points.get(0);
        if (start.equals((Object)points.get(points.size() - 1)) ? points.size() < 4 : points.size() < 3) {
            throw new IllegalArgumentException("too few points defined for geo_polygon query");
        }
        this.fieldName = fieldName;
        this.shell = new ArrayList<GeoPoint>(points);
        if (!this.shell.get(this.shell.size() - 1).equals((Object)this.shell.get(0))) {
            this.shell.add(this.shell.get(0));
        }
    }

    public GeoPolygonQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        int size = in.readVInt();
        this.shell = new ArrayList<GeoPoint>(size);
        for (int i = 0; i < size; ++i) {
            this.shell.add(new GeoPoint(in));
        }
        this.validationMethod = GeoValidationMethod.readFromStream((StreamInput)in);
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeVInt(this.shell.size());
        for (GeoPoint point : this.shell) {
            point.writeTo(out);
        }
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public List<GeoPoint> points() {
        return this.shell;
    }

    public GeoPolygonQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoPolygonQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context.getFullyQualifiedIndex(), "failed to find geo_point field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "field [" + this.fieldName + "] is not a geo_point field", new Object[0]);
        }
        ArrayList<GeoPoint> shell = new ArrayList<GeoPoint>(this.shell.size());
        for (GeoPoint geoPoint : this.shell) {
            shell.add(new GeoPoint(geoPoint));
        }
        int shellSize = shell.size();
        if (!GeoValidationMethod.isIgnoreMalformed((GeoValidationMethod)this.validationMethod)) {
            for (GeoPoint point : shell) {
                if (!GeoUtils.isValidLatitude((double)point.lat())) {
                    throw new QueryShardException(context.getFullyQualifiedIndex(), "illegal latitude value [{}] for [{}]", new Object[]{point.lat(), NAME});
                }
                if (GeoUtils.isValidLongitude((double)point.lon())) continue;
                throw new QueryShardException(context.getFullyQualifiedIndex(), "illegal longitude value [{}] for [{}]", new Object[]{point.lon(), NAME});
            }
        }
        if (GeoValidationMethod.isCoerce((GeoValidationMethod)this.validationMethod)) {
            for (GeoPoint point : shell) {
                GeoPoint.normalizePoint((GeoPoint)point, (boolean)true, (boolean)true);
            }
        }
        double[] dArray = new double[shellSize];
        double[] lons = new double[shellSize];
        for (int i = 0; i < shellSize; ++i) {
            GeoPoint p = (GeoPoint)shell.get(i);
            dArray[i] = p.lat();
            lons[i] = p.lon();
        }
        Polygon polygon = new Polygon(dArray, lons, new Polygon[0]);
        Query query = LatLonPoint.newPolygonQuery((String)fieldType.name(), (Polygon[])new Polygon[]{polygon});
        if (fieldType.hasDocValues()) {
            Query dvQuery = LatLonDocValuesField.newSlowPolygonQuery((String)fieldType.name(), (Polygon[])new Polygon[]{polygon});
            query = new IndexOrDocValuesQuery(query, dvQuery);
        }
        return query;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.startArray(POINTS_FIELD.getPreferredName());
        for (GeoPoint point : this.shell) {
            builder.startArray().value(point.lon()).value(point.lat()).endArray();
        }
        builder.endArray();
        builder.endObject();
        builder.field(VALIDATION_METHOD.getPreferredName(), (Object)this.validationMethod);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoPolygonQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<GeoPoint> shell = null;
        Float boost = null;
        GeoValidationMethod validationMethod = null;
        String queryName = null;
        String currentFieldName = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (POINTS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            shell = new ArrayList<GeoPoint>();
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                shell.add(GeoUtils.parseGeoPoint((XContentParser)parser));
                            }
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] query does not support token type [" + token.name() + "] under [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                if (ParseField.CommonMetaFields.NAME_FIELD.getPreferredName().equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = Float.valueOf(parser.floatValue());
                    continue;
                }
                if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ignoreUnmapped = parser.booleanValue();
                    continue;
                }
                if (VALIDATION_METHOD.match(currentFieldName, parser.getDeprecationHandler())) {
                    validationMethod = GeoValidationMethod.fromString((String)parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[geo_polygon] unexpected token type [" + token.name() + "]", new Object[0]);
        }
        GeoPolygonQueryBuilder builder = new GeoPolygonQueryBuilder(fieldName, shell);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        }
        if (queryName != null) {
            builder.queryName(queryName);
        }
        if (boost != null) {
            builder.boost(boost.floatValue());
        }
        builder.ignoreUnmapped(ignoreUnmapped);
        return builder;
    }

    protected boolean doEquals(GeoPolygonQueryBuilder other) {
        return Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.shell, other.shell) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    protected int doHashCode() {
        return Objects.hash(this.validationMethod, this.fieldName, this.shell, this.ignoreUnmapped);
    }

    public String getWriteableName() {
        return NAME;
    }
}

