/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.InnerHitBuilder;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.script.FieldScript;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchDocValuesContext;
import io.skylite.core.search.fetch.subphase.FetchFieldsContext;
import io.skylite.core.search.fetch.subphase.ScriptFieldsContext;
import io.skylite.core.search.sort.SortAndFormats;
import io.skylite.core.search.sort.SortBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.search.fetch.subphase.InnerHitsContext;
import org.opensearch.search.internal.SearchContext;

public abstract class InnerHitContextBuilder {
    protected final QueryBuilder query;
    protected final InnerHitBuilder innerHitBuilder;
    protected final Map<String, InnerHitContextBuilder> children;

    protected InnerHitContextBuilder(QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
        this.innerHitBuilder = innerHitBuilder;
        this.children = children;
        this.query = query;
    }

    public InnerHitBuilder innerHitBuilder() {
        return this.innerHitBuilder;
    }

    public final void build(SearchContext parentSearchContext, InnerHitsContext innerHitsContext) throws IOException {
        int maxInnerResultWindow;
        long innerResultWindow = this.innerHitBuilder.getFrom() + this.innerHitBuilder.getSize();
        if (innerResultWindow > (long)(maxInnerResultWindow = parentSearchContext.mapperService().getIndexSettings().getMaxInnerResultWindow())) {
            throw new IllegalArgumentException("Inner result window is too large, the inner hit definition's [" + this.innerHitBuilder.getName() + "]'s from + size must be less than or equal to: [" + maxInnerResultWindow + "] but was [" + innerResultWindow + "]. This limit can be set by changing the [" + IndexSettings.MAX_INNER_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        this.doBuild(parentSearchContext, innerHitsContext);
    }

    protected abstract void doBuild(SearchContext var1, InnerHitsContext var2) throws IOException;

    public static void extractInnerHits(QueryBuilder query, Map<String, InnerHitContextBuilder> innerHitBuilders) {
        AbstractQueryBuilder.InnerHitExtractor extractor = (q, collector) -> InnerHitContextBuilder.extractInnerHits(q, collector.getInnerHitContextBuilder());
        MapBackedInnerHitCollector collector2 = new MapBackedInnerHitCollector(innerHitBuilders);
        if (!(query instanceof AbstractQueryBuilder)) {
            throw new IllegalStateException("provided query builder [" + String.valueOf(query.getClass()) + "] class should inherit from AbstractQueryBuilder, but it doesn't");
        }
        AbstractQueryBuilder abstractQuery = (AbstractQueryBuilder)query;
        abstractQuery.extractInnerHitBuilders((AbstractQueryBuilder.InnerHitCollector)collector2, extractor);
    }

    protected void setupInnerHitsContext(QueryShardContext queryShardContext, InnerHitsContext.InnerHitSubContext innerHitsContext) throws IOException {
        Optional optionalSort;
        innerHitsContext.from(this.innerHitBuilder.getFrom());
        innerHitsContext.size(this.innerHitBuilder.getSize());
        innerHitsContext.explain(this.innerHitBuilder.isExplain());
        innerHitsContext.version(this.innerHitBuilder.isVersion());
        innerHitsContext.seqNoAndPrimaryTerm(this.innerHitBuilder.isSeqNoAndPrimaryTerm());
        innerHitsContext.trackScores(this.innerHitBuilder.isTrackScores());
        if (this.innerHitBuilder.getStoredFieldsContext() != null) {
            innerHitsContext.storedFieldsContext(this.innerHitBuilder.getStoredFieldsContext());
        }
        if (this.innerHitBuilder.getDocValueFields() != null) {
            FetchDocValuesContext docValuesContext = FetchDocValuesContext.create(arg_0 -> ((QueryShardContext)queryShardContext).simpleMatchToIndexNames(arg_0), (int)queryShardContext.getIndexSettings().getMaxDocvalueFields(), (List)this.innerHitBuilder.getDocValueFields());
            innerHitsContext.docValuesContext(docValuesContext);
        }
        if (this.innerHitBuilder.getFetchFields() != null) {
            FetchFieldsContext fieldsContext = new FetchFieldsContext(this.innerHitBuilder.getFetchFields());
            innerHitsContext.fetchFieldsContext(fieldsContext);
        }
        if (this.innerHitBuilder.getScriptFields() != null) {
            for (SearchSourceBuilder.ScriptField field : this.innerHitBuilder.getScriptFields()) {
                QueryShardContext innerContext = innerHitsContext.getQueryShardContext();
                FieldScript.Factory factory = (FieldScript.Factory)innerContext.compile(field.script(), FieldScript.CONTEXT);
                FieldScript.LeafFactory fieldScript = factory.newFactory(field.script().getParams(), innerContext.lookup());
                innerHitsContext.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), fieldScript, field.ignoreFailure()));
            }
        }
        if (this.innerHitBuilder.getFetchSourceContext() != null) {
            innerHitsContext.fetchSourceContext(this.innerHitBuilder.getFetchSourceContext());
        }
        if (this.innerHitBuilder.getSorts() != null && (optionalSort = SortBuilder.buildSort((List)this.innerHitBuilder.getSorts(), (QueryShardContext)queryShardContext)).isPresent()) {
            innerHitsContext.sort((SortAndFormats)optionalSort.get());
        }
        if (this.innerHitBuilder.getHighlightBuilder() != null) {
            innerHitsContext.highlight(this.innerHitBuilder.getHighlightBuilder().build(queryShardContext));
        }
        ParsedQuery parsedQuery = new ParsedQuery(this.query.toQuery((QueryRewriteContext)queryShardContext), queryShardContext.copyNamedQueries());
        innerHitsContext.parsedQuery(parsedQuery);
        Map<String, InnerHitsContext.InnerHitSubContext> baseChildren = InnerHitContextBuilder.buildChildInnerHits(innerHitsContext.parentSearchContext(), this.children);
        innerHitsContext.setChildInnerHits(baseChildren);
    }

    private static Map<String, InnerHitsContext.InnerHitSubContext> buildChildInnerHits(SearchContext parentSearchContext, Map<String, InnerHitContextBuilder> children) throws IOException {
        HashMap<String, InnerHitsContext.InnerHitSubContext> childrenInnerHits = new HashMap<String, InnerHitsContext.InnerHitSubContext>();
        for (Map.Entry<String, InnerHitContextBuilder> entry : children.entrySet()) {
            InnerHitsContext childInnerHitsContext = new InnerHitsContext();
            entry.getValue().build(parentSearchContext, childInnerHitsContext);
            if (childInnerHitsContext.getInnerHits() == null) continue;
            childrenInnerHits.putAll(childInnerHitsContext.getInnerHits());
        }
        return childrenInnerHits;
    }

    public static class MapBackedInnerHitCollector
    implements AbstractQueryBuilder.InnerHitCollector<InnerHitContextBuilder> {
        private final Map<String, InnerHitContextBuilder> map;

        public MapBackedInnerHitCollector(Map<String, InnerHitContextBuilder> map) {
            this.map = map;
        }

        public void add(String name, InnerHitContextBuilder context) {
            this.map.put(name, context);
        }

        public Map<String, InnerHitContextBuilder> getInnerHitContextBuilder() {
            return this.map;
        }

        public boolean containsKey(String name) {
            return this.map.containsKey(name);
        }
    }
}

