/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import org.apache.lucene.queries.intervals.IntervalQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.index.query.IntervalsSourceProvider;

public class IntervalQueryBuilder
extends AbstractQueryBuilder<IntervalQueryBuilder> {
    public static final String NAME = "intervals";
    private final String field;
    private final IntervalsSourceProvider sourceProvider;

    public IntervalQueryBuilder(String field, IntervalsSourceProvider sourceProvider) {
        this.field = field;
        this.sourceProvider = sourceProvider;
    }

    public IntervalQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.sourceProvider = (IntervalsSourceProvider)in.readNamedWriteable(IntervalsSourceProvider.class);
    }

    public String getField() {
        return this.field;
    }

    public IntervalsSourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeNamedWriteable((NamedWriteable)this.sourceProvider);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(this.field);
        builder.startObject();
        this.sourceProvider.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static IntervalQueryBuilder fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
        }
        String field = parser.currentName();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
        }
        String name = null;
        float boost = 1.0f;
        IntervalsSourceProvider provider = null;
        String providerName = null;
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
            }
            switch (parser.currentName()) {
                case "_name": {
                    parser.nextToken();
                    name = parser.text();
                    continue block8;
                }
                case "boost": {
                    parser.nextToken();
                    boost = parser.floatValue();
                    continue block8;
                }
            }
            if (providerName != null) {
                throw new ParsingException(parser.getTokenLocation(), "Only one interval rule can be specified, found [" + providerName + "] and [" + parser.currentName() + "]", new Object[0]);
            }
            providerName = parser.currentName();
            provider = IntervalsSourceProvider.fromXContent(parser);
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
        }
        if (provider == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing intervals from interval query definition", new Object[0]);
        }
        IntervalQueryBuilder builder = new IntervalQueryBuilder(field, provider);
        builder.queryName(name);
        builder.boost(boost);
        return builder;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType = context.getFieldType(this.field);
        if (fieldType == null) {
            return new MatchNoDocsQuery();
        }
        HashSet<String> maskedFields = new HashSet<String>();
        this.sourceProvider.extractFields(maskedFields);
        for (String maskedField : maskedFields) {
            MappedFieldType ft = context.getFieldType(maskedField);
            if (ft != null) continue;
            return new MatchNoDocsQuery();
        }
        return new IntervalQuery(this.field, this.sourceProvider.getSource(context, fieldType));
    }

    protected boolean doEquals(IntervalQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.sourceProvider, other.sourceProvider);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.sourceProvider);
    }

    public String getWriteableName() {
        return NAME;
    }
}

