/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.SkyliteException;
import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.core.common.unit.DistanceUnit;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.search.SearchServiceSettings;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.shape.Shape;
import org.opensearch.common.geo.SpatialStrategy;
import org.opensearch.common.geo.builders.CircleBuilder;
import org.opensearch.common.geo.builders.EllipseBuilder;
import org.opensearch.common.geo.builders.EnvelopeBuilder;
import org.opensearch.common.geo.builders.GeometryCollectionBuilder;
import org.opensearch.common.geo.builders.LineStringBuilder;
import org.opensearch.common.geo.builders.MultiLineStringBuilder;
import org.opensearch.common.geo.builders.MultiPointBuilder;
import org.opensearch.common.geo.builders.MultiPolygonBuilder;
import org.opensearch.common.geo.builders.PointBuilder;
import org.opensearch.common.geo.builders.PolygonBuilder;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.opensearch.index.mapper.LegacyGeoShapeFieldMapper;

@Deprecated
public class LegacyGeoShapeQueryProcessor {
    private AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType ft;

    public LegacyGeoShapeQueryProcessor(AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType ft) {
        this.ft = ft;
    }

    public Query geoShapeQuery(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, QueryShardContext context) {
        PrefixTreeStrategy prefixTreeStrategy;
        if (!context.allowExpensiveQueries()) {
            throw new SkyliteException("[geo-shape] queries on [PrefixTree geo shapes] cannot be executed when '" + SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        LegacyGeoShapeFieldMapper.GeoShapeFieldType shapeFieldType = (LegacyGeoShapeFieldMapper.GeoShapeFieldType)this.ft;
        SpatialStrategy spatialStrategy = shapeFieldType.strategy();
        if (strategy != null) {
            spatialStrategy = strategy;
        }
        if ((prefixTreeStrategy = shapeFieldType.resolvePrefixTreeStrategy(spatialStrategy)) instanceof RecursivePrefixTreeStrategy && relation == ShapeRelation.DISJOINT) {
            BooleanQuery.Builder bool = new BooleanQuery.Builder();
            Query exists = ExistsQueryBuilder.newFilter((QueryShardContext)context, (String)fieldName, (boolean)false);
            Query intersects = prefixTreeStrategy.makeQuery(LegacyGeoShapeQueryProcessor.getArgs(shape, ShapeRelation.INTERSECTS));
            bool.add(exists, BooleanClause.Occur.MUST);
            bool.add(intersects, BooleanClause.Occur.MUST_NOT);
            return bool.build();
        }
        return prefixTreeStrategy.makeQuery(LegacyGeoShapeQueryProcessor.getArgs(shape, relation));
    }

    public static SpatialArgs getArgs(Geometry shape, ShapeRelation relation) {
        switch (relation) {
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
            case CONTAINS: {
                return new SpatialArgs(SpatialOperation.Contains, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
        }
        throw new IllegalArgumentException("invalid relation [" + String.valueOf(relation) + "]");
    }

    private static Shape buildS4J(Geometry geometry) {
        return LegacyGeoShapeQueryProcessor.geometryToShapeBuilder(geometry).buildS4J();
    }

    public static ShapeBuilder<?, ?, ?> geometryToShapeBuilder(Geometry geometry) {
        ShapeBuilder shapeBuilder = (ShapeBuilder)geometry.visit(new GeometryVisitor<ShapeBuilder<?, ?, ?>, RuntimeException>(){

            public ShapeBuilder<?, ?, ?> visit(Circle circle) {
                return new CircleBuilder().center(circle.getLon(), circle.getLat()).radius(circle.getRadiusMeters(), DistanceUnit.METERS);
            }

            public ShapeBuilder<?, ?, ?> visit(Ellipse ellipse) {
                return new EllipseBuilder().center(ellipse.getLon(), ellipse.getLat()).semiMajorAxis(ellipse.getSemiMajorAxisMeters(), DistanceUnit.METERS).semiMinorAxis(ellipse.getSemiMinorAxisMeters(), DistanceUnit.METERS).orientationDegrees(ellipse.getOrientationDegrees());
            }

            public ShapeBuilder<?, ?, ?> visit(GeometryCollection<?> collection) {
                GeometryCollectionBuilder shapes = new GeometryCollectionBuilder();
                for (Geometry geometry : collection) {
                    shapes.shape((ShapeBuilder)geometry.visit((GeometryVisitor)this));
                }
                return shapes;
            }

            public ShapeBuilder<?, ?, ?> visit(Line line) {
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                for (int i = 0; i < line.length(); ++i) {
                    coordinates.add(new Coordinate(line.getX(i), line.getY(i), line.getZ(i)));
                }
                return new LineStringBuilder(coordinates);
            }

            public ShapeBuilder<?, ?, ?> visit(LinearRing ring) {
                throw new UnsupportedOperationException("circle is not supported");
            }

            public ShapeBuilder<?, ?, ?> visit(MultiLine multiLine) {
                MultiLineStringBuilder lines = new MultiLineStringBuilder();
                for (int i = 0; i < multiLine.size(); ++i) {
                    lines.linestring((LineStringBuilder)this.visit((Line)multiLine.get(i)));
                }
                return lines;
            }

            public ShapeBuilder<?, ?, ?> visit(MultiPoint multiPoint) {
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                for (int i = 0; i < multiPoint.size(); ++i) {
                    Point p = (Point)multiPoint.get(i);
                    coordinates.add(new Coordinate(p.getX(), p.getY(), p.getZ()));
                }
                return new MultiPointBuilder(coordinates);
            }

            public ShapeBuilder<?, ?, ?> visit(MultiPolygon multiPolygon) {
                MultiPolygonBuilder polygons = new MultiPolygonBuilder();
                for (int i = 0; i < multiPolygon.size(); ++i) {
                    polygons.polygon((PolygonBuilder)this.visit((Polygon)multiPolygon.get(i)));
                }
                return polygons;
            }

            public ShapeBuilder<?, ?, ?> visit(Point point) {
                return new PointBuilder(point.getX(), point.getY());
            }

            public ShapeBuilder<?, ?, ?> visit(Polygon polygon) {
                PolygonBuilder polygonBuilder = new PolygonBuilder((LineStringBuilder)this.visit((Line)polygon.getPolygon()), ShapeBuilder.Orientation.RIGHT, false);
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    polygonBuilder.hole((LineStringBuilder)this.visit((Line)polygon.getHole(i)));
                }
                return polygonBuilder;
            }

            public ShapeBuilder<?, ?, ?> visit(Rectangle rectangle) {
                return new EnvelopeBuilder(new Coordinate(rectangle.getMinX(), rectangle.getMaxY()), new Coordinate(rectangle.getMaxX(), rectangle.getMinY()));
            }
        });
        return shapeBuilder;
    }
}

