/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.MatchNoneQueryBuilder;
import io.skylite.core.index.query.MultiTermQueryBuilder;
import io.skylite.core.index.query.PrefixQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryBuilderVisitor;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.index.query.SpanQueryBuilder;
import io.skylite.core.index.query.support.QueryParsers;
import io.skylite.core.lucene.queries.SpanMatchNoDocsQuery;
import io.skylite.core.lucene.search.SpanBooleanQueryRewriteWithMaxClause;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopTermsRewrite;

public class SpanMultiTermQueryBuilder
extends AbstractQueryBuilder<SpanMultiTermQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_multi";
    private static final ParseField MATCH_FIELD = new ParseField("match", new String[0]);
    private final MultiTermQueryBuilder multiTermQueryBuilder;

    public SpanMultiTermQueryBuilder(MultiTermQueryBuilder multiTermQueryBuilder) {
        if (multiTermQueryBuilder == null) {
            throw new IllegalArgumentException("inner multi term query cannot be null");
        }
        this.multiTermQueryBuilder = multiTermQueryBuilder;
    }

    public SpanMultiTermQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.multiTermQueryBuilder = (MultiTermQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.multiTermQueryBuilder);
    }

    public MultiTermQueryBuilder innerQuery() {
        return this.multiTermQueryBuilder;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(MATCH_FIELD.getPreferredName());
        this.multiTermQueryBuilder.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static SpanMultiTermQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        MultiTermQueryBuilder subQuery = null;
        String queryName = null;
        float boost = 1.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    QueryBuilder query = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    if (!(query instanceof MultiTermQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "[span_multi] [" + MATCH_FIELD.getPreferredName() + "] must be of type multi term query", new Object[0]);
                    }
                    subQuery = (MultiTermQueryBuilder)query;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_multi] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_multi] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (subQuery == null) {
            throw new ParsingException(parser.getTokenLocation(), "[span_multi] must have [" + MATCH_FIELD.getPreferredName() + "] multi term query clause", new Object[0]);
        }
        return (SpanMultiTermQueryBuilder)((SpanMultiTermQueryBuilder)new SpanMultiTermQueryBuilder(subQuery).queryName(queryName)).boost(boost);
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        QueryBuilder multiTermQueryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)this.multiTermQueryBuilder, (QueryRewriteContext)context);
        if (multiTermQueryBuilder instanceof MatchNoneQueryBuilder) {
            return new SpanMatchNoDocsQuery(this.multiTermQueryBuilder.fieldName(), "Inner query rewrote to match_none");
        }
        if (multiTermQueryBuilder instanceof PrefixQueryBuilder) {
            SpanBooleanQueryRewriteWithMaxClause spanRewriteMethod;
            PrefixQueryBuilder prefixBuilder = (PrefixQueryBuilder)multiTermQueryBuilder;
            MappedFieldType fieldType = context.getFieldType(prefixBuilder.fieldName());
            if (fieldType == null) {
                throw new IllegalStateException("Rewrite first");
            }
            if (prefixBuilder.rewrite() != null) {
                MultiTermQuery.RewriteMethod rewriteMethod = QueryParsers.parseRewriteMethod((String)prefixBuilder.rewrite(), null, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
                if (rewriteMethod instanceof TopTermsRewrite) {
                    TopTermsRewrite innerRewrite = (TopTermsRewrite)rewriteMethod;
                    spanRewriteMethod = new SpanMultiTermQueryWrapper.TopTermsSpanBooleanQueryRewrite(innerRewrite.getSize());
                } else {
                    spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause();
                }
            } else {
                spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause();
            }
            return fieldType.spanPrefixQuery(prefixBuilder.value(), (SpanMultiTermQueryWrapper.SpanRewriteMethod)spanRewriteMethod, context);
        }
        Query subQuery = multiTermQueryBuilder.toQuery((QueryRewriteContext)context);
        while (true) {
            if (subQuery instanceof ConstantScoreQuery) {
                subQuery = ((ConstantScoreQuery)subQuery).getQuery();
                continue;
            }
            if (!(subQuery instanceof BoostQuery)) break;
            BoostQuery boostQuery = (BoostQuery)subQuery;
            subQuery = boostQuery.getQuery();
        }
        if (subQuery instanceof MatchNoDocsQuery) {
            return new SpanMatchNoDocsQuery(this.multiTermQueryBuilder.fieldName(), subQuery.toString());
        }
        if (!(subQuery instanceof MultiTermQuery)) {
            throw new UnsupportedOperationException("unsupported inner query, should be " + MultiTermQuery.class.getName() + " but was " + subQuery.getClass().getName());
        }
        MultiTermQuery multiTermQuery = (MultiTermQuery)subQuery;
        SpanMultiTermQueryWrapper wrapper = new SpanMultiTermQueryWrapper(multiTermQuery);
        if (!(multiTermQuery.getRewriteMethod() instanceof TopTermsRewrite)) {
            wrapper.setRewriteMethod((SpanMultiTermQueryWrapper.SpanRewriteMethod)new SpanBooleanQueryRewriteWithMaxClause());
        }
        return wrapper;
    }

    protected int doHashCode() {
        return Objects.hash(this.multiTermQueryBuilder);
    }

    protected boolean doEquals(SpanMultiTermQueryBuilder other) {
        return Objects.equals(this.multiTermQueryBuilder, other.multiTermQueryBuilder);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void visit(QueryBuilderVisitor visitor) {
        visitor.accept((QueryBuilder)this);
        if (this.multiTermQueryBuilder != null) {
            visitor.getChildVisitor(BooleanClause.Occur.MUST).accept((QueryBuilder)this.multiTermQueryBuilder);
        }
    }
}

