/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.functionscore;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.functionscore.ScoreFunctionBuilder;
import io.skylite.core.lucene.search.function.ScoreFunction;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.common.lucene.search.function.FieldValueFactorFunction;

public class FieldValueFactorFunctionBuilder
extends ScoreFunctionBuilder<FieldValueFactorFunctionBuilder> {
    public static final String NAME = "field_value_factor";
    public static final FieldValueFactorFunction.Modifier DEFAULT_MODIFIER = FieldValueFactorFunction.Modifier.NONE;
    public static final float DEFAULT_FACTOR = 1.0f;
    private final String field;
    private float factor = 1.0f;
    private Double missing;
    private FieldValueFactorFunction.Modifier modifier = DEFAULT_MODIFIER;

    public FieldValueFactorFunctionBuilder(String fieldName) {
        this(fieldName, null);
    }

    public FieldValueFactorFunctionBuilder(String fieldName, @Nullable String functionName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("field_value_factor: field must not be null");
        }
        this.field = fieldName;
        this.setFunctionName(functionName);
    }

    public FieldValueFactorFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.factor = in.readFloat();
        this.missing = in.readOptionalDouble();
        this.modifier = FieldValueFactorFunction.Modifier.readFromStream(in);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeFloat(this.factor);
        out.writeOptionalDouble(this.missing);
        this.modifier.writeTo(out);
    }

    public String getName() {
        return NAME;
    }

    public String fieldName() {
        return this.field;
    }

    public FieldValueFactorFunctionBuilder factor(float boostFactor) {
        this.factor = boostFactor;
        return this;
    }

    public float factor() {
        return this.factor;
    }

    public FieldValueFactorFunctionBuilder missing(double missing) {
        this.missing = missing;
        return this;
    }

    public Double missing() {
        return this.missing;
    }

    public FieldValueFactorFunctionBuilder modifier(FieldValueFactorFunction.Modifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException("field_value_factor: modifier must not be null");
        }
        this.modifier = modifier;
        return this;
    }

    public FieldValueFactorFunction.Modifier modifier() {
        return this.modifier;
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field("field", this.field);
        builder.field("factor", this.factor);
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        builder.field("modifier", this.modifier.name().toLowerCase(Locale.ROOT));
        builder.endObject();
    }

    protected boolean doEquals(FieldValueFactorFunctionBuilder functionBuilder) {
        return Objects.equals(this.field, functionBuilder.field) && Objects.equals(Float.valueOf(this.factor), Float.valueOf(functionBuilder.factor)) && Objects.equals(this.missing, functionBuilder.missing) && Objects.equals((Object)this.modifier, (Object)functionBuilder.modifier);
    }

    protected int doHashCode() {
        return Objects.hash(new Object[]{this.field, Float.valueOf(this.factor), this.missing, this.modifier});
    }

    protected ScoreFunction doToFunction(QueryShardContext context) {
        IndexNumericFieldData fieldData = null;
        if (context.isFieldMapped(this.field)) {
            fieldData = (IndexNumericFieldData)context.getForField(context.getFieldType(this.field));
        } else if (this.missing == null) {
            throw new SkyliteException("Unable to find a field mapper for field [" + this.field + "]. No 'missing' value defined.", new Object[0]);
        }
        return new FieldValueFactorFunction(this.field, this.factor, this.modifier, this.missing, fieldData, this.getFunctionName());
    }

    public static FieldValueFactorFunctionBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        String currentFieldName = null;
        String field = null;
        float boostFactor = 1.0f;
        FieldValueFactorFunction.Modifier modifier = FieldValueFactorFunction.Modifier.NONE;
        Double missing = null;
        String functionName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("factor".equals(currentFieldName)) {
                    boostFactor = parser.floatValue();
                    continue;
                }
                if ("modifier".equals(currentFieldName)) {
                    modifier = FieldValueFactorFunction.Modifier.fromString(parser.text());
                    continue;
                }
                if ("missing".equals(currentFieldName)) {
                    missing = parser.doubleValue();
                    continue;
                }
                if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    functionName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "field_value_factor query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!"factor".equals(currentFieldName) || token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.START_OBJECT) continue;
            throw new ParsingException(parser.getTokenLocation(), "[field_value_factor] field 'factor' does not support lists or objects", new Object[0]);
        }
        if (field == null) {
            throw new ParsingException(parser.getTokenLocation(), "[field_value_factor] required field 'field' missing", new Object[0]);
        }
        FieldValueFactorFunctionBuilder fieldValueFactorFunctionBuilder = new FieldValueFactorFunctionBuilder(field, functionName).factor(boostFactor).modifier(modifier);
        if (missing != null) {
            fieldValueFactorFunctionBuilder.missing(missing);
        }
        return fieldValueFactorFunctionBuilder;
    }
}

