/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.functionscore;

import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.functionscore.ScoreFunctionBuilder;
import io.skylite.core.lucene.search.function.ScoreFunction;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.lucene.search.function.RandomScoreFunction;

public class RandomScoreFunctionBuilder
extends ScoreFunctionBuilder<RandomScoreFunctionBuilder> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RandomScoreFunctionBuilder.class);
    public static final String NAME = "random_score";
    private String field;
    private Integer seed;

    public RandomScoreFunctionBuilder() {
    }

    public RandomScoreFunctionBuilder(@Nullable String functionName) {
        this.setFunctionName(functionName);
    }

    public RandomScoreFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.seed = in.readInt();
        }
        this.field = in.readOptionalString();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.seed != null) {
            out.writeBoolean(true);
            out.writeInt(this.seed.intValue());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.field);
    }

    public String getName() {
        return NAME;
    }

    public RandomScoreFunctionBuilder seed(int seed) {
        this.seed = seed;
        return this;
    }

    public RandomScoreFunctionBuilder seed(long seed) {
        this.seed = RandomScoreFunctionBuilder.hash(seed);
        return this;
    }

    public RandomScoreFunctionBuilder seed(String seed) {
        if (seed == null) {
            throw new IllegalArgumentException("random_score function: seed must not be null");
        }
        this.seed = seed.hashCode();
        return this;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public RandomScoreFunctionBuilder setField(String field) {
        this.field = field;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.seed != null) {
            builder.field("seed", this.seed);
        }
        if (this.field != null) {
            builder.field("field", this.field);
        }
        builder.endObject();
    }

    protected boolean doEquals(RandomScoreFunctionBuilder functionBuilder) {
        return Objects.equals(this.seed, functionBuilder.seed);
    }

    protected int doHashCode() {
        return Objects.hash(this.seed);
    }

    protected ScoreFunction doToFunction(QueryShardContext context) {
        int salt = context.index().getName().hashCode() << 10 | context.getShardId();
        if (this.seed == null) {
            return new RandomScoreFunction(RandomScoreFunctionBuilder.hash(context.nowInMillis()), salt, null, this.getFunctionName());
        }
        String fieldName = this.field;
        if (this.field == null) {
            deprecationLogger.deprecate("seed_requires_field", "OpenSearch requires that a [field] parameter is provided when a [seed] is set", new Object[0]);
            fieldName = ParseField.CommonMetaFields.ID_FIELD.getPreferredName();
        }
        if (!context.isFieldMapped(fieldName)) {
            if (!context.hasMappings()) {
                return new RandomScoreFunction(RandomScoreFunctionBuilder.hash(context.nowInMillis()), salt, null, this.getFunctionName());
            }
            throw new IllegalArgumentException("Field [" + this.field + "] is not mapped on [" + String.valueOf(context.index()) + "] and cannot be used as a source of random numbers.");
        }
        int seed = this.seed == null ? RandomScoreFunctionBuilder.hash(context.nowInMillis()) : this.seed;
        return new RandomScoreFunction(seed, salt, context.getForField(context.getFieldType(fieldName)), this.getFunctionName());
    }

    private static int hash(long value) {
        return Long.hashCode(value);
    }

    public static RandomScoreFunctionBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        RandomScoreFunctionBuilder randomScoreFunctionBuilder = new RandomScoreFunctionBuilder();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("seed".equals(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (parser.numberType() == XContentParser.NumberType.INT) {
                        randomScoreFunctionBuilder.seed(parser.intValue());
                        continue;
                    }
                    if (parser.numberType() == XContentParser.NumberType.LONG) {
                        randomScoreFunctionBuilder.seed(parser.longValue());
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "random_score seed must be an int, long or string, not '" + token.toString() + "'", new Object[0]);
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    randomScoreFunctionBuilder.seed(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "random_score seed must be an int/long or string, not '" + token.toString() + "'", new Object[0]);
            }
            if ("field".equals(currentFieldName)) {
                randomScoreFunctionBuilder.setField(parser.text());
                continue;
            }
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                randomScoreFunctionBuilder.setFunctionName(parser.text());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "random_score query does not support [" + currentFieldName + "]", new Object[0]);
        }
        return randomScoreFunctionBuilder;
    }
}

