/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.functionscore;

import io.skylite.common.Nullable;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.index.query.functionscore.ScoreFunctionBuilder;
import io.skylite.core.lucene.search.function.ScoreFunction;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.lucene.search.function.ScriptScoreFunction;
import org.opensearch.script.ScoreScript;

public class ScriptScoreFunctionBuilder
extends ScoreFunctionBuilder<ScriptScoreFunctionBuilder> {
    public static final String NAME = "script_score";
    private final Script script;

    public ScriptScoreFunctionBuilder(Script script) {
        this(script, null);
    }

    public ScriptScoreFunctionBuilder(Script script, @Nullable String functionName) {
        if (script == null) {
            throw new IllegalArgumentException("script must not be null");
        }
        this.script = script;
        this.setFunctionName(functionName);
    }

    public ScriptScoreFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    public Script getScript() {
        return this.script;
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), (ToXContent)this.script);
        builder.endObject();
    }

    public String getName() {
        return NAME;
    }

    protected boolean doEquals(ScriptScoreFunctionBuilder functionBuilder) {
        return Objects.equals(this.script, functionBuilder.script);
    }

    protected int doHashCode() {
        return Objects.hash(this.script);
    }

    protected ScoreFunction doToFunction(QueryShardContext context) {
        try {
            ScoreScript.Factory factory = (ScoreScript.Factory)context.compile(this.script, ScoreScript.CONTEXT);
            ScoreScript.LeafFactory searchScript = factory.newFactory(this.script.getParams(), context.lookup(), context.searcher());
            return new ScriptScoreFunction(this.script, searchScript, context.index().getName(), context.getShardId(), context.indexVersionCreated(), this.getFunctionName());
        }
        catch (Exception e) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "script_score: the script could not be loaded", (Throwable)e, new Object[0]);
        }
    }

    public static ScriptScoreFunctionBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        Script script = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                script = Script.parse((XContentParser)parser);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "script_score query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (script == null) {
            throw new ParsingException(parser.getTokenLocation(), "script_score requires 'script' field", new Object[0]);
        }
        return new ScriptScoreFunctionBuilder(script);
    }
}

