/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.recovery;

import io.skylite.common.Nullable;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.remotestore.restore.RestoreRemoteStoreRequest;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexTemplateMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.RepositoriesMetadata;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.blobstore.BlobStoreRepositorySettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.snapshots.RestoreCompletionResponse;
import io.skylite.core.snapshots.RestoreInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.indices.ShardLimitValidator;

public class RemoteStoreRestoreService {
    private static final Logger logger = LogManager.getLogger(RemoteStoreRestoreService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final ShardLimitValidator shardLimitValidator;
    private final RemoteClusterStateService remoteClusterStateService;

    public RemoteStoreRestoreService(ClusterService clusterService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataIndexUpgradeService metadataIndexUpgradeService, ShardLimitValidator shardLimitValidator, RemoteClusterStateService remoteClusterStateService) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.shardLimitValidator = shardLimitValidator;
        this.remoteClusterStateService = remoteClusterStateService;
    }

    public void restore(final RestoreRemoteStoreRequest request, final ActionListener<RestoreCompletionResponse> listener) {
        this.clusterService.submitStateUpdateTask("restore[remote_store]", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){
            String restoreUUID;
            RestoreInfo restoreInfo = null;

            public ClusterState execute(ClusterState currentState) {
                RemoteRestoreResult remoteRestoreResult = RemoteStoreRestoreService.this.restore(currentState, null, request.restoreAllShards(), request.indices());
                this.restoreUUID = remoteRestoreResult.getRestoreUUID();
                this.restoreInfo = remoteRestoreResult.getRestoreInfo();
                return remoteRestoreResult.getClusterState();
            }

            public void onFailure(String source, Exception e) {
                logger.warn("failed to restore from remote store", (Throwable)e);
                listener.onFailure(e);
            }

            public TimeValue timeout() {
                return request.clusterManagerNodeTimeout();
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new RestoreCompletionResponse(this.restoreUUID, null, this.restoreInfo));
            }
        });
    }

    public RemoteRestoreResult restore(ClusterState currentState, @Nullable String restoreClusterUUID, boolean restoreAllShards, String[] indexNames) {
        boolean metadataFromRemoteStore;
        HashMap<String, Tuple<Boolean, IndexMetadata>> indexMetadataMap = new HashMap<String, Tuple<Boolean, IndexMetadata>>();
        ClusterState remoteState = null;
        boolean bl = metadataFromRemoteStore = !(restoreClusterUUID == null || restoreClusterUUID.isEmpty() || restoreClusterUUID.isBlank());
        if (metadataFromRemoteStore) {
            try {
                if (currentState.metadata().clusterUUID().equals(restoreClusterUUID)) {
                    throw new IllegalArgumentException("clusterUUID to restore from should be different from current cluster UUID");
                }
                logger.info("Restoring cluster state from remote store from cluster UUID : [{}]", (Object)restoreClusterUUID);
                remoteState = this.remoteClusterStateService.getLatestClusterState(currentState.getClusterName().value(), restoreClusterUUID);
                remoteState.getMetadata().getIndices().values().forEach(indexMetadata -> indexMetadataMap.put(indexMetadata.getIndex().getName(), new Tuple((Object)true, indexMetadata)));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to restore remote index metadata", e);
            }
        } else {
            for (String indexName : indexNames) {
                IndexMetadata indexMetadata2 = currentState.metadata().index(indexName);
                if (indexMetadata2 == null) {
                    logger.warn("Index restore is not supported for non-existent index. Skipping: {}", (Object)indexName);
                    continue;
                }
                if (!indexMetadata2.getSettings().getAsBoolean("index.remote_store.enabled", Boolean.valueOf(false)).booleanValue()) {
                    logger.warn("Remote store is not enabled for index: {}", (Object)indexName);
                    continue;
                }
                if (restoreAllShards && !IndexMetadata.State.CLOSE.equals((Object)indexMetadata2.getState())) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "cannot restore index [%s] because an open index with same name/uuid already exists in the cluster.", indexName) + " Close the existing index.");
                }
                indexMetadataMap.put(indexName, (Tuple<Boolean, IndexMetadata>)new Tuple((Object)false, (Object)indexMetadata2));
            }
        }
        return this.executeRestore(currentState, indexMetadataMap, restoreAllShards, remoteState);
    }

    private RemoteRestoreResult executeRestore(ClusterState currentState, Map<String, Tuple<Boolean, IndexMetadata>> indexMetadataMap, boolean restoreAllShards, ClusterState remoteState) {
        String restoreUUID = UUIDs.randomBase64UUID();
        ArrayList<String> indicesToBeRestored = new ArrayList<String>();
        int totalShards = 0;
        boolean metadataFromRemoteStore = false;
        ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder rtBuilder = RoutingTable.builder((RoutingTable)currentState.routingTable());
        for (Map.Entry<String, Tuple<Boolean, IndexMetadata>> indexMetadataEntry : indexMetadataMap.entrySet()) {
            String indexName = indexMetadataEntry.getKey();
            IndexMetadata indexMetadata = (IndexMetadata)indexMetadataEntry.getValue().v2();
            metadataFromRemoteStore = (Boolean)indexMetadataEntry.getValue().v1();
            IndexMetadata updatedIndexMetadata = indexMetadata;
            if (!metadataFromRemoteStore && restoreAllShards) {
                updatedIndexMetadata = IndexMetadata.builder((IndexMetadata)indexMetadata).state(IndexMetadata.State.OPEN).version(1L + indexMetadata.getVersion()).mappingVersion(1L + indexMetadata.getMappingVersion()).settingsVersion(1L + indexMetadata.getSettingsVersion()).aliasesVersion(1L + indexMetadata.getAliasesVersion()).build();
            }
            IndexId indexId = new IndexId(indexName, updatedIndexMetadata.getIndexUUID());
            if (!metadataFromRemoteStore) {
                Map indexShardRoutingTableMap = currentState.routingTable().index(indexName).shards().values().stream().collect(Collectors.toMap(IndexShardRoutingTable::shardId, Function.identity()));
                RecoverySource.RemoteStoreRecoverySource recoverySource = new RecoverySource.RemoteStoreRecoverySource(restoreUUID, updatedIndexMetadata.getCreationVersion(), indexId);
                rtBuilder.addAsRemoteStoreRestore(updatedIndexMetadata, recoverySource, indexShardRoutingTableMap, restoreAllShards);
            }
            blocks.updateBlocks(updatedIndexMetadata);
            mdBuilder.put(updatedIndexMetadata, true);
            indicesToBeRestored.add(indexName);
            totalShards += updatedIndexMetadata.getNumberOfShards();
        }
        if (remoteState != null) {
            this.restoreGlobalMetadata(mdBuilder, remoteState.getMetadata());
            logger.info("Restoring ClusterState with Remote State version [{}]", (Object)remoteState.version());
            builder.version(remoteState.version());
        }
        RestoreInfo restoreInfo = new RestoreInfo("remote_store", indicesToBeRestored, totalShards, totalShards);
        RoutingTable rt = rtBuilder.build();
        ClusterState updatedState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
        if (!metadataFromRemoteStore) {
            updatedState = this.allocationService.reroute(updatedState, "restored from remote store");
        }
        return RemoteRestoreResult.build(restoreUUID, restoreInfo, updatedState);
    }

    private void restoreGlobalMetadata(Metadata.Builder mdBuilder, Metadata remoteMetadata) {
        if (remoteMetadata.persistentSettings() != null) {
            Settings settings = remoteMetadata.persistentSettings();
            this.clusterService.getClusterSettings().validateUpdate(settings);
            mdBuilder.persistentSettings(settings);
        }
        if (remoteMetadata.templates() != null) {
            for (IndexTemplateMetadata indexTemplateMetadata : remoteMetadata.templates().values()) {
                mdBuilder.put(indexTemplateMetadata);
            }
        }
        if (remoteMetadata.customs() != null) {
            for (Map.Entry entry : remoteMetadata.customs().entrySet()) {
                if ("repositories".equals(entry.getKey())) continue;
                mdBuilder.putCustom((String)entry.getKey(), (Metadata.Custom)entry.getValue());
            }
        }
        Optional<RepositoriesMetadata> repositoriesMetadata = Optional.ofNullable((RepositoriesMetadata)remoteMetadata.custom("repositories"));
        repositoriesMetadata = repositoriesMetadata.map(repositoriesMetadata1 -> new RepositoriesMetadata(repositoriesMetadata1.repositories().stream().filter(repository -> (Boolean)BlobStoreRepositorySettings.SYSTEM_REPOSITORY_SETTING.get(repository.settings()) == false).collect(Collectors.toList())));
        repositoriesMetadata.ifPresent(metadata -> mdBuilder.putCustom("repositories", (Metadata.Custom)metadata));
    }

    public static class RemoteRestoreResult {
        private final ClusterState clusterState;
        private final RestoreInfo restoreInfo;
        private final String restoreUUID;

        private RemoteRestoreResult(String restoreUUID, RestoreInfo restoreInfo, ClusterState clusterState) {
            this.clusterState = clusterState;
            this.restoreInfo = restoreInfo;
            this.restoreUUID = restoreUUID;
        }

        public static RemoteRestoreResult build(String restoreUUID, RestoreInfo restoreInfo, ClusterState clusterState) {
            return new RemoteRestoreResult(restoreUUID, restoreInfo, clusterState);
        }

        public ClusterState getClusterState() {
            return this.clusterState;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }

        public String getRestoreUUID() {
            return this.restoreUUID;
        }
    }
}

