/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.seqno;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexShardClosedException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.TranslogSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.indices.IndicesService;

public class GlobalCheckpointSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static String ACTION_NAME = "indices:admin/seq_no/global_checkpoint_sync";

    @Inject
    public GlobalCheckpointSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService::indexServiceSafe, threadPool, shardStateAction::remoteShardFailed, actionFilters, Request::new, Request::new, "management");
    }

    public void updateGlobalCheckpointForShard(ShardId shardId) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.execute((ActionRequest)new Request(shardId), ActionListenerHelper.wrap(r -> {}, e -> {
                if (SkyliteExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{AlreadyClosedException.class, IndexShardClosedException.class}) == null) {
                    this.logger.info((Message)new ParameterizedMessage("{} global checkpoint sync failed", (Object)shardId), (Throwable)e);
                }
            }));
        }
    }

    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    protected void shardOperationOnPrimary(Request request, BaseIndexShard indexShard, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            this.maybeSyncTranslog(indexShard);
            return new TransportReplicationAction.PrimaryResult((ReplicationRequest)request, new ReplicationResponse());
        });
    }

    protected void shardOperationOnReplica(Request shardRequest, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            this.maybeSyncTranslog(replica);
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    private void maybeSyncTranslog(BaseIndexShard indexShard) throws IOException {
        if (indexShard.getTranslogDurability() == TranslogSettings.Durability.REQUEST && indexShard.getLastSyncedGlobalCheckpoint() < indexShard.getLastKnownGlobalCheckpoint() && !indexShard.indexSettings().isAssignedOnRemoteNode()) {
            indexShard.sync();
        }
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(ShardId shardId) {
            super(shardId);
        }

        public String toString() {
            return "GlobalCheckpointSyncAction.Request{shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", index='" + this.index + "', waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + "}";
        }
    }
}

