/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.metrics.MeanMetric;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.IndexingStats;
import io.skylite.core.index.shard.ShardId;
import java.util.concurrent.TimeUnit;

final class InternalIndexingStats
implements IndexingOperationListener {
    private final StatsHolder totalStats = new StatsHolder();

    InternalIndexingStats() {
    }

    IndexingStats stats(boolean isThrottled, long currentThrottleInMillis) {
        IndexingStats.Stats total = this.totalStats.stats(isThrottled, currentThrottleInMillis);
        return new IndexingStats(total);
    }

    public EngineOperation.Index preIndex(ShardId shardId, EngineOperation.Index operation) {
        if (!operation.origin().isRecovery()) {
            this.totalStats.indexCurrent.inc();
        }
        return operation;
    }

    public void postIndex(ShardId shardId, EngineOperation.Index index, EngineResult.IndexResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (index.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.indexMetric.inc(took);
                this.totalStats.indexCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postIndex(shardId, index, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + String.valueOf(result.getResultType()));
            }
        }
    }

    public void postIndex(ShardId shardId, EngineOperation.Index index, Exception ex) {
        if (!index.origin().isRecovery()) {
            this.totalStats.indexCurrent.dec();
            this.totalStats.indexFailed.inc();
        }
    }

    public EngineOperation.Delete preDelete(ShardId shardId, EngineOperation.Delete delete) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.inc();
        }
        return delete;
    }

    public void postDelete(ShardId shardId, EngineOperation.Delete delete, EngineResult.DeleteResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (delete.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.deleteMetric.inc(took);
                this.totalStats.deleteCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postDelete(shardId, delete, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + String.valueOf(result.getResultType()));
            }
        }
    }

    public void postDelete(ShardId shardId, EngineOperation.Delete delete, Exception ex) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.dec();
        }
    }

    void noopUpdate() {
        this.totalStats.noopUpdates.inc();
    }

    static class StatsHolder {
        private final MeanMetric indexMetric = new MeanMetric();
        private final MeanMetric deleteMetric = new MeanMetric();
        private final CounterMetric indexCurrent = new CounterMetric();
        private final CounterMetric indexFailed = new CounterMetric();
        private final CounterMetric deleteCurrent = new CounterMetric();
        private final CounterMetric noopUpdates = new CounterMetric();

        StatsHolder() {
        }

        IndexingStats.Stats stats(boolean isThrottled, long currentThrottleMillis) {
            return new IndexingStats.Stats(this.indexMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.indexMetric.sum()), this.indexCurrent.count(), this.indexFailed.count(), this.deleteMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.deleteMetric.sum()), this.deleteCurrent.count(), this.noopUpdates.count(), isThrottled, TimeUnit.MILLISECONDS.toMillis(currentThrottleMillis), new IndexingStats.Stats.DocStatusStats());
        }
    }
}

