/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ReferenceManager;

public abstract class ReleasableRetryableRefreshListener
implements ReferenceManager.RefreshListener {
    private static final int TOTAL_PERMITS = 1;
    private static final TimeValue DRAIN_TIMEOUT = TimeValue.timeValueMinutes((long)10L);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Semaphore semaphore = new Semaphore(1);
    private final ThreadPool threadPool;
    private final AtomicBoolean retryScheduled = new AtomicBoolean(false);

    public ReleasableRetryableRefreshListener() {
        this.threadPool = null;
    }

    public ReleasableRetryableRefreshListener(ThreadPool threadPool) {
        assert (Objects.nonNull(threadPool));
        this.threadPool = threadPool;
    }

    public final void afterRefresh(boolean didRefresh) throws IOException {
        if (this.closed.get()) {
            return;
        }
        this.runAfterRefreshExactlyOnce(didRefresh);
        this.runAfterRefreshWithPermit(didRefresh, () -> {});
    }

    protected void runAfterRefreshExactlyOnce(boolean didRefresh) {
    }

    protected String getRetryThreadPoolName() {
        return "same";
    }

    protected TimeValue getNextRetryInterval() {
        return TimeValue.timeValueSeconds((long)1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRetry(TimeValue interval, String retryThreadPoolName, boolean didRefresh) {
        if (this.closed.get() || !this.isRetryEnabled()) {
            this.getLogger().debug("skip retry on closed={} isRetryEnabled={}", (Object)this.closed.get(), (Object)this.isRetryEnabled());
            return;
        }
        assert (Objects.nonNull(interval) && ThreadPool.THREAD_POOL_TYPES.containsKey(retryThreadPoolName));
        if (this.retryScheduled.getAndSet(true)) {
            this.getLogger().debug("skip retry on retryScheduled=true");
            return;
        }
        boolean scheduled = false;
        try {
            this.threadPool.schedule(() -> this.runAfterRefreshWithPermit(didRefresh, () -> this.retryScheduled.set(false)), interval, retryThreadPoolName);
            scheduled = true;
            this.getLogger().info("Scheduled retry with didRefresh={}", (Object)didRefresh);
        }
        finally {
            if (!scheduled) {
                this.retryScheduled.set(false);
            }
        }
    }

    protected boolean isRetryEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void runAfterRefreshWithPermit(boolean didRefresh, Runnable runFinally) {
        boolean successful;
        if (this.closed.get()) {
            return;
        }
        boolean permitAcquired = this.semaphore.tryAcquire();
        try {
            successful = permitAcquired && this.performAfterRefreshWithPermit(didRefresh);
        }
        finally {
            if (permitAcquired) {
                this.semaphore.release();
            }
            runFinally.run();
        }
        this.scheduleRetry(successful, didRefresh);
    }

    private void scheduleRetry(boolean afterRefreshSuccessful, boolean didRefresh) {
        if (!afterRefreshSuccessful) {
            this.scheduleRetry(this.getNextRetryInterval(), this.getRetryThreadPoolName(), didRefresh);
        }
    }

    protected abstract boolean performAfterRefreshWithPermit(boolean var1);

    public final Releasable drainRefreshes() {
        try {
            TimeValue timeout = this.getDrainTimeout();
            if (this.semaphore.tryAcquire(1, timeout.seconds(), TimeUnit.SECONDS)) {
                boolean result = this.closed.compareAndSet(false, true);
                assert (result && this.semaphore.availablePermits() == 0);
                this.getLogger().info("All permits are acquired and refresh listener is closed");
                return Releasables.releaseOnce(() -> {
                    this.semaphore.release(1);
                    boolean wasClosed = this.closed.getAndSet(false);
                    assert (this.semaphore.availablePermits() == 1) : "Available permits is " + this.semaphore.availablePermits();
                    assert (wasClosed) : "RefreshListener is not closed before reopening it";
                    this.getLogger().info("All permits are released and refresh listener is open");
                });
            }
            throw new TimeoutException("Timeout while acquiring all permits");
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to acquire all permits", e);
        }
    }

    protected abstract Logger getLogger();

    TimeValue getDrainTimeout() {
        return DRAIN_TIMEOUT;
    }

    boolean getRetryScheduledStatus() {
        return this.retryScheduled.get();
    }

    int availablePermits() {
        return this.semaphore.availablePermits();
    }

    boolean isClosed() {
        return this.closed.get();
    }
}

