/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.StepListener;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.BaseStoreRecovery;
import io.skylite.core.index.shard.IndexShardRecoveryException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.snapshots.IndexShardRestoreFailedException;
import io.skylite.core.index.snapshots.blobstore.RemoteStoreShardShallowCopySnapshot;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectory;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectoryFactory;
import io.skylite.core.index.translog.Checkpoint;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogHeader;
import io.skylite.core.index.translog.TranslogStatelessHelper;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.indices.replication.common.ReplicationLuceneIndex;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.opensearch.index.shard.IndexShard;

public class StoreRecovery
extends BaseStoreRecovery {
    public StoreRecovery(ShardId shardId, Logger logger) {
        super(shardId, logger);
    }

    public void recoverFromSnapshotAndRemoteStore(IndexShard indexShard, Repository repository, RepositoriesService repositoriesService, ActionListener<Boolean> listener, ThreadPool threadPool) {
        try {
            if (this.canRecover(indexShard)) {
                indexShard.preRecovery();
                RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
                assert (recoveryType == RecoverySource.Type.SNAPSHOT) : "expected snapshot recovery type: " + String.valueOf(recoveryType);
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)indexShard.recoveryState().getRecoverySource();
                RecoveryState.Translog translogState = indexShard.recoveryState().getTranslog();
                translogState.totalOperations(0);
                translogState.totalOperationsOnStart(0);
                indexShard.prepareForIndexRecovery();
                RemoteStoreShardShallowCopySnapshot shallowCopyShardMetadata = repository.getRemoteStoreShallowCopyShardMetadata(recoverySource.snapshot().getSnapshotId(), recoverySource.index(), this.shardId);
                long primaryTerm = shallowCopyShardMetadata.getPrimaryTerm();
                long commitGeneration = shallowCopyShardMetadata.getCommitGeneration();
                String indexUUID = shallowCopyShardMetadata.getIndexUUID();
                String remoteStoreRepository = ((RecoverySource.SnapshotRecoverySource)indexShard.recoveryState().getRecoverySource()).sourceRemoteStoreRepository();
                if (remoteStoreRepository == null) {
                    remoteStoreRepository = shallowCopyShardMetadata.getRemoteStoreRepository();
                }
                RemoteSegmentStoreDirectoryFactory directoryFactory = new RemoteSegmentStoreDirectoryFactory(() -> repositoriesService, threadPool);
                RemoteSegmentStoreDirectory sourceRemoteDirectory = (RemoteSegmentStoreDirectory)directoryFactory.newDirectory(remoteStoreRepository, indexUUID, this.shardId, shallowCopyShardMetadata.getRemoteStorePathStrategy());
                sourceRemoteDirectory.initializeToSpecificCommit(primaryTerm, commitGeneration, recoverySource.snapshot().getSnapshotId().getUUID());
                indexShard.syncSegmentsFromGivenRemoteSegmentStore(true, sourceRemoteDirectory, primaryTerm, commitGeneration);
                Store store = indexShard.store();
                if (!indexShard.indexSettings().isRemoteTranslogStoreEnabled()) {
                    this.bootstrap(indexShard, store);
                } else {
                    this.bootstrapForSnapshot(indexShard, store);
                }
                assert (indexShard.shardRouting().primary()) : "only primary shards can recover from store";
                StoreRecovery.writeEmptyRetentionLeasesFile((BaseIndexShard)indexShard);
                indexShard.recoveryState().getIndex().setFileDetailsComplete();
                if (indexShard.indexSettings().isRemoteStoreEnabled()) {
                    indexShard.openEngineAndSkipTranslogRecoveryFromSnapshot();
                } else {
                    indexShard.openEngineAndRecoverFromTranslog();
                }
                indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
                indexShard.finalizeRecovery();
                if (indexShard.isRemoteTranslogEnabled() && indexShard.shardRouting().primary()) {
                    indexShard.waitForRemoteStoreSync();
                    if (!indexShard.isRemoteSegmentStoreInSync()) {
                        listener.onFailure((Exception)new IndexShardRestoreFailedException(this.shardId, "Failed to upload to remote segment store"));
                        return;
                    }
                }
                indexShard.postRecovery("restore done");
                listener.onResponse((Object)true);
            } else {
                listener.onResponse((Object)false);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void recoverFromRepository(BaseIndexShard indexShard, Repository repository, ActionListener<Boolean> listener) {
        try {
            if (this.canRecover(indexShard)) {
                RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
                assert (recoveryType == RecoverySource.Type.SNAPSHOT) : "expected snapshot recovery type: " + String.valueOf(recoveryType);
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)indexShard.recoveryState().getRecoverySource();
                this.restore(indexShard, repository, recoverySource, (ActionListener<Boolean>)this.recoveryListener(indexShard, listener));
            } else {
                listener.onResponse((Object)false);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void restore(BaseIndexShard baseIndexShard, Repository repository, RecoverySource.SnapshotRecoverySource restoreSource, ActionListener<Boolean> listener) {
        IndexShard indexShard = (IndexShard)baseIndexShard;
        this.logger.debug("restoring from {} ...", (Object)indexShard.recoveryState().getRecoverySource());
        indexShard.preRecovery();
        RecoveryState.Translog translogState = indexShard.recoveryState().getTranslog();
        if (restoreSource == null) {
            listener.onFailure((Exception)new IndexShardRestoreFailedException(this.shardId, "empty restore source"));
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] restoring shard [{}]", (Object)restoreSource.snapshot(), (Object)this.shardId);
        }
        ActionListener restoreListener = ActionListenerHelper.wrap(v -> {
            Store store = indexShard.store();
            if (!indexShard.indexSettings().isRemoteTranslogStoreEnabled()) {
                this.bootstrap(indexShard, store);
            } else {
                this.bootstrapForSnapshot(indexShard, store);
            }
            assert (indexShard.shardRouting().primary()) : "only primary shards can recover from store";
            StoreRecovery.writeEmptyRetentionLeasesFile((BaseIndexShard)indexShard);
            if (indexShard.indexSettings().isRemoteStoreEnabled()) {
                indexShard.openEngineAndSkipTranslogRecoveryFromSnapshot();
            } else {
                indexShard.openEngineAndRecoverFromTranslog();
            }
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            if (indexShard.isRemoteTranslogEnabled() && indexShard.shardRouting().primary()) {
                indexShard.waitForRemoteStoreSync();
                if (!indexShard.isRemoteSegmentStoreInSync()) {
                    listener.onFailure((Exception)new IndexShardRestoreFailedException(this.shardId, "Failed to upload to remote segment store"));
                    return;
                }
            }
            indexShard.postRecovery("restore done");
            listener.onResponse((Object)true);
        }, e -> listener.onFailure((Exception)new IndexShardRestoreFailedException(this.shardId, "restore failed", (Throwable)e)));
        try {
            translogState.totalOperations(0);
            translogState.totalOperationsOnStart(0);
            indexShard.prepareForIndexRecovery();
            IndexId indexId = restoreSource.index();
            ShardId snapshotShardId = this.shardId.getIndexName().equals(indexId.getName()) ? this.shardId : new ShardId(indexId.getName(), "_na_", this.shardId.id());
            StepListener indexIdListener = new StepListener();
            if (indexId.getId().equals("_na_")) {
                repository.getRepositoryData(ActionListenerHelper.map((ActionListener)indexIdListener, repositoryData -> repositoryData.resolveIndexId(indexId.getName())));
            } else {
                indexIdListener.onResponse((Object)indexId);
            }
            assert (indexShard.getEngineOrNull() == null);
            indexIdListener.whenComplete(idx -> repository.restoreShard(indexShard.store(), restoreSource.snapshot().getSnapshotId(), idx, snapshotShardId, indexShard.recoveryState(), restoreListener), arg_0 -> ((ActionListener)restoreListener).onFailure(arg_0));
        }
        catch (Exception e2) {
            restoreListener.onFailure(e2);
        }
    }

    protected void recoverFromRemoteStore(BaseIndexShard baseIndexShard) throws IndexShardRecoveryException {
        IndexShard indexShard = (IndexShard)baseIndexShard;
        Store remoteStore = indexShard.remoteStore();
        if (remoteStore == null) {
            throw new IndexShardRecoveryException(indexShard.shardId(), "Remote store is not enabled for this index", (Throwable)new IllegalArgumentException());
        }
        indexShard.preRecovery();
        indexShard.prepareForIndexRecovery();
        Store store = indexShard.store();
        store.incRef();
        remoteStore.incRef();
        try {
            indexShard.syncSegmentsFromRemoteSegmentStore(true);
            indexShard.syncTranslogFilesFromRemoteTranslog();
            if (store.directory().listAll().length <= 1) {
                Path location = indexShard.shardPath().resolveTranslog();
                Checkpoint checkpoint = Checkpoint.read((Path)location.resolve("translog.ckp"));
                Path translogFile = location.resolve(TranslogStatelessHelper.getFilename((long)checkpoint.getGeneration()));
                try (FileChannel channel = FileChannel.open(translogFile, StandardOpenOption.READ);){
                    TranslogHeader translogHeader = TranslogHeader.read((Path)translogFile, (FileChannel)channel);
                    store.createEmpty(indexShard.indexSettings().getIndexVersionCreated().luceneVersion, translogHeader.getTranslogUUID());
                }
            }
            assert (indexShard.shardRouting().primary()) : "only primary shards can recover from store";
            indexShard.recoveryState().getIndex().setFileDetailsComplete();
            indexShard.openEngineAndRecoverFromTranslog();
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            indexShard.postRecovery("post recovery from remote_store");
        }
        catch (IndexShardRecoveryException | IOException e) {
            throw new IndexShardRecoveryException(indexShard.shardId(), "Exception while recovering from remote store", e);
        }
        finally {
            store.decRef();
            remoteStore.decRef();
        }
    }

    protected void internalRecoverFromStore(BaseIndexShard baseIndexShard) throws IndexShardRecoveryException {
        IndexShard indexShard = (IndexShard)baseIndexShard;
        indexShard.preRecovery();
        RecoveryState recoveryState = indexShard.recoveryState();
        boolean indexShouldExists = recoveryState.getRecoverySource().getType() != RecoverySource.Type.EMPTY_STORE;
        indexShard.prepareForIndexRecovery();
        SegmentInfos si = null;
        Store store = indexShard.store();
        store.incRef();
        try {
            try {
                block22: {
                    store.failIfCorrupted();
                    try {
                        si = store.readLastCommittedSegmentsInfo();
                    }
                    catch (Exception e) {
                        Object files = "_unknown_";
                        try {
                            files = Arrays.toString(store.directory().listAll());
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            files = (String)files + " (failure=" + SkyliteExceptionsHelper.detailedMessage((Throwable)inner) + ")";
                        }
                        if (!indexShouldExists) break block22;
                        throw new IndexShardRecoveryException(this.shardId, "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + (String)files, (Throwable)e);
                    }
                }
                if (si != null && !indexShouldExists) {
                    this.logger.trace("cleaning existing shard, shouldn't exists");
                    Lucene.cleanLuceneIndex((Directory)store.directory());
                    si = null;
                }
            }
            catch (Exception e) {
                throw new IndexShardRecoveryException(this.shardId, "failed to fetch index version after copying it over", (Throwable)e);
            }
            if (recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
                assert (indexShouldExists);
                this.bootstrap(indexShard, store);
                StoreRecovery.writeEmptyRetentionLeasesFile((BaseIndexShard)indexShard);
            } else if (indexShouldExists) {
                if (recoveryState.getRecoverySource().shouldBootstrapNewHistoryUUID()) {
                    store.bootstrapNewHistory();
                    StoreRecovery.writeEmptyRetentionLeasesFile((BaseIndexShard)indexShard);
                }
                ReplicationLuceneIndex index = recoveryState.getIndex();
                try {
                    if (si != null) {
                        this.addRecoveredFileDetails(si, store, index);
                    }
                }
                catch (IOException e) {
                    this.logger.debug("failed to list file details", (Throwable)e);
                }
                index.setFileDetailsComplete();
            } else {
                store.createEmpty(indexShard.indexSettings().getIndexVersionCreated().luceneVersion);
                String translogUUID = Translog.createEmptyTranslog((Path)indexShard.shardPath().resolveTranslog(), (long)-1L, (ShardId)this.shardId, (long)indexShard.getPendingPrimaryTerm());
                store.associateIndexWithNewTranslog(translogUUID);
                StoreRecovery.writeEmptyRetentionLeasesFile((BaseIndexShard)indexShard);
                indexShard.recoveryState().getIndex().setFileDetailsComplete();
            }
            indexShard.openEngineAndRecoverFromTranslog();
            if (indexShard.shouldSeedRemoteStore()) {
                indexShard.getThreadPool().executor("generic").execute(() -> {
                    this.logger.info("Attempting to seed Remote Store via local recovery for {}", (Object)indexShard.shardId());
                    indexShard.refresh("remote store migration");
                });
                indexShard.waitForRemoteStoreSync();
                this.logger.info("Remote Store is now seeded via local recovery for {}", (Object)indexShard.shardId());
            }
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            indexShard.postRecovery("post recovery from shard_store");
        }
        catch (EngineException | IOException e) {
            throw new IndexShardRecoveryException(this.shardId, "failed to recover from gateway", e);
        }
        finally {
            store.decRef();
        }
    }
}

