/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.RemoteTranslogTransferTracker;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogConfig;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogFactory;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryMissingException;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.opensearch.index.translog.RemoteFsTranslog;

public class RemoteBlobStoreInternalTranslogFactory
implements TranslogFactory {
    private final Repository repository;
    private final ThreadPool threadPool;
    private final RemoteTranslogTransferTracker remoteTranslogTransferTracker;
    private final RemoteStoreSettings remoteStoreSettings;

    public RemoteBlobStoreInternalTranslogFactory(Supplier<RepositoriesService> repositoriesServiceSupplier, ThreadPool threadPool, String repositoryName, RemoteTranslogTransferTracker remoteTranslogTransferTracker, RemoteStoreSettings remoteStoreSettings) {
        Repository repository;
        try {
            repository = repositoriesServiceSupplier.get().repository(repositoryName);
        }
        catch (RepositoryMissingException ex) {
            throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", ex);
        }
        this.repository = repository;
        this.threadPool = threadPool;
        this.remoteTranslogTransferTracker = remoteTranslogTransferTracker;
        this.remoteStoreSettings = remoteStoreSettings;
    }

    public Translog newTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BooleanSupplier startedPrimarySupplier) throws IOException {
        assert (this.repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repository;
        return new RemoteFsTranslog(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer, blobStoreRepository, this.threadPool, startedPrimarySupplier, this.remoteTranslogTransferTracker, this.remoteStoreSettings);
    }

    public Repository getRepository() {
        return this.repository;
    }
}

