/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import io.skylite.common.SetOnce;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.concurrent.ReleasableLock;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.logging.Loggers;
import io.skylite.core.index.remote.RemoteStoreEnums;
import io.skylite.core.index.remote.RemoteStorePathStrategy;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.RemoteTranslogTransferTracker;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.BaseTranslogReader;
import io.skylite.core.index.translog.Checkpoint;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogConfig;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogReader;
import io.skylite.core.index.translog.TranslogStatelessHelper;
import io.skylite.core.index.translog.TranslogWriter;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.util.FileSystemUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.index.translog.transfer.FileTransferTracker;
import org.opensearch.index.translog.transfer.TransferSnapshot;
import org.opensearch.index.translog.transfer.TranslogCheckpointTransferSnapshot;
import org.opensearch.index.translog.transfer.TranslogTransferManager;
import org.opensearch.index.translog.transfer.TranslogTransferMetadata;
import org.opensearch.index.translog.transfer.listener.TranslogTransferListener;

public class RemoteFsTranslog
extends Translog {
    private final Logger logger;
    private final TranslogTransferManager translogTransferManager;
    private final FileTransferTracker fileTransferTracker;
    private final BooleanSupplier startedPrimarySupplier;
    private final RemoteTranslogTransferTracker remoteTranslogTransferTracker;
    private volatile long maxRemoteTranslogGenerationUploaded;
    private volatile long minSeqNoToKeep;
    private volatile long minRemoteGenReferenced;
    private final SetOnce<Boolean> olderPrimaryCleaned = new SetOnce();
    private static final int REMOTE_DELETION_PERMITS = 2;
    private static final int DOWNLOAD_RETRIES = 2;
    private final Semaphore remoteGenerationDeletionPermits = new Semaphore(2);
    private static final int SYNC_PERMIT = 1;
    private final Semaphore syncPermit = new Semaphore(1);
    private final AtomicBoolean pauseSync = new AtomicBoolean(false);
    private final boolean isTranslogMetadataEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFsTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BlobStoreRepository blobStoreRepository, ThreadPool threadPool, BooleanSupplier startedPrimarySupplier, RemoteTranslogTransferTracker remoteTranslogTransferTracker, RemoteStoreSettings remoteStoreSettings) throws IOException {
        super(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer);
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)this.shardId, (String[])new String[0]);
        this.startedPrimarySupplier = startedPrimarySupplier;
        this.remoteTranslogTransferTracker = remoteTranslogTransferTracker;
        this.fileTransferTracker = new FileTransferTracker(this.shardId, remoteTranslogTransferTracker);
        this.isTranslogMetadataEnabled = this.indexSettings().isTranslogMetadataEnabled();
        this.translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, this.shardId, this.fileTransferTracker, remoteTranslogTransferTracker, this.indexSettings().getRemoteStorePathStrategy(), remoteStoreSettings, this.isTranslogMetadataEnabled);
        try {
            RemoteFsTranslog.download(this.translogTransferManager, this.location, this.logger, config.shouldSeedRemote());
            Checkpoint checkpoint = TranslogStatelessHelper.readCheckpoint((Path)this.location);
            this.logger.info("Downloaded data from remote translog till maxSeqNo = {}", (Object)checkpoint.getRawMaxSeqNo());
            this.readers.addAll(this.recoverFromFiles(checkpoint));
            if (this.readers.isEmpty()) {
                String errorMsg = String.format(Locale.ROOT, "%s at least one reader must be recovered", this.shardId);
                this.logger.error(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            boolean success = false;
            this.current = null;
            try {
                this.current = this.createWriter(checkpoint.getGeneration() + 1L, this.getMinFileGeneration(), checkpoint.getGlobalCheckpoint(), persistedSequenceNumberConsumer);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Iterable)this.readers);
                }
            }
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException((Closeable)this.current);
            IOUtils.closeWhileHandlingException((Iterable)this.readers);
            throw e;
        }
    }

    public RemoteTranslogTransferTracker getRemoteTranslogTracker() {
        return this.remoteTranslogTransferTracker;
    }

    public static void download(Repository repository, ShardId shardId, ThreadPool threadPool, Path location, RemoteStorePathStrategy pathStrategy, RemoteStoreSettings remoteStoreSettings, Logger logger, boolean seedRemote, boolean isTranslogMetadataEnabled) throws IOException {
        assert (repository instanceof BlobStoreRepository) : String.format(Locale.ROOT, "%s repository should be instance of BlobStoreRepository", shardId);
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, remoteTranslogTransferTracker);
        TranslogTransferManager translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, shardId, fileTransferTracker, remoteTranslogTransferTracker, pathStrategy, remoteStoreSettings, isTranslogMetadataEnabled);
        RemoteFsTranslog.download(translogTransferManager, location, logger, seedRemote);
        logger.trace(remoteTranslogTransferTracker.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(TranslogTransferManager translogTransferManager, Path location, Logger logger, boolean seedRemote) throws IOException {
        IOException ex = null;
        for (int i = 0; i <= 2; ++i) {
            boolean success = false;
            long startTimeMs = System.currentTimeMillis();
            try {
                RemoteFsTranslog.downloadOnce(translogTransferManager, location, logger, seedRemote);
                success = true;
                return;
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                ex = e;
                continue;
            }
            finally {
                logger.trace("downloadOnce success={} timeElapsed={}", (Object)success, (Object)(System.currentTimeMillis() - startTimeMs));
            }
        }
        logger.info("Exhausted all download retries during translog/checkpoint file download");
        throw ex;
    }

    private static void downloadOnce(TranslogTransferManager translogTransferManager, Path location, Logger logger, boolean seedRemote) throws IOException {
        logger.debug("Downloading translog files from remote");
        RemoteTranslogTransferTracker statsTracker = translogTransferManager.getRemoteTranslogTransferTracker();
        long prevDownloadBytesSucceeded = statsTracker.getDownloadBytesSucceeded();
        long prevDownloadTimeInMillis = statsTracker.getTotalDownloadTimeInMillis();
        TranslogTransferMetadata translogMetadata = translogTransferManager.readMetadata();
        if (translogMetadata != null) {
            if (Files.notExists(location, new LinkOption[0])) {
                Files.createDirectories(location, new FileAttribute[0]);
            }
            for (Path file : FileSystemUtils.files((Path)location)) {
                Files.delete(file);
            }
            Map<String, String> generationToPrimaryTermMapper = translogMetadata.getGenerationToPrimaryTermMapper();
            for (long i = translogMetadata.getGeneration(); i >= translogMetadata.getMinTranslogGeneration(); --i) {
                String generation = Long.toString(i);
                translogTransferManager.downloadTranslog(generationToPrimaryTermMapper.get(generation), generation, location);
            }
            logger.info("Downloaded translog and checkpoint files from={} to={}", (Object)translogMetadata.getMinTranslogGeneration(), (Object)translogMetadata.getGeneration());
            statsTracker.recordDownloadStats(prevDownloadBytesSucceeded, prevDownloadTimeInMillis);
            Files.copy(location.resolve(Translog.getCommitCheckpointFileName((long)translogMetadata.getGeneration())), location.resolve("translog.ckp"), new CopyOption[0]);
        } else {
            logger.debug("No translog files found on remote, checking local filesystem for cleanup");
            if (FileSystemUtils.exists((Path[])new Path[]{location.resolve("translog.ckp")})) {
                Checkpoint checkpoint = TranslogStatelessHelper.readCheckpoint((Path)location);
                if (seedRemote) {
                    logger.debug("Remote migration ongoing. Retaining the translog on local, skipping clean-up");
                } else if (!RemoteFsTranslog.isEmptyTranslog(checkpoint)) {
                    logger.debug("Translog files exist on local without any metadata in remote, cleaning up these files");
                    Translog.createEmptyTranslog((Path)location, (ShardId)translogTransferManager.getShardId(), (Checkpoint)checkpoint);
                } else {
                    logger.debug("Empty translog on local, skipping clean-up");
                }
            }
        }
        logger.debug("downloadOnce execution completed");
    }

    private static boolean isEmptyTranslog(Checkpoint checkpoint) {
        return checkpoint.getGeneration() == checkpoint.getMinTranslogGeneration() && checkpoint.getRawMinSeqNo() == -1L && checkpoint.getRawMaxSeqNo() == -1L && checkpoint.getRawNumOps() == 0;
    }

    public static TranslogTransferManager buildTranslogTransferManager(BlobStoreRepository blobStoreRepository, ThreadPool threadPool, ShardId shardId, FileTransferTracker fileTransferTracker, RemoteTranslogTransferTracker tracker, RemoteStorePathStrategy pathStrategy, RemoteStoreSettings remoteStoreSettings, boolean isTranslogMetadataEnabled) {
        assert (Objects.nonNull(pathStrategy));
        String indexUUID = shardId.getIndex().getUUID();
        String shardIdStr = String.valueOf(shardId.id());
        RemoteStorePathStrategy.PathInput dataPathInput = RemoteStorePathStrategy.PathInput.builder().basePath(blobStoreRepository.basePath()).indexUUID(indexUUID).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.TRANSLOG).dataType(RemoteStoreEnums.DataType.DATA).build();
        BlobPath dataPath = pathStrategy.generatePath(dataPathInput);
        RemoteStorePathStrategy.PathInput mdPathInput = RemoteStorePathStrategy.PathInput.builder().basePath(blobStoreRepository.basePath()).indexUUID(indexUUID).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.TRANSLOG).dataType(RemoteStoreEnums.DataType.METADATA).build();
        BlobPath mdPath = pathStrategy.generatePath(mdPathInput);
        BlobStoreTransferService transferService = new BlobStoreTransferService(blobStoreRepository.blobStore(), threadPool);
        return new TranslogTransferManager(shardId, transferService, dataPath, mdPath, fileTransferTracker, tracker, remoteStoreSettings, isTranslogMetadataEnabled);
    }

    public boolean ensureSynced(TranslogLocation location) throws IOException {
        assert (location.generation <= this.current.getGeneration());
        if (location.generation == this.current.getGeneration()) {
            this.ensureOpen();
            return this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), location.generation);
        }
        return false;
    }

    public void rollGeneration() throws IOException {
        this.syncBeforeRollGeneration();
        if (this.current.totalOperations() == 0 && this.primaryTermSupplier.getAsLong() == this.current.getPrimaryTerm()) {
            return;
        }
        this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
    }

    private boolean prepareAndUpload(Long primaryTerm, Long generation) throws IOException {
        ReleasableLock ignored;
        long maxSeqNo;
        block31: {
            if (!this.startedPrimarySupplier.getAsBoolean() || !this.syncPermit.tryAcquire(1)) {
                this.logger.debug("skipped uploading translog for {} {} syncPermits={}", (Object)primaryTerm, (Object)generation, (Object)this.syncPermit.availablePermits());
                return false;
            }
            maxSeqNo = -1L;
            ignored = this.writeLock.acquire();
            try {
                if (generation == null || generation.longValue() == this.current.getGeneration()) {
                    try {
                        if (!this.closed.get()) {
                            maxSeqNo = this.getMaxSeqNo();
                        }
                        TranslogReader reader = this.current.closeIntoReader();
                        this.readers.add(reader);
                        this.copyCheckpointTo(this.location.resolve(RemoteFsTranslog.getCommitCheckpointFileName((long)this.current.getGeneration())));
                        if (!this.closed.get()) {
                            this.logger.trace("Creating new writer for gen: [{}]", (Object)(this.current.getGeneration() + 1L));
                            this.current = this.createWriter(this.current.getGeneration() + 1L);
                        }
                        assert (this.writeLock.isHeldByCurrentThread()) : "Write lock must be held before we acquire the read lock";
                        this.readLock.acquire();
                        break block31;
                    }
                    catch (Exception e) {
                        this.tragedy.setTragicException(e);
                        this.closeOnTragicEvent(e);
                        throw e;
                    }
                }
                if (generation < this.current.getGeneration()) {
                    boolean e = false;
                    return e;
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        assert (this.readLock.isHeldByCurrentThread());
        ignored = this.readLock;
        try {
            boolean bl;
            block36: {
                Releasable ignoredGenLock;
                block32: {
                    boolean bl2;
                    block35: {
                        block33: {
                            boolean bl3;
                            block34: {
                                ignoredGenLock = this.deletionPolicy.acquireTranslogGen(this.getMinFileGeneration());
                                try {
                                    if (generation != null) break block32;
                                    if (this.closed.get()) break block33;
                                    bl3 = this.upload(primaryTerm, this.current.getGeneration() - 1L, maxSeqNo);
                                    if (ignoredGenLock == null) break block34;
                                }
                                catch (Throwable throwable) {
                                    if (ignoredGenLock != null) {
                                        try {
                                            ignoredGenLock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                ignoredGenLock.close();
                            }
                            return bl3;
                        }
                        bl2 = this.upload(primaryTerm, this.current.getGeneration(), maxSeqNo);
                        if (ignoredGenLock == null) break block35;
                        ignoredGenLock.close();
                    }
                    return bl2;
                }
                bl = this.upload(primaryTerm, generation, maxSeqNo);
                if (ignoredGenLock == null) break block36;
                ignoredGenLock.close();
            }
            return bl;
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    private boolean upload(Long primaryTerm, Long generation, long maxSeqNo) throws IOException {
        this.logger.trace("uploading translog for primary term {} generation {}", (Object)primaryTerm, (Object)generation);
        try {
            boolean bl;
            block9: {
                TranslogCheckpointTransferSnapshot transferSnapshotProvider = new TranslogCheckpointTransferSnapshot.Builder(primaryTerm, generation, this.location, this.readers, Translog::getCommitCheckpointFileName, this.config.getNodeId()).build();
                try {
                    bl = this.translogTransferManager.transferSnapshot(transferSnapshotProvider, new RemoteFsTranslogTransferListener(generation, primaryTerm, maxSeqNo));
                    if (transferSnapshotProvider == null) break block9;
                }
                catch (Throwable throwable) {
                    if (transferSnapshotProvider != null) {
                        try {
                            transferSnapshotProvider.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transferSnapshotProvider.close();
            }
            return bl;
        }
        finally {
            this.syncPermit.release(1);
        }
    }

    public Set<String> allUploaded() {
        return this.fileTransferTracker.allUploaded();
    }

    private boolean syncToDisk() throws IOException {
        boolean bl;
        block8: {
            ReleasableLock lock = this.readLock.acquire();
            try {
                bl = this.current.sync();
                if (lock == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    this.closeOnTragicEvent(ex);
                    throw ex;
                }
            }
            lock.close();
        }
        return bl;
    }

    public void sync() throws IOException {
        if (this.syncToDisk() || this.syncNeeded()) {
            this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
        }
    }

    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded() || this.maxRemoteTranslogGenerationUploaded + 1L < this.currentFileGeneration() && this.current.totalOperations() == 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        assert (Translog.calledFromOutsideOrViaTragedyClose()) : String.valueOf(this.shardId) + "Translog.close method is called from inside Translog, but not via closeOnTragicEvent method";
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.sync();
            }
            finally {
                this.logger.debug("translog closed");
                this.closeFilesIfNoPendingRetentionLocks();
            }
        }
    }

    protected long getMinReferencedGen() throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        long minReferencedGen = Math.min(this.deletionPolicy.minTranslogGenRequired(this.readers, this.current), RemoteFsTranslog.minGenerationForSeqNo((long)this.minSeqNoToKeep, (TranslogWriter)this.current, (List)this.readers));
        assert (minReferencedGen >= this.getMinFileGeneration()) : String.valueOf(this.shardId) + " deletion policy requires a minReferenceGen of [" + minReferencedGen + "] but the lowest gen available is [" + this.getMinFileGeneration() + "]";
        assert (minReferencedGen <= this.currentFileGeneration()) : String.valueOf(this.shardId) + " deletion policy requires a minReferenceGen of [" + minReferencedGen + "] which is higher than the current generation [" + this.currentFileGeneration() + "]";
        return minReferencedGen;
    }

    public void setMinSeqNoToKeep(long seqNo) {
        if (seqNo < this.minSeqNoToKeep) {
            throw new IllegalArgumentException(String.valueOf(this.shardId) + " min seq number required can't go backwards: current [" + this.minSeqNoToKeep + "] new [" + seqNo + "]");
        }
        this.minSeqNoToKeep = seqNo;
    }

    public Releasable drainSyncTestCall() {
        return this.drainSync();
    }

    protected Releasable drainSync() {
        try {
            if (this.syncPermit.tryAcquire(1, 1L, TimeUnit.MINUTES)) {
                boolean result = this.pauseSync.compareAndSet(false, true);
                assert (result && this.syncPermit.availablePermits() == 0);
                this.logger.info("All inflight remote translog syncs finished and further syncs paused");
                return Releasables.releaseOnce(() -> {
                    this.syncPermit.release(1);
                    boolean wasSyncPaused = this.pauseSync.getAndSet(false);
                    assert (this.syncPermit.availablePermits() == 1) : "Available permits is " + this.syncPermit.availablePermits();
                    assert (wasSyncPaused) : "RemoteFsTranslog sync was not paused before re-enabling it";
                    this.logger.info("Resumed remote translog sync back on relocation failure");
                });
            }
            throw new TimeoutException("Timeout while acquiring all permits");
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to acquire all permits", e);
        }
    }

    public void trimUnreferencedReaders() throws IOException {
        super.trimUnreferencedReaders();
        if (!this.startedPrimarySupplier.getAsBoolean() || this.pauseSync.get()) {
            return;
        }
        if (!this.remoteGenerationDeletionPermits.tryAcquire(2)) {
            return;
        }
        HashSet<Long> generationsToDelete = new HashSet<Long>();
        for (long generation = this.minRemoteGenReferenced - 1L - (long)this.indexSettings().getRemoteTranslogExtraKeep(); generation >= 0L && this.fileTransferTracker.uploaded(TranslogStatelessHelper.getFilename((long)generation)); --generation) {
            generationsToDelete.add(generation);
        }
        if (!generationsToDelete.isEmpty()) {
            this.deleteRemoteGeneration(generationsToDelete);
            this.translogTransferManager.deleteStaleTranslogMetadataFilesAsync(this.remoteGenerationDeletionPermits::release);
            this.deleteStaleRemotePrimaryTerms();
        } else {
            this.remoteGenerationDeletionPermits.release(2);
        }
    }

    private void deleteRemoteGeneration(Set<Long> generations) {
        this.translogTransferManager.deleteGenerationAsync(this.primaryTermSupplier.getAsLong(), generations, this.remoteGenerationDeletionPermits::release);
    }

    private void deleteStaleRemotePrimaryTerms() {
        if (this.olderPrimaryCleaned.trySet((Object)Boolean.TRUE)) {
            if (this.readers.isEmpty()) {
                this.logger.trace("Translog reader list is empty, returning from deleteStaleRemotePrimaryTerms");
                return;
            }
            long minimumReferencedPrimaryTerm = this.readers.stream().map(BaseTranslogReader::getPrimaryTerm).min(Long::compare).get();
            this.translogTransferManager.deletePrimaryTermsAsync(minimumReferencedPrimaryTerm);
        }
    }

    public static void cleanup(Repository repository, ShardId shardId, ThreadPool threadPool, RemoteStorePathStrategy pathStrategy, RemoteStoreSettings remoteStoreSettings, boolean isTranslogMetadataEnabled) throws IOException {
        assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, remoteTranslogTransferTracker);
        TranslogTransferManager translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, shardId, fileTransferTracker, remoteTranslogTransferTracker, pathStrategy, remoteStoreSettings, isTranslogMetadataEnabled);
        translogTransferManager.deleteTranslogFiles();
    }

    protected void onDelete() {
        ClusterService.assertClusterOrClusterManagerStateThread();
        this.translogTransferManager.delete();
    }

    public boolean isRemoteGenerationDeletionPermitsAvailable() {
        return this.remoteGenerationDeletionPermits.availablePermits() == 2;
    }

    public long getMinUnreferencedSeqNoInSegments(long minUnrefCheckpointInLastCommit) {
        return this.minSeqNoToKeep;
    }

    public int availablePermits() {
        return this.syncPermit.availablePermits();
    }

    protected boolean shouldFlush() {
        return this.readers.size() >= this.translogTransferManager.getMaxRemoteTranslogReadersSettings();
    }

    private class RemoteFsTranslogTransferListener
    implements TranslogTransferListener {
        private final long generation;
        private final long primaryTerm;
        private final long maxSeqNo;

        RemoteFsTranslogTransferListener(long generation, long primaryTerm, long maxSeqNo) {
            this.generation = generation;
            this.primaryTerm = primaryTerm;
            this.maxSeqNo = maxSeqNo;
        }

        @Override
        public void onUploadComplete(TransferSnapshot transferSnapshot) throws IOException {
            RemoteFsTranslog.this.maxRemoteTranslogGenerationUploaded = this.generation;
            RemoteFsTranslog.this.minRemoteGenReferenced = RemoteFsTranslog.this.getMinFileGeneration();
            RemoteFsTranslog.this.logger.debug("Successfully uploaded translog for primary term = {}, generation = {}, maxSeqNo = {}", (Object)this.primaryTerm, (Object)this.generation, (Object)this.maxSeqNo);
        }

        @Override
        public void onUploadFailed(TransferSnapshot transferSnapshot, Exception ex) throws IOException {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
    }
}

