/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import io.skylite.SkyliteException;
import io.skylite.cli.Terminal;
import io.skylite.common.UUIDs;
import io.skylite.common.collect.Tuple;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.translog.Checkpoint;
import io.skylite.core.index.translog.DefaultTranslogDeletionPolicy;
import io.skylite.core.index.translog.LocalTranslog;
import io.skylite.core.index.translog.TranslogConfig;
import io.skylite.core.index.translog.TranslogCorruptedException;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogHeader;
import io.skylite.core.index.translog.TranslogReader;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.index.translog.TranslogStatelessHelper;
import io.skylite.core.index.translog.TranslogWriter;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.opensearch.index.shard.RemoveCorruptedShardDataCommand;

public class TruncateTranslogAction {
    protected static final Logger logger = LogManager.getLogger(TruncateTranslogAction.class);
    private final NamedXContentRegistry namedXContentRegistry;

    public TruncateTranslogAction(NamedXContentRegistry namedXContentRegistry) {
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public Tuple<RemoveCorruptedShardDataCommand.CleanStatus, String> getCleanStatus(ShardPath shardPath, ClusterState clusterState, Directory indexDirectory) throws IOException {
        Set<Path> translogFiles;
        List commits;
        Path indexPath = shardPath.resolveIndex();
        Path translogPath = shardPath.resolveTranslog();
        try {
            commits = DirectoryReader.listCommits((Directory)indexDirectory);
        }
        catch (IndexNotFoundException infe) {
            throw new SkyliteException("unable to find a valid shard at [" + String.valueOf(indexPath) + "]", (Throwable)infe, new Object[0]);
        }
        catch (IOException e) {
            throw new SkyliteException("unable to list commits at [" + String.valueOf(indexPath) + "]", (Throwable)e, new Object[0]);
        }
        HashMap commitData = new HashMap(((IndexCommit)commits.get(commits.size() - 1)).getUserData());
        String translogUUID = (String)commitData.get("translog_uuid");
        if (translogUUID == null) {
            throw new SkyliteException("shard must have a valid translog UUID but got: [null]", new Object[0]);
        }
        boolean clean = this.isTranslogClean(shardPath, clusterState, translogUUID);
        if (clean) {
            return Tuple.tuple((Object)((Object)RemoveCorruptedShardDataCommand.CleanStatus.CLEAN), null);
        }
        try {
            translogFiles = TruncateTranslogAction.filesInDirectory(translogPath);
        }
        catch (IOException e) {
            throw new SkyliteException("failed to find existing translog files", (Throwable)e, new Object[0]);
        }
        String details = this.deletingFilesDetails(translogPath, translogFiles);
        return Tuple.tuple((Object)((Object)RemoveCorruptedShardDataCommand.CleanStatus.CORRUPTED), (Object)details);
    }

    public void execute(Terminal terminal, ShardPath shardPath, Directory indexDirectory) throws IOException {
        List commits;
        Set<Path> translogFiles;
        Path indexPath = shardPath.resolveIndex();
        Path translogPath = shardPath.resolveTranslog();
        String historyUUID = UUIDs.randomBase64UUID();
        try {
            terminal.println("Checking existing translog files");
            translogFiles = TruncateTranslogAction.filesInDirectory(translogPath);
        }
        catch (IOException e) {
            terminal.println("encountered IOException while listing directory, aborting...");
            throw new SkyliteException("failed to find existing translog files", (Throwable)e, new Object[0]);
        }
        try {
            terminal.println("Reading translog UUID information from Lucene commit from shard at [" + String.valueOf(indexPath) + "]");
            commits = DirectoryReader.listCommits((Directory)indexDirectory);
        }
        catch (IndexNotFoundException infe) {
            throw new SkyliteException("unable to find a valid shard at [" + String.valueOf(indexPath) + "]", (Throwable)infe, new Object[0]);
        }
        Map commitData = ((IndexCommit)commits.get(commits.size() - 1)).getUserData();
        String translogUUID = (String)commitData.get("translog_uuid");
        if (translogUUID == null) {
            throw new SkyliteException("shard must have a valid translog UUID", new Object[0]);
        }
        long globalCheckpoint = commitData.containsKey("max_seq_no") ? Long.parseLong((String)commitData.get("max_seq_no")) : -2L;
        terminal.println("Translog UUID      : " + translogUUID);
        terminal.println("History UUID       : " + historyUUID);
        Path tempEmptyCheckpoint = translogPath.resolve("temp-translog.ckp");
        Path realEmptyCheckpoint = translogPath.resolve("translog.ckp");
        long gen = 1L;
        Path tempEmptyTranslog = translogPath.resolve("temp-translog-1.tlog");
        Path realEmptyTranslog = translogPath.resolve("translog-1.tlog");
        int translogLen = TruncateTranslogAction.writeEmptyTranslog(tempEmptyTranslog, translogUUID);
        TruncateTranslogAction.writeEmptyCheckpoint(tempEmptyCheckpoint, translogLen, 1L, globalCheckpoint);
        terminal.println("Removing existing translog files");
        IOUtils.rm((Path[])translogFiles.toArray(new Path[0]));
        terminal.println("Creating new empty checkpoint at [" + String.valueOf(realEmptyCheckpoint) + "]");
        Files.move(tempEmptyCheckpoint, realEmptyCheckpoint, StandardCopyOption.ATOMIC_MOVE);
        terminal.println("Creating new empty translog at [" + String.valueOf(realEmptyTranslog) + "]");
        Files.move(tempEmptyTranslog, realEmptyTranslog, StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync((Path)translogPath, (boolean)true);
    }

    private boolean isTranslogClean(ShardPath shardPath, ClusterState clusterState, String translogUUID) throws IOException {
        try {
            Path translogPath = shardPath.resolveTranslog();
            long translogGlobalCheckpoint = TranslogStatelessHelper.readGlobalCheckpoint((Path)translogPath, (String)translogUUID);
            IndexMetadata indexMetadata = clusterState.metadata().getIndexSafe(shardPath.getShardId().getIndex());
            IndexSettings indexSettings = new IndexSettings(indexMetadata, Settings.EMPTY);
            TranslogConfig translogConfig = new TranslogConfig(shardPath.getShardId(), translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE, "", false);
            long primaryTerm = indexSettings.getIndexMetadata().primaryTerm(shardPath.getShardId().id());
            DefaultTranslogDeletionPolicy retainAllTranslogPolicy = new DefaultTranslogDeletionPolicy(this, Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE){

                public long minTranslogGenRequired(List<TranslogReader> readers, TranslogWriter writer) {
                    long minGen = writer.getGeneration();
                    for (TranslogReader reader : readers) {
                        minGen = Math.min(reader.getGeneration(), minGen);
                    }
                    return minGen;
                }
            };
            try (LocalTranslog translog = new LocalTranslog(translogConfig, translogUUID, (TranslogDeletionPolicy)retainAllTranslogPolicy, () -> translogGlobalCheckpoint, () -> primaryTerm, seqNo -> {});
                 TranslogSnapshotIterator snapshot = translog.newSnapshot(0L, Long.MAX_VALUE);){
                while (snapshot.next() != null) {
                }
            }
            return true;
        }
        catch (TranslogCorruptedException e) {
            return false;
        }
    }

    private static void writeEmptyCheckpoint(Path filename, int translogLength, long translogGeneration, long globalCheckpoint) throws IOException {
        Checkpoint emptyCheckpoint = TranslogStatelessHelper.emptyCheckpoint((long)translogLength, (long)translogGeneration, (long)globalCheckpoint, (long)translogGeneration);
        Checkpoint.write(FileChannel::open, (Path)filename, (Checkpoint)emptyCheckpoint, (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE_NEW});
    }

    private static int writeEmptyTranslog(Path filename, String translogUUID) throws IOException {
        try (FileChannel fc = FileChannel.open(filename, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            TranslogHeader header = new TranslogHeader(translogUUID, 0L);
            header.write(fc, true);
            int n = header.sizeInBytes();
            return n;
        }
    }

    private String deletingFilesDetails(Path translogPath, Set<Path> files) {
        StringBuilder builder = new StringBuilder();
        builder.append("Documents inside of translog files will be lost.\n").append("  The following files will be DELETED at ").append(translogPath).append("\n\n");
        Iterator<Path> it = files.iterator();
        while (it.hasNext()) {
            builder.append("  --> ").append(it.next().getFileName());
            if (!it.hasNext()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private static Set<Path> filesInDirectory(Path directory) throws IOException {
        TreeSet<Path> files = new TreeSet<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path file : stream) {
                files.add(file);
            }
        }
        return files;
    }
}

