/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.blobstore.InputStreamWithMetadata;
import io.skylite.common.io.FileChannelFactory;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.blobstore.AsyncMultiStreamBlobContainer;
import io.skylite.core.blobstore.BlobStore;
import io.skylite.core.blobstore.stream.write.WriteContext;
import io.skylite.core.blobstore.stream.write.WritePriority;
import io.skylite.core.blobstore.transfer.RemoteTransferContainer;
import io.skylite.core.blobstore.transfer.stream.OffsetRangeFileInputStream;
import io.skylite.core.threadpool.ThreadPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.index.translog.transfer.FileSnapshot;
import org.opensearch.index.translog.transfer.FileTransferException;
import org.opensearch.index.translog.transfer.TransferService;

public class BlobStoreTransferService
implements TransferService {
    private final BlobStore blobStore;
    private final ThreadPool threadPool;
    private static final Logger logger = LogManager.getLogger(BlobStoreTransferService.class);

    public BlobStoreTransferService(BlobStore blobStore, ThreadPool threadPool) {
        this.blobStore = blobStore;
        this.threadPool = threadPool;
    }

    @Override
    public void uploadBlob(String threadPoolName, FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath, ActionListener<FileSnapshot.TransferFileSnapshot> listener, WritePriority writePriority) {
        assert (remoteTransferPath instanceof BlobPath);
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        this.threadPool.executor(threadPoolName).execute((Runnable)ActionRunnable.wrap(listener, l -> {
            try {
                this.uploadBlob(fileSnapshot, (Iterable<String>)blobPath, writePriority);
                l.onResponse((Object)fileSnapshot);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)e);
                l.onFailure((Exception)new FileTransferException(fileSnapshot, (Throwable)e));
            }
        }));
    }

    @Override
    public void uploadBlob(FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath, WritePriority writePriority) throws IOException {
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        try (InputStream inputStream = fileSnapshot.inputStream();){
            this.blobStore.blobContainer(blobPath).writeBlobAtomic(fileSnapshot.getName(), inputStream, fileSnapshot.getContentLength(), true);
        }
    }

    @Override
    public void uploadBlobs(Set<FileSnapshot.TransferFileSnapshot> fileSnapshots, Map<Long, BlobPath> blobPaths, ActionListener<FileSnapshot.TransferFileSnapshot> listener, WritePriority writePriority) {
        fileSnapshots.forEach(fileSnapshot -> {
            BlobPath blobPath = (BlobPath)blobPaths.get(fileSnapshot.getPrimaryTerm());
            if (!(this.blobStore.blobContainer(blobPath) instanceof AsyncMultiStreamBlobContainer)) {
                this.uploadBlob("translog_transfer", (FileSnapshot.TransferFileSnapshot)fileSnapshot, (Iterable<String>)blobPath, listener, writePriority);
            } else {
                this.uploadBlob((FileSnapshot.TransferFileSnapshot)fileSnapshot, listener, blobPath, writePriority);
            }
        });
    }

    static Map<String, String> buildTransferFileMetadata(InputStream metadataInputStream) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[128];
            int totalBytesRead = 0;
            while ((bytesRead = metadataInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
                if ((totalBytesRead += bytesRead) <= 1024) continue;
                throw new IOException("Input stream exceeds 1KB limit");
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String metadataString = Base64.getEncoder().encodeToString(bytes);
            metadata.put("ckp-data", metadataString);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadBlob(FileSnapshot.TransferFileSnapshot fileSnapshot, ActionListener<FileSnapshot.TransferFileSnapshot> listener, BlobPath blobPath, WritePriority writePriority) {
        try {
            long contentLength;
            FileChannelFactory fileChannelFactory = FileChannel::open;
            Map<String, String> metadata = null;
            if (fileSnapshot.getMetadataFileInputStream() != null) {
                metadata = BlobStoreTransferService.buildTransferFileMetadata(fileSnapshot.getMetadataFileInputStream());
            }
            try (FileChannel channel = fileChannelFactory.open(fileSnapshot.getPath(), new OpenOption[]{StandardOpenOption.READ});){
                contentLength = channel.size();
            }
            boolean remoteIntegrityEnabled = false;
            BlobContainer blobContainer = this.blobStore.blobContainer(blobPath);
            if (blobContainer instanceof AsyncMultiStreamBlobContainer) {
                remoteIntegrityEnabled = ((AsyncMultiStreamBlobContainer)blobContainer).remoteIntegrityCheckSupported();
            }
            RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(fileSnapshot.getName(), fileSnapshot.getName(), contentLength, true, writePriority, (size, position) -> new OffsetRangeFileInputStream(fileSnapshot.getPath(), size, position), Objects.requireNonNull(fileSnapshot.getChecksum()), remoteIntegrityEnabled, metadata);
            ActionListener completionListener = ActionListenerHelper.wrap(resp -> listener.onResponse((Object)fileSnapshot), ex -> {
                logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)ex);
                listener.onFailure((Exception)new FileTransferException(fileSnapshot, (Throwable)ex));
            });
            completionListener = ActionListenerHelper.runBefore((ActionListener)completionListener, () -> {
                try {
                    remoteTransferContainer.close();
                }
                catch (Exception e) {
                    logger.warn("Error occurred while closing streams", (Throwable)e);
                }
            });
            WriteContext writeContext = remoteTransferContainer.createWriteContext();
            ((AsyncMultiStreamBlobContainer)this.blobStore.blobContainer(blobPath)).asyncBlobUpload(writeContext, completionListener);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)e);
            listener.onFailure((Exception)new FileTransferException(fileSnapshot, (Throwable)e));
        }
        finally {
            try {
                fileSnapshot.close();
            }
            catch (IOException e) {
                logger.warn("Error while closing TransferFileSnapshot", (Throwable)e);
            }
        }
    }

    @Override
    public InputStream downloadBlob(Iterable<String> path, String fileName) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).readBlob(fileName);
    }

    @Override
    @ExperimentalApi
    public InputStreamWithMetadata downloadBlobWithMetadata(Iterable<String> path, String fileName) throws IOException {
        assert (this.blobStore.isBlobMetadataEnabled());
        return this.blobStore.blobContainer((BlobPath)path).readBlobWithMetadata(fileName);
    }

    @Override
    public void deleteBlobs(Iterable<String> path, List<String> fileNames) throws IOException {
        this.blobStore.blobContainer((BlobPath)path).deleteBlobsIgnoringIfNotExists(fileNames);
    }

    @Override
    public void deleteBlobsAsync(String threadpoolName, Iterable<String> path, List<String> fileNames, ActionListener<Void> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                this.deleteBlobs(path, fileNames);
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    @Override
    public void delete(Iterable<String> path) throws IOException {
        this.blobStore.blobContainer((BlobPath)path).delete();
    }

    @Override
    public void deleteAsync(String threadpoolName, Iterable<String> path, ActionListener<Void> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                this.delete(path);
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    @Override
    public Set<String> listAll(Iterable<String> path) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).listBlobs().keySet();
    }

    @Override
    public Set<String> listFolders(Iterable<String> path) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).children().keySet();
    }

    @Override
    public void listFoldersAsync(String threadpoolName, Iterable<String> path, ActionListener<Set<String>> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                listener.onResponse(this.listFolders(path));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    @Override
    public void listAllInSortedOrder(Iterable<String> path, String filenamePrefix, int limit, ActionListener<List<BlobMetadata>> listener) {
        this.blobStore.blobContainer((BlobPath)path).listBlobsByPrefixInSortedOrder(filenamePrefix, limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC, listener);
    }

    @Override
    public void listAllInSortedOrderAsync(String threadpoolName, Iterable<String> path, String filenamePrefix, int limit, ActionListener<List<BlobMetadata>> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> this.listAllInSortedOrder(path, filenamePrefix, limit, listener));
    }
}

