/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import io.lucenia.action.resync.TransportResyncReplicationAction;
import io.skylite.core.ParseField;
import io.skylite.core.action.admin.indices.rollover.Condition;
import io.skylite.core.action.admin.indices.rollover.MaxAgeCondition;
import io.skylite.core.action.admin.indices.rollover.MaxDocsCondition;
import io.skylite.core.action.admin.indices.rollover.MaxSizeCondition;
import io.skylite.core.common.inject.AbstractModule;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.time.DateResolution;
import io.skylite.core.index.remote.RemoteStorePressureService;
import io.skylite.core.index.seqno.RetentionLeaseBackgroundSyncAction;
import io.skylite.core.index.seqno.RetentionLeaseSyncAction;
import io.skylite.core.index.seqno.RetentionLeaseSyncer;
import io.skylite.core.index.shard.PrimaryReplicaSyncer;
import io.skylite.core.mapper.BinaryFieldMapper;
import io.skylite.core.mapper.BooleanFieldMapper;
import io.skylite.core.mapper.CompletionFieldMapper;
import io.skylite.core.mapper.DateFieldMapper;
import io.skylite.core.mapper.DynamicRuntimeFieldsBuilder;
import io.skylite.core.mapper.FieldAliasMapper;
import io.skylite.core.mapper.FieldNamesFieldMapper;
import io.skylite.core.mapper.FlatObjectFieldMapper;
import io.skylite.core.mapper.IdFieldMapper;
import io.skylite.core.mapper.IndexFieldMapper;
import io.skylite.core.mapper.KeywordFieldMapper;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperRegistry;
import io.skylite.core.mapper.MetadataFieldMapper;
import io.skylite.core.mapper.NestedObjectMapper;
import io.skylite.core.mapper.NestedPathFieldMapper;
import io.skylite.core.mapper.NumberFieldMapper;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.RangeType;
import io.skylite.core.mapper.RoutingFieldMapper;
import io.skylite.core.mapper.RuntimeFieldType;
import io.skylite.core.mapper.SeqNoFieldMapper;
import io.skylite.core.mapper.SourceFieldMapper;
import io.skylite.core.mapper.TextFieldMapper;
import io.skylite.core.plugins.BaseMapperPlugin;
import io.skylite.core.plugins.MapperPlugin;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.opensearch.index.SegmentReplicationPressureService;
import org.opensearch.index.mapper.DataStreamFieldMapper;
import org.opensearch.index.mapper.DocCountFieldMapper;
import org.opensearch.index.mapper.GeoPointFieldMapper;
import org.opensearch.index.mapper.IgnoredFieldMapper;
import org.opensearch.index.mapper.IpFieldMapper;
import org.opensearch.index.mapper.VersionFieldMapper;
import org.opensearch.index.seqno.GlobalCheckpointSyncAction;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;
import org.opensearch.indices.store.IndicesStore;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadata;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataBatch;

public class IndicesModule
extends AbstractModule {
    private final List<NamedWriteableRegistry.Entry> namedWritables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final MapperRegistry mapperRegistry;
    private static final Map<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = IndicesModule.initBuiltInMetadataMappers();
    private static final Set<String> builtInMetadataFields = Collections.unmodifiableSet(builtInMetadataMappers.keySet());

    public IndicesModule(List<MapperPlugin> mapperPlugins) {
        this.mapperRegistry = new MapperRegistry(IndicesModule.getMappers(mapperPlugins), IndicesModule.getRuntimeFieldTypes(mapperPlugins), IndicesModule.getDynamicRuntimeFieldsBuilder(mapperPlugins), IndicesModule.getMetadataMappers(mapperPlugins), IndicesModule.getFieldFilter(mapperPlugins));
        this.registerBuiltinWritables();
    }

    private void registerBuiltinWritables() {
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_age", MaxAgeCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_docs", MaxDocsCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_size", MaxSizeCondition::new));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWritables;
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContents() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_age", new String[0]), (p, c) -> MaxAgeCondition.fromXContent((XContentParser)p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_docs", new String[0]), (p, c) -> MaxDocsCondition.fromXContent((XContentParser)p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_size", new String[0]), (p, c) -> MaxSizeCondition.fromXContent((XContentParser)p)));
    }

    public static Map<String, Mapper.TypeParser> getMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, Object> mappers = new LinkedHashMap<String, Object>();
        for (NumberFieldMapper.NumberType numberType : NumberFieldMapper.NumberType.values()) {
            mappers.put(numberType.typeName(), numberType.parser());
        }
        for (NumberFieldMapper.NumberType numberType : RangeType.values()) {
            mappers.put(numberType.typeName(), numberType.parser());
        }
        mappers.put(BooleanFieldMapper.CONTENT_TYPE, BooleanFieldMapper.PARSER);
        mappers.put(BinaryFieldMapper.CONTENT_TYPE, BinaryFieldMapper.PARSER);
        DateResolution milliseconds = DateResolution.MILLISECONDS;
        mappers.put(milliseconds.type(), DateFieldMapper.MILLIS_PARSER);
        DateResolution nanoseconds = DateResolution.NANOSECONDS;
        mappers.put(nanoseconds.type(), DateFieldMapper.NANOS_PARSER);
        mappers.put("ip", IpFieldMapper.PARSER);
        mappers.put(TextFieldMapper.CONTENT_TYPE, TextFieldMapper.PARSER);
        mappers.put("keyword", KeywordFieldMapper.PARSER);
        mappers.put(ObjectMapper.CONTENT_TYPE, new ObjectMapper.TypeParser());
        mappers.put("nested", new NestedObjectMapper.TypeParser());
        mappers.put("completion", CompletionFieldMapper.PARSER);
        mappers.put("alias", new FieldAliasMapper.TypeParser());
        mappers.put("geo_point", GeoPointFieldMapper.PARSER);
        mappers.put("flat_object", FlatObjectFieldMapper.PARSER);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry entry : mapperPlugin.getMappers().entrySet()) {
                if (mappers.put((String)entry.getKey(), (Mapper.TypeParser)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Mapper [" + (String)entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(mappers);
    }

    private static Map<String, RuntimeFieldType.Parser> getRuntimeFieldTypes(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, RuntimeFieldType.Parser> runtimeParsers = new LinkedHashMap<String, RuntimeFieldType.Parser>();
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry entry : mapperPlugin.getRuntimeFieldTypes().entrySet()) {
                if (runtimeParsers.put((String)entry.getKey(), (RuntimeFieldType.Parser)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Runtime field type [" + (String)entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(runtimeParsers);
    }

    private static DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder(List<MapperPlugin> mapperPlugins) {
        DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder = null;
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            if (mapperPlugin.getDynamicRuntimeFieldsBuilder() == null) continue;
            if (dynamicRuntimeFieldsBuilder != null) {
                throw new IllegalArgumentException("Dynamic runtime fields builder already registered");
            }
            dynamicRuntimeFieldsBuilder = mapperPlugin.getDynamicRuntimeFieldsBuilder();
        }
        return dynamicRuntimeFieldsBuilder;
    }

    private static Map<String, MetadataFieldMapper.TypeParser> initBuiltInMetadataMappers() {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        builtInMetadataMappers.put(ParseField.CommonMetaFields.IGNORED_FIELD.getPreferredName(), IgnoredFieldMapper.PARSER);
        builtInMetadataMappers.put(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), IdFieldMapper.PARSER);
        builtInMetadataMappers.put(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName(), RoutingFieldMapper.PARSER);
        builtInMetadataMappers.put("_index", IndexFieldMapper.PARSER);
        builtInMetadataMappers.put("_data_stream_timestamp", DataStreamFieldMapper.PARSER);
        builtInMetadataMappers.put(ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName(), SourceFieldMapper.PARSER);
        builtInMetadataMappers.put("_nested_path", NestedPathFieldMapper.PARSER);
        builtInMetadataMappers.put(ParseField.CommonMetaFields.VERSION_FIELD.getPreferredName(), VersionFieldMapper.PARSER);
        builtInMetadataMappers.put(SeqNoFieldMapper.NAME, SeqNoFieldMapper.PARSER);
        builtInMetadataMappers.put("_doc_count", DocCountFieldMapper.PARSER);
        builtInMetadataMappers.put(FieldNamesFieldMapper.NAME, FieldNamesFieldMapper.PARSER);
        return Collections.unmodifiableMap(builtInMetadataMappers);
    }

    public static Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        int i = 0;
        Map.Entry<String, MetadataFieldMapper.TypeParser> fieldNamesEntry = null;
        for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : builtInMetadataMappers.entrySet()) {
            if (i < builtInMetadataMappers.size() - 1) {
                metadataMappers.put(entry.getKey(), entry.getValue());
            } else {
                assert (entry.getKey().equals(FieldNamesFieldMapper.NAME)) : "_field_names must be the last registered mapper, order counts";
                fieldNamesEntry = entry;
            }
            ++i;
        }
        assert (fieldNamesEntry != null);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry entry : mapperPlugin.getMetadataMappers().entrySet()) {
                if (((String)entry.getKey()).equals(FieldNamesFieldMapper.NAME)) {
                    throw new IllegalArgumentException("Plugin cannot contain metadata mapper [" + FieldNamesFieldMapper.NAME + "]");
                }
                if (metadataMappers.put((String)entry.getKey(), (MetadataFieldMapper.TypeParser)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("MetadataFieldMapper [" + (String)entry.getKey() + "] is already registered");
            }
        }
        metadataMappers.put((String)fieldNamesEntry.getKey(), fieldNamesEntry.getValue());
        return Collections.unmodifiableMap(metadataMappers);
    }

    public static Set<String> getBuiltInMetadataFields() {
        return builtInMetadataFields;
    }

    private static Function<String, Predicate<String>> getFieldFilter(List<MapperPlugin> mapperPlugins) {
        Function<String, Predicate<String>> fieldFilter = MapperPlugin.NOOP_FIELD_FILTER;
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            fieldFilter = IndicesModule.and(fieldFilter, mapperPlugin.getFieldFilter());
        }
        return fieldFilter;
    }

    private static Function<String, Predicate<String>> and(Function<String, Predicate<String>> first, Function<String, Predicate<String>> second) {
        if (first == MapperPlugin.NOOP_FIELD_FILTER) {
            return second;
        }
        if (second == MapperPlugin.NOOP_FIELD_FILTER) {
            return first;
        }
        return index -> {
            Predicate firstPredicate = (Predicate)first.apply((String)index);
            Predicate secondPredicate = (Predicate)second.apply((String)index);
            if (firstPredicate == BaseMapperPlugin.NOOP_FIELD_PREDICATE) {
                return secondPredicate;
            }
            if (secondPredicate == BaseMapperPlugin.NOOP_FIELD_PREDICATE) {
                return firstPredicate;
            }
            return firstPredicate.and(secondPredicate);
        };
    }

    protected void configure() {
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetadata.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetadataBatch.class).asEagerSingleton();
        this.bind(GlobalCheckpointSyncAction.class).asEagerSingleton();
        this.bind(PrimaryReplicaSyncer.SyncAction.class).to(TransportResyncReplicationAction.class).asEagerSingleton();
        this.bind(PrimaryReplicaSyncer.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseBackgroundSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncer.class).asEagerSingleton();
        this.bind(SegmentReplicationCheckpointPublisher.class).asEagerSingleton();
        this.bind(SegmentReplicationPressureService.class).asEagerSingleton();
        this.bind(RemoteStorePressureService.class).asEagerSingleton();
    }

    public MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }
}

