/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import io.skylite.common.CheckedSupplier;
import io.skylite.common.cache.Cache;
import io.skylite.common.cache.CacheBuilder;
import io.skylite.common.cache.CacheLoader;
import io.skylite.common.cache.RemovalListener;
import io.skylite.common.cache.RemovalNotification;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public final class IndicesRequestCache
implements RemovalListener<Key, BytesReference>,
Closeable {
    private static final Logger logger = LogManager.getLogger(IndicesRequestCache.class);
    public static final Setting<Boolean> INDEX_CACHE_REQUEST_ENABLED_SETTING = Setting.boolSetting((String)"index.requests.cache.enable", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE = Setting.memorySizeSetting((String)"indices.requests.cache.size", (String)"1%", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> INDICES_CACHE_QUERY_EXPIRE = Setting.positiveTimeSetting((String)"indices.requests.cache.expire", (TimeValue)new TimeValue(0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ConcurrentMap<CleanupKey, Boolean> registeredClosedListeners = ConcurrentCollections.newConcurrentMap();
    private final Set<CleanupKey> keysToClean = ConcurrentCollections.newConcurrentSet();
    private final ByteSizeValue size;
    private final TimeValue expire;
    private final Cache<Key, BytesReference> cache;

    IndicesRequestCache(Settings settings) {
        this.size = (ByteSizeValue)INDICES_CACHE_QUERY_SIZE.get(settings);
        this.expire = INDICES_CACHE_QUERY_EXPIRE.exists(settings) ? (TimeValue)INDICES_CACHE_QUERY_EXPIRE.get(settings) : null;
        long sizeInBytes = this.size.getBytes();
        CacheBuilder cacheBuilder = CacheBuilder.builder().setMaximumWeight(sizeInBytes).weigher((k, v) -> k.ramBytesUsed() + v.ramBytesUsed()).removalListener((RemovalListener)this);
        if (this.expire != null) {
            cacheBuilder.setExpireAfterAccess(this.expire);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }

    void clear(CacheEntity entity) {
        this.keysToClean.add(new CleanupKey(entity, null));
        this.cleanCache();
    }

    public void onRemoval(RemovalNotification<Key, BytesReference> notification) {
        ((Key)notification.getKey()).entity.onRemoval(notification);
    }

    BytesReference getOrCompute(CacheEntity cacheEntity, CheckedSupplier<BytesReference, IOException> loader, MappingLookup.CacheKey mappingCacheKey, DirectoryReader reader, BytesReference cacheKey) throws Exception {
        assert (reader.getReaderCacheHelper() != null);
        Key key = new Key(cacheEntity, mappingCacheKey, reader.getReaderCacheHelper().getKey(), cacheKey);
        Loader cacheLoader = new Loader(cacheEntity, loader);
        BytesReference value = (BytesReference)this.cache.computeIfAbsent((Object)key, (CacheLoader)cacheLoader);
        if (cacheLoader.isLoaded()) {
            Boolean previous;
            key.entity.onMiss();
            CleanupKey cleanupKey = new CleanupKey(cacheEntity, reader.getReaderCacheHelper().getKey());
            if (!this.registeredClosedListeners.containsKey(cleanupKey) && (previous = this.registeredClosedListeners.putIfAbsent(cleanupKey, Boolean.TRUE)) == null) {
                SkyliteDirectoryReader.addReaderCloseListener((DirectoryReader)reader, (IndexReader.ClosedListener)cleanupKey);
            }
        } else {
            key.entity.onHit();
        }
        return value;
    }

    void invalidate(CacheEntity cacheEntity, MappingLookup.CacheKey mappingCacheKey, DirectoryReader reader, BytesReference cacheKey) {
        assert (reader.getReaderCacheHelper() != null);
        this.cache.invalidate((Object)new Key(cacheEntity, mappingCacheKey, reader.getReaderCacheHelper().getKey(), cacheKey));
    }

    synchronized void cleanCache() {
        HashSet<CleanupKey> currentKeysToClean = new HashSet<CleanupKey>();
        HashSet<Object> currentFullClean = new HashSet<Object>();
        currentKeysToClean.clear();
        currentFullClean.clear();
        Iterator<CleanupKey> iterator = this.keysToClean.iterator();
        while (iterator.hasNext()) {
            CleanupKey cleanupKey = iterator.next();
            iterator.remove();
            if (cleanupKey.readerCacheKey == null || !cleanupKey.entity.isOpen()) {
                currentFullClean.add(cleanupKey.entity.getCacheIdentity());
                continue;
            }
            currentKeysToClean.add(cleanupKey);
        }
        if (!currentKeysToClean.isEmpty() || !currentFullClean.isEmpty()) {
            iterator = this.cache.keys().iterator();
            while (iterator.hasNext()) {
                Key key = (Key)((Object)iterator.next());
                if (currentFullClean.contains(key.entity.getCacheIdentity())) {
                    iterator.remove();
                    continue;
                }
                if (!currentKeysToClean.contains(new CleanupKey(key.entity, key.readerCacheKey))) continue;
                iterator.remove();
            }
        }
        this.cache.refresh();
    }

    int count() {
        return this.cache.count();
    }

    int numRegisteredCloseListeners() {
        return this.registeredClosedListeners.size();
    }

    private class CleanupKey
    implements IndexReader.ClosedListener {
        final CacheEntity entity;
        final IndexReader.CacheKey readerCacheKey;

        private CleanupKey(CacheEntity entity, IndexReader.CacheKey readerCacheKey) {
            this.entity = entity;
            this.readerCacheKey = readerCacheKey;
        }

        public void onClose(IndexReader.CacheKey cacheKey) {
            Boolean remove = (Boolean)IndicesRequestCache.this.registeredClosedListeners.remove(this);
            if (remove != null) {
                IndicesRequestCache.this.keysToClean.add(this);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CleanupKey that = (CleanupKey)o;
            if (!Objects.equals(this.readerCacheKey, that.readerCacheKey)) {
                return false;
            }
            return this.entity.getCacheIdentity().equals(that.entity.getCacheIdentity());
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + Objects.hashCode(this.readerCacheKey);
            return result;
        }
    }

    static interface CacheEntity
    extends Accountable {
        public void onCached(Key var1, BytesReference var2);

        public boolean isOpen();

        public Object getCacheIdentity();

        public void onHit();

        public void onMiss();

        public void onRemoval(RemovalNotification<Key, BytesReference> var1);
    }

    static class Key
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Key.class);
        public final CacheEntity entity;
        public final MappingLookup.CacheKey mappingCacheKey;
        public final IndexReader.CacheKey readerCacheKey;
        public final BytesReference value;

        Key(CacheEntity entity, MappingLookup.CacheKey mappingCacheKey, IndexReader.CacheKey readerCacheKey, BytesReference value) {
            this.entity = entity;
            this.mappingCacheKey = Objects.requireNonNull(mappingCacheKey);
            this.readerCacheKey = Objects.requireNonNull(readerCacheKey);
            this.value = value;
        }

        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + this.entity.ramBytesUsed() + (long)this.value.length();
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.mappingCacheKey.equals(key.mappingCacheKey)) {
                return false;
            }
            if (!this.readerCacheKey.equals(key.readerCacheKey)) {
                return false;
            }
            if (!this.entity.getCacheIdentity().equals(key.entity.getCacheIdentity())) {
                return false;
            }
            return this.value.equals((Object)key.value);
        }

        public int hashCode() {
            int result = this.entity.getCacheIdentity().hashCode();
            result = 31 * result + this.mappingCacheKey.hashCode();
            result = 31 * result + this.readerCacheKey.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    private static class Loader
    implements CacheLoader<Key, BytesReference> {
        private final CacheEntity entity;
        private final CheckedSupplier<BytesReference, IOException> loader;
        private boolean loaded;

        Loader(CacheEntity entity, CheckedSupplier<BytesReference, IOException> loader) {
            this.entity = entity;
            this.loader = loader;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public BytesReference load(Key key) throws Exception {
            BytesReference value = (BytesReference)this.loader.get();
            this.entity.onCached(key, value);
            this.loaded = true;
            return value;
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(INDICES_CACHE_QUERY_SIZE, INDICES_CACHE_QUERY_EXPIRE, INDEX_CACHE_REQUEST_ENABLED_SETTING);
        }
    }
}

