/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import io.lucenia.plugins.PluginsService;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteException;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.CheckedFunction;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.Iterables;
import io.skylite.common.Nullable;
import io.skylite.common.collect.MapBuilder;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRefCounted;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.common.util.io.IOUtils;
import io.skylite.common.util.set.Sets;
import io.skylite.core.action.admin.indices.refresh.RefreshStats;
import io.skylite.core.action.admin.indices.stats.CommonStats;
import io.skylite.core.action.admin.indices.stats.CommonStatsFlags;
import io.skylite.core.action.admin.indices.stats.IndexShardStats;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.search.SearchRequestStats;
import io.skylite.core.action.search.SearchType;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.client.Client;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.SkyliteThreadPoolExecutor;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.NamedWriteableAwareStreamInput;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.env.ShardLock;
import io.skylite.core.env.ShardLockObtainFailedException;
import io.skylite.core.index.BaseIndexService;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.cache.request.ShardRequestCache;
import io.skylite.core.index.engine.CommitStats;
import io.skylite.core.index.engine.EngineConfig;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.flush.FlushStats;
import io.skylite.core.index.get.GetStats;
import io.skylite.core.index.merge.MergeStats;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.recovery.RecoveryStats;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.RemoteStoreStatsTrackerFactory;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.seqno.RetentionLeaseStats;
import io.skylite.core.index.seqno.RetentionLeaseSyncer;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IllegalIndexShardStateException;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.IndexingStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.InternalTranslogFactory;
import io.skylite.core.index.translog.TranslogFactory;
import io.skylite.core.index.translog.TranslogStats;
import io.skylite.core.indices.IndexingMemoryController;
import io.skylite.core.indices.IndicesServiceSettings;
import io.skylite.core.indices.NodeIndicesStats;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.cluster.AllocatedIndicesInterface;
import io.skylite.core.indices.fielddata.cache.IndicesFieldDataCache;
import io.skylite.core.indices.recovery.BasePeerRecoveryTargetService;
import io.skylite.core.indices.recovery.RecoveryListener;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.mapper.MapperRegistry;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.node.RemoteStoreNodeAttribute;
import io.skylite.core.plugins.IndexStorePlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.query.QueryPhase;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.stats.SearchStats;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.util.FileSystemUtils;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.MetadataStateFormat;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.gateway.MetaStateService;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexService;
import org.opensearch.index.engine.EngineConfigFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.engine.InternalEngineFactory;
import org.opensearch.index.engine.NRTReplicationEngineFactory;
import org.opensearch.index.engine.NoOpEngine;
import org.opensearch.index.engine.ReadOnlyEngine;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.remote.filecache.FileCacheCleaner;
import org.opensearch.index.translog.RemoteBlobStoreInternalTranslogFactory;
import org.opensearch.indices.AbstractIndexShardCacheEntity;
import org.opensearch.indices.IndicesQueryCache;
import org.opensearch.indices.IndicesRequestCache;
import org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;
import org.opensearch.search.internal.SearchContext;

public class IndicesService
extends AbstractLifecycleComponent
implements AllocatedIndicesInterface<BaseIndexShard, BaseIndexService>,
IndexService.ShardStoreDeleter {
    private static final Logger logger = LogManager.getLogger(IndicesService.class);
    public static final String INDICES_SHARDS_CLOSED_TIMEOUT = "indices.shards_closed_timeout";
    private final Settings settings;
    private final PluginsService pluginsService;
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry xContentRegistry;
    private final TimeValue shardsClosedTimeout;
    private final AnalysisRegistry analysisRegistry;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final CacheCleaner cacheCleaner;
    private final ThreadPool threadPool;
    private final CircuitBreakerService circuitBreakerService;
    private final BigArrays bigArrays;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final Client client;
    private volatile Map<String, BaseIndexService> indices = Collections.emptyMap();
    private final Map<Index, List<PendingDelete>> pendingDeletes = new HashMap<Index, List<PendingDelete>>();
    private final AtomicInteger numUncompletedDeletes = new AtomicInteger();
    private final OldShardsStats oldShardsStats = new OldShardsStats();
    private final MapperRegistry mapperRegistry;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final IndexingMemoryController indexingMemoryController;
    private final TimeValue cleanInterval;
    final IndicesRequestCache indicesRequestCache;
    private final IndicesQueryCache indicesQueryCache;
    private final MetaStateService metaStateService;
    private final Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders;
    private final Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories;
    private final Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories;
    final AbstractRefCounted indicesRefCount;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private volatile boolean idFieldDataEnabled;
    private volatile boolean allowExpensiveQueries;
    private final RecoverySettings recoverySettings;
    private final RemoteStoreSettings remoteStoreSettings;
    @Nullable
    private final SkyliteThreadPoolExecutor danglingIndicesThreadPoolExecutor;
    private final Set<Index> danglingIndicesToWrite = Sets.newConcurrentHashSet();
    private final boolean nodeWriteDanglingIndicesInfo;
    private final AggregationRegistry aggregationRegistry;
    private final IndexStorePlugin.DirectoryFactory remoteDirectoryFactory;
    private final BiFunction<IndexSettings, ShardRouting, TranslogFactory> translogFactorySupplier;
    private volatile TimeValue clusterDefaultRefreshInterval;
    private final FileCacheCleaner fileCacheCleaner;
    private final SearchRequestStats searchRequestStats;
    private static final String DANGLING_INDICES_UPDATE_THREAD_NAME = "DanglingIndices#updateTask";
    private final IndexDeletionAllowedPredicate DEFAULT_INDEX_DELETION_PREDICATE = (index, indexSettings) -> this.canDeleteIndexContents(index, indexSettings);
    private final IndexDeletionAllowedPredicate ALWAYS_TRUE = (index, indexSettings) -> true;

    protected void doStart() {
        this.threadPool.schedule((Runnable)this.cacheCleaner, this.cleanInterval, "same");
    }

    public IndicesService(Settings settings, PluginsService pluginsService, NodeEnvironment nodeEnv, NamedXContentRegistry xContentRegistry, final AnalysisRegistry analysisRegistry, IndexNameExpressionResolver indexNameExpressionResolver, MapperRegistry mapperRegistry, NamedWriteableRegistry namedWriteableRegistry, ThreadPool threadPool, IndexScopedSettings indexScopedSettings, final CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ScriptService scriptService, ClusterService clusterService, Client client, MetaStateService metaStateService, Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders, Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories, AggregationRegistry aggregationRegistry, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories, IndexStorePlugin.DirectoryFactory remoteDirectoryFactory, Supplier<RepositoriesService> repositoriesServiceSupplier, FileCacheCleaner fileCacheCleaner, SearchRequestStats searchRequestStats, @Nullable RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory, RecoverySettings recoverySettings, RemoteStoreSettings remoteStoreSettings) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.pluginsService = pluginsService;
        this.nodeEnv = nodeEnv;
        this.xContentRegistry = xContentRegistry;
        this.aggregationRegistry = aggregationRegistry;
        this.shardsClosedTimeout = settings.getAsTime(INDICES_SHARDS_CLOSED_TIMEOUT, new TimeValue(1L, TimeUnit.DAYS));
        this.analysisRegistry = analysisRegistry;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indicesRequestCache = new IndicesRequestCache(settings);
        this.indicesQueryCache = new IndicesQueryCache(settings);
        this.mapperRegistry = mapperRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.indexingMemoryController = new IndexingMemoryController(settings, threadPool, () -> Iterables.flatten((Iterable)((Object)this)).iterator());
        this.indexScopedSettings = indexScopedSettings;
        this.circuitBreakerService = circuitBreakerService;
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.client = client;
        this.idFieldDataEnabled = (Boolean)IndicesServiceSettings.INDICES_ID_FIELD_DATA_ENABLED_SETTING.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndicesServiceSettings.INDICES_ID_FIELD_DATA_ENABLED_SETTING, this::setIdFieldDataEnabled);
        this.indicesFieldDataCache = new IndicesFieldDataCache(settings, new IndexFieldDataCache.Listener(){

            public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
                assert (sizeInBytes >= 0L) : "When reducing circuit breaker, it should be adjusted with a number higher or equal to 0 and not [" + sizeInBytes + "]";
                circuitBreakerService.getBreaker("fielddata").addWithoutBreaking(-sizeInBytes);
            }
        });
        this.cleanInterval = (TimeValue)IndicesServiceSettings.INDICES_CACHE_CLEAN_INTERVAL_SETTING.get(settings);
        this.cacheCleaner = new CacheCleaner(this.indicesFieldDataCache, this.indicesRequestCache, logger, threadPool, this.cleanInterval);
        this.metaStateService = metaStateService;
        this.engineFactoryProviders = engineFactoryProviders;
        this.directoryFactories = directoryFactories;
        this.recoveryStateFactories = recoveryStateFactories;
        this.fileCacheCleaner = fileCacheCleaner;
        this.indicesRefCount = new AbstractRefCounted("indices"){

            protected void closeInternal() {
                try {
                    IOUtils.close((Closeable[])new Closeable[]{analysisRegistry, IndicesService.this.indexingMemoryController, IndicesService.this.indicesFieldDataCache, IndicesService.this.cacheCleaner, IndicesService.this.indicesRequestCache, IndicesService.this.indicesQueryCache});
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    IndicesService.this.closeLatch.countDown();
                }
            }
        };
        String nodeName = Objects.requireNonNull((String)CommonSettings.NODE_NAME_SETTING.get(settings));
        this.nodeWriteDanglingIndicesInfo = (Boolean)IndicesServiceSettings.WRITE_DANGLING_INDICES_INFO_SETTING.get(settings);
        this.danglingIndicesThreadPoolExecutor = this.nodeWriteDanglingIndicesInfo ? SkyliteExecutors.newScaling((String)(nodeName + "/DanglingIndices#updateTask"), (int)1, (int)1, (long)0L, (TimeUnit)TimeUnit.MILLISECONDS, (ThreadFactory)SkyliteExecutors.daemonThreadFactory((String)nodeName, (String)DANGLING_INDICES_UPDATE_THREAD_NAME), (ThreadContext)threadPool.getThreadContext()) : null;
        this.allowExpensiveQueries = (Boolean)SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES, this::setAllowExpensiveQueries);
        this.remoteDirectoryFactory = remoteDirectoryFactory;
        this.translogFactorySupplier = IndicesService.getTranslogFactorySupplier(repositoriesServiceSupplier, threadPool, remoteStoreStatsTrackerFactory, settings, remoteStoreSettings);
        this.searchRequestStats = searchRequestStats;
        this.clusterDefaultRefreshInterval = (TimeValue)IndicesServiceSettings.CLUSTER_DEFAULT_INDEX_REFRESH_INTERVAL_SETTING.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndicesServiceSettings.CLUSTER_DEFAULT_INDEX_REFRESH_INTERVAL_SETTING, this::onRefreshIntervalUpdate);
        this.recoverySettings = recoverySettings;
        this.remoteStoreSettings = remoteStoreSettings;
    }

    private void onRefreshIntervalUpdate(TimeValue clusterDefaultRefreshInterval) {
        this.clusterDefaultRefreshInterval = clusterDefaultRefreshInterval;
        for (Map.Entry<String, BaseIndexService> entry : this.indices.entrySet()) {
            BaseIndexService baseIndexService = entry.getValue();
            IndexService indexService = (IndexService)baseIndexService;
            indexService.onRefreshIntervalChange();
        }
    }

    private static BiFunction<IndexSettings, ShardRouting, TranslogFactory> getTranslogFactorySupplier(Supplier<RepositoriesService> repositoriesServiceSupplier, ThreadPool threadPool, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory, Settings settings, RemoteStoreSettings remoteStoreSettings) {
        return (indexSettings, shardRouting) -> {
            if (indexSettings.isRemoteTranslogStoreEnabled() && shardRouting.primary()) {
                return new RemoteBlobStoreInternalTranslogFactory(repositoriesServiceSupplier, threadPool, indexSettings.getRemoteStoreTranslogRepository(), remoteStoreStatsTrackerFactory.getRemoteTranslogTransferTracker(shardRouting.shardId()), remoteStoreSettings);
            }
            if (RemoteStoreNodeAttribute.isRemoteDataAttributePresent((Settings)settings) && shardRouting.primary()) {
                return new RemoteBlobStoreInternalTranslogFactory(repositoriesServiceSupplier, threadPool, RemoteStoreNodeAttribute.getRemoteStoreTranslogRepo((Settings)indexSettings.getNodeSettings()), remoteStoreStatsTrackerFactory.getRemoteTranslogTransferTracker(shardRouting.shardId()), remoteStoreSettings);
            }
            return new InternalTranslogFactory();
        };
    }

    public ClusterService clusterService() {
        return this.clusterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        ThreadPool.terminate((ExecutorService)this.danglingIndicesThreadPoolExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        ExecutorService indicesStopExecutor = Executors.newFixedThreadPool(5, SkyliteExecutors.daemonThreadFactory((Settings)this.settings, (String)"indices_shutdown"));
        Set indices = this.indices.values().stream().map(s -> s.index()).collect(Collectors.toSet());
        CountDownLatch latch = new CountDownLatch(indices.size());
        for (Index index : indices) {
            indicesStopExecutor.execute(() -> {
                try {
                    this.removeIndex(index, AllocatedIndicesInterface.IndexRemovalReason.NO_LONGER_ASSIGNED, "shutdown");
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            if (!latch.await(this.shardsClosedTimeout.seconds(), TimeUnit.SECONDS)) {
                logger.warn("Not all shards are closed yet, waited {}sec - stopping service", (Object)this.shardsClosedTimeout.seconds());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            indicesStopExecutor.shutdown();
        }
    }

    protected void doClose() throws IOException {
        this.indicesRefCount.decRef();
    }

    public boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.closeLatch.await(timeout, timeUnit);
    }

    public NodeIndicesStats stats(CommonStatsFlags flags) {
        CommonStats commonStats = new CommonStats(flags);
        block9: for (CommonStatsFlags.Flag flag : flags.getFlags()) {
            switch (flag) {
                case Get: {
                    commonStats.get.add(this.oldShardsStats.getStats);
                    continue block9;
                }
                case Indexing: {
                    commonStats.indexing.add(this.oldShardsStats.indexingStats);
                    continue block9;
                }
                case Search: {
                    commonStats.search.add(this.oldShardsStats.searchStats);
                    continue block9;
                }
                case Merge: {
                    commonStats.merge.add(this.oldShardsStats.mergeStats);
                    continue block9;
                }
                case Refresh: {
                    commonStats.refresh.add(this.oldShardsStats.refreshStats);
                    continue block9;
                }
                case Recovery: {
                    commonStats.recoveryStats.add(this.oldShardsStats.recoveryStats);
                    continue block9;
                }
                case Flush: {
                    commonStats.flush.add(this.oldShardsStats.flushStats);
                }
            }
        }
        return new NodeIndicesStats(commonStats, this.statsByShard(this, flags), this.searchRequestStats);
    }

    Map<Index, List<IndexShardStats>> statsByShard(IndicesService indicesService, CommonStatsFlags flags) {
        HashMap<Index, List<IndexShardStats>> statsByShard = new HashMap<Index, List<IndexShardStats>>();
        Iterator<BaseIndexService> iterator = indicesService.iterator();
        while (iterator.hasNext()) {
            BaseIndexService indexService = iterator.next();
            for (BaseIndexShard indexShard : indexService) {
                try {
                    IndexShardStats indexShardStats = indicesService.indexShardStats(indicesService, indexShard, flags);
                    if (indexShardStats == null) continue;
                    if (!statsByShard.containsKey(indexService.index())) {
                        statsByShard.put(indexService.index(), CollectionUtils.arrayAsArrayList((Object[])new IndexShardStats[]{indexShardStats}));
                        continue;
                    }
                    ((List)statsByShard.get(indexService.index())).add(indexShardStats);
                }
                catch (IllegalIndexShardStateException | AlreadyClosedException e) {
                    logger.trace(() -> new ParameterizedMessage("{} ignoring shard stats", (Object)indexShard.shardId()), e);
                }
            }
        }
        return statsByShard;
    }

    IndexShardStats indexShardStats(IndicesService indicesService, BaseIndexShard baseIndexShard, CommonStatsFlags flags) {
        RetentionLeaseStats retentionLeaseStats;
        SeqNoStats seqNoStats;
        CommitStats commitStats;
        IndexShard indexShard = (IndexShard)baseIndexShard;
        if (indexShard.routingEntry() == null) {
            return null;
        }
        try {
            commitStats = indexShard.commitStats();
            seqNoStats = indexShard.seqNoStats();
            retentionLeaseStats = indexShard.getRetentionLeaseStats();
        }
        catch (AlreadyClosedException e) {
            commitStats = null;
            seqNoStats = null;
            retentionLeaseStats = null;
        }
        ShardId shardId = indexShard.shardId();
        IndicesQueryCache indicesQueryCache = indicesService.getIndicesQueryCache();
        return new IndexShardStats(shardId, new ShardStats[]{new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(flags, indexShard.docStats(), indexShard.storeStats(), indexShard.indexingStats(), indexShard.getStats(), indexShard.searchStats(flags.groups()), indexShard.mergeStats(), indexShard.refreshStats(), indexShard.flushStats(), indexShard.warmerStats(), indicesQueryCache.getStats(shardId), indexShard.fieldDataStats(flags.fieldDataFields()), indexShard.completionStats(flags.completionDataFields()), indexShard.segmentStats(flags.includeSegmentFileSizes(), flags.includeUnloadedSegments()), indexShard.translogStats(), indexShard.requestCache().stats(), indexShard.recoveryStats()), commitStats, seqNoStats, retentionLeaseStats)});
    }

    private void ensureChangesAllowed() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("Can't make changes to indices service, node is closed");
        }
    }

    public Iterator<BaseIndexService> iterator() {
        return this.indices.values().iterator();
    }

    public boolean hasIndex(Index index) {
        return this.indices.containsKey(index.getUUID());
    }

    @Nullable
    public IndexService indexService(Index index) {
        return (IndexService)this.indices.get(index.getUUID());
    }

    public IndexService indexServiceSafe(Index index) {
        BaseIndexService baseIndexService = this.indices.get(index.getUUID());
        IndexService indexService = (IndexService)baseIndexService;
        if (indexService == null) {
            throw new IndexNotFoundException(index);
        }
        assert (indexService.indexUUID().equals(index.getUUID())) : "uuid mismatch local: " + indexService.indexUUID() + " incoming: " + index.getUUID();
        return indexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IndexService createIndex(IndexMetadata indexMetadata, List<IndexEventListener> builtInListeners, boolean writeDanglingIndices) throws IOException {
        this.ensureChangesAllowed();
        if (indexMetadata.getIndexUUID().equals("_na_")) {
            throw new IllegalArgumentException("index must have a real UUID found value: [" + indexMetadata.getIndexUUID() + "]");
        }
        Index index = indexMetadata.getIndex();
        if (this.hasIndex(index)) {
            throw new ResourceAlreadyExistsException(index);
        }
        ArrayList<IndexEventListener> finalListeners = new ArrayList<IndexEventListener>(builtInListeners);
        IndexEventListener onStoreClose = new IndexEventListener(){

            public void onStoreCreated(ShardId shardId) {
                IndicesService.this.indicesRefCount.incRef();
            }

            public void onStoreClosed(ShardId shardId) {
                try {
                    IndicesService.this.indicesQueryCache.onClose(shardId);
                }
                finally {
                    IndicesService.this.indicesRefCount.decRef();
                }
            }
        };
        finalListeners.add(onStoreClose);
        finalListeners.add(this.oldShardsStats);
        finalListeners.add(this.fileCacheCleaner);
        IndexService indexService = this.createIndexService(BaseIndexService.IndexCreationContext.CREATE_INDEX, indexMetadata, this.indicesQueryCache, this.indicesFieldDataCache, finalListeners, new IndexingOperationListener[]{this.indexingMemoryController});
        boolean success = false;
        try {
            if (writeDanglingIndices && this.nodeWriteDanglingIndicesInfo) {
                indexService.addMetadataListener(imd -> this.updateDanglingIndicesInfo(index));
            }
            indexService.getIndexEventListener().afterIndexCreated((BaseIndexService)indexService);
            this.indices = MapBuilder.newMapBuilder(this.indices).put((Object)index.getUUID(), (Object)indexService).immutableMap();
            if (writeDanglingIndices) {
                if (this.nodeWriteDanglingIndicesInfo) {
                    this.updateDanglingIndicesInfo(index);
                } else {
                    indexService.deleteDanglingIndicesInfo();
                }
            }
            success = true;
            IndexService indexService2 = indexService;
            return indexService2;
        }
        finally {
            if (!success) {
                indexService.close("plugins_failed", true);
            }
        }
    }

    public <T, E extends Exception> T withTempIndexService(IndexMetadata indexMetadata, CheckedFunction<IndexService, T, E> indexServiceConsumer) throws IOException, E {
        final Index index = indexMetadata.getIndex();
        if (this.hasIndex(index)) {
            throw new ResourceAlreadyExistsException(index);
        }
        List<IndexEventListener> finalListeners = Collections.singletonList(new IndexEventListener(){

            public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
                assert (false) : "temp index should not trigger shard creation";
                throw new SkyliteException("temp index should not trigger shard creation [{}]", new Object[]{index});
            }

            public void onStoreCreated(ShardId shardId) {
                assert (false) : "temp index should not trigger store creation";
                throw new SkyliteException("temp index should not trigger store creation [{}]", new Object[]{index});
            }
        });
        IndexService indexService = this.createIndexService(BaseIndexService.IndexCreationContext.CREATE_INDEX, indexMetadata, this.indicesQueryCache, this.indicesFieldDataCache, finalListeners, new IndexingOperationListener[]{this.indexingMemoryController});
        try (Closeable dummy = () -> indexService.close("temp", false);){
            Object object = indexServiceConsumer.apply((Object)indexService);
            return (T)object;
        }
    }

    private synchronized IndexService createIndexService(BaseIndexService.IndexCreationContext indexCreationContext, IndexMetadata indexMetadata, IndicesQueryCache indicesQueryCache, IndicesFieldDataCache indicesFieldDataCache, List<IndexEventListener> builtInListeners, IndexingOperationListener ... indexingOperationListeners) throws IOException {
        IndexSettings idxSettings = new IndexSettings(indexMetadata, this.settings, this.indexScopedSettings);
        if (EngineConfig.INDEX_OPTIMIZE_AUTO_GENERATED_IDS.exists(idxSettings.getSettings())) {
            throw new IllegalArgumentException("Setting [" + EngineConfig.INDEX_OPTIMIZE_AUTO_GENERATED_IDS.getKey() + "] was removed in version 7.0.0");
        }
        this.indexScopedSettings.validate(indexMetadata.getSettings(), true, true, true);
        logger.debug("creating Index [{}], shards [{}]/[{}] - reason [{}]", (Object)indexMetadata.getIndex(), (Object)idxSettings.getNumberOfShards(), (Object)idxSettings.getNumberOfReplicas(), (Object)indexCreationContext);
        IndexModule indexModule = new IndexModule(idxSettings, this.analysisRegistry, this.getEngineFactory(idxSettings), this.getEngineConfigFactory(idxSettings), this.directoryFactories, () -> this.allowExpensiveQueries, this.indexNameExpressionResolver, this.recoveryStateFactories);
        for (IndexingOperationListener operationListener : indexingOperationListeners) {
            indexModule.addIndexOperationListener(operationListener);
        }
        this.pluginsService.onIndexModule(indexModule);
        for (IndexEventListener listener : builtInListeners) {
            indexModule.addIndexEventListener(listener);
        }
        return indexModule.newIndexService(indexCreationContext, this.nodeEnv, this.xContentRegistry, this, this.circuitBreakerService, this.bigArrays, this.threadPool, this.scriptService, this.clusterService, this.client, indicesQueryCache, this.mapperRegistry, indicesFieldDataCache, this.namedWriteableRegistry, this::isIdFieldDataEnabled, this.aggregationRegistry, this.remoteDirectoryFactory, this.translogFactorySupplier, this::getClusterDefaultRefreshInterval, this.recoverySettings, this.remoteStoreSettings);
    }

    private EngineConfigFactory getEngineConfigFactory(IndexSettings idxSettings) {
        return new EngineConfigFactory(this.pluginsService, idxSettings);
    }

    private EngineFactory getEngineFactory(IndexSettings idxSettings) {
        IndexMetadata indexMetadata = idxSettings.getIndexMetadata();
        if (indexMetadata != null && indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            return NoOpEngine::new;
        }
        List engineFactories = this.engineFactoryProviders.stream().map(engineFactoryProvider -> (Optional)engineFactoryProvider.apply(idxSettings)).filter(maybe -> Objects.requireNonNull(maybe).isPresent()).collect(Collectors.toList());
        if (engineFactories.isEmpty()) {
            if (idxSettings.isRemoteSnapshot()) {
                return config -> new ReadOnlyEngine(config, new SeqNoStats(0L, 0L, 0L), new TranslogStats(), true, Function.identity(), false);
            }
            if (idxSettings.isSegRepEnabledOrRemoteNode() || idxSettings.isAssignedOnRemoteNode()) {
                return new NRTReplicationEngineFactory();
            }
            return new InternalEngineFactory();
        }
        if (engineFactories.size() == 1) {
            assert (((Optional)engineFactories.get(0)).isPresent());
            return (EngineFactory)((Optional)engineFactories.get(0)).get();
        }
        String message = String.format(Locale.ROOT, "multiple engine factories provided for %s: %s", idxSettings.getIndex(), engineFactories.stream().map(t -> {
            assert (t.isPresent());
            return "[" + ((EngineFactory)t.get()).getClass().getName() + "]";
        }).collect(Collectors.joining(",")));
        throw new IllegalStateException(message);
    }

    public synchronized MapperService createIndexMapperService(IndexMetadata indexMetadata) throws IOException {
        IndexSettings idxSettings = new IndexSettings(indexMetadata, this.settings, this.indexScopedSettings);
        IndexModule indexModule = new IndexModule(idxSettings, this.analysisRegistry, this.getEngineFactory(idxSettings), this.getEngineConfigFactory(idxSettings), this.directoryFactories, () -> this.allowExpensiveQueries, this.indexNameExpressionResolver, this.recoveryStateFactories);
        this.pluginsService.onIndexModule(indexModule);
        return indexModule.newIndexMapperService(this.xContentRegistry, this.mapperRegistry, this.scriptService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyIndexMetadata(IndexMetadata metadata, IndexMetadata metadataUpdate) throws IOException {
        ArrayList<Object> closeables = new ArrayList<Object>();
        try {
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(this.settings, new IndexFieldDataCache.Listener(this){});
            closeables.add(indicesFieldDataCache);
            IndicesQueryCache indicesQueryCache = new IndicesQueryCache(this.settings);
            closeables.add(indicesQueryCache);
            IndexService service = this.createIndexService(BaseIndexService.IndexCreationContext.METADATA_VERIFICATION, metadata, indicesQueryCache, indicesFieldDataCache, Collections.emptyList(), new IndexingOperationListener[0]);
            closeables.add(() -> service.close("metadata verification", false));
            service.mapperService().merge(metadata, MergeReason.MAPPING_RECOVERY);
            if (!metadata.equals((Object)metadataUpdate)) {
                service.updateMetadata(metadata, metadataUpdate);
            }
        }
        finally {
            IOUtils.close(closeables);
        }
    }

    public IndexShard createShard(ShardRouting shardRouting, BiFunction<BaseIndexShard, ReplicationCheckpoint, Void> checkpointPublisher, BasePeerRecoveryTargetService recoveryTargetService, RecoveryListener recoveryListener, RepositoriesService repositoriesService, Consumer<BaseIndexShard.ShardFailure> onShardFailure, Consumer<ShardId> globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, DiscoveryNode targetNode, DiscoveryNode sourceNode, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory, DiscoveryNodes discoveryNodes) throws IOException {
        IndexService baseIndexService;
        Objects.requireNonNull(retentionLeaseSyncer);
        this.ensureChangesAllowed();
        IndexService indexService = baseIndexService = this.indexService(shardRouting.index());
        assert (indexService != null);
        RecoveryState recoveryState = indexService.createRecoveryState(shardRouting, targetNode, sourceNode);
        IndexShard indexShard = indexService.createShard(shardRouting, globalCheckpointSyncer, retentionLeaseSyncer, (SegmentReplicationCheckpointPublisher)checkpointPublisher, remoteStoreStatsTrackerFactory, repositoriesService, targetNode, sourceNode, discoveryNodes);
        indexShard.addShardFailureCallback(onShardFailure);
        indexShard.startRecovery(recoveryState, recoveryTargetService, recoveryListener, repositoriesService, mapping -> {
            assert (recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "mapping update consumer only required by local shards recovery";
            this.client.admin().indices().preparePutMapping(new String[0]).setConcreteIndex(shardRouting.index()).setSource(mapping.source().string(), MediaTypeRegistry.JSON).get();
        }, this);
        return indexShard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(Index index, AllocatedIndicesInterface.IndexRemovalReason reason, String extraInfo) {
        String indexName = index.getName();
        try {
            IndexEventListener listener;
            IndexService indexService;
            IndicesService indicesService = this;
            synchronized (indicesService) {
                if (!this.hasIndex(index)) {
                    return;
                }
                logger.debug("[{}] closing ... (reason [{}])", (Object)indexName, (Object)reason);
                HashMap<String, BaseIndexService> newIndices = new HashMap<String, BaseIndexService>(this.indices);
                BaseIndexService baseIndexService = (BaseIndexService)newIndices.remove(index.getUUID());
                indexService = (IndexService)baseIndexService;
                assert (indexService != null) : "IndexService is null for index: " + String.valueOf(index);
                this.indices = Collections.unmodifiableMap(newIndices);
                listener = indexService.getIndexEventListener();
            }
            listener.beforeIndexRemoved((BaseIndexService)indexService, reason);
            logger.debug("{} closing index service (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            indexService.close(extraInfo, reason == AllocatedIndicesInterface.IndexRemovalReason.DELETED);
            logger.debug("{} closed... (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            IndexSettings indexSettings = indexService.getIndexSettings();
            listener.afterIndexRemoved(indexService.index(), indexSettings, reason);
            if (reason == AllocatedIndicesInterface.IndexRemovalReason.DELETED) {
                this.deleteIndexStore(extraInfo, indexService.index(), indexSettings);
            }
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("failed to remove index {} ([{}][{}])", new Object[]{index, reason, extraInfo}), (Throwable)e);
        }
    }

    public IndicesFieldDataCache getIndicesFieldDataCache() {
        return this.indicesFieldDataCache;
    }

    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    public IndicesQueryCache getIndicesQueryCache() {
        return this.indicesQueryCache;
    }

    public void addDocStatusStats(IndexingStats.Stats.DocStatusStats stats) {
        this.oldShardsStats.indexingStats.getTotal().getDocStatusStats().add(stats);
    }

    public void deleteUnassignedIndex(String reason, IndexMetadata metadata, ClusterState clusterState) {
        if (this.nodeEnv.hasNodeFile()) {
            String indexName = metadata.getIndex().getName();
            try {
                if (clusterState.metadata().hasIndex(indexName)) {
                    IndexMetadata index = clusterState.metadata().index(indexName);
                    throw new IllegalStateException("Can't delete unassigned index store for [" + indexName + "] - it's still part of the cluster state [" + index.getIndexUUID() + "] [" + metadata.getIndexUUID() + "]");
                }
                this.deleteIndexStore(reason, metadata);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to delete unassigned index (reason [{}])", (Object)metadata.getIndex(), (Object)reason), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIndexStore(String reason, IndexMetadata metadata) throws IOException {
        if (this.nodeEnv.hasNodeFile()) {
            IndicesService indicesService = this;
            synchronized (indicesService) {
                Index index = metadata.getIndex();
                if (this.hasIndex(index)) {
                    String localUUid = this.indexService(index).indexUUID();
                    throw new IllegalStateException("Can't delete index store for [" + index.getName() + "] - it's still part of the indices service [" + localUUid + "] [" + metadata.getIndexUUID() + "]");
                }
            }
            IndexSettings indexSettings = this.buildIndexSettings(metadata);
            this.deleteIndexStore(reason, indexSettings.getIndex(), indexSettings);
        }
    }

    private void deleteIndexStore(String reason, Index index, IndexSettings indexSettings) throws IOException {
        this.deleteIndexStoreIfDeletionAllowed(reason, index, indexSettings, this.DEFAULT_INDEX_DELETION_PREDICATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndexStoreIfDeletionAllowed(String reason, Index index, IndexSettings indexSettings, IndexDeletionAllowedPredicate predicate) throws IOException {
        boolean success = false;
        try {
            logger.debug("{} deleting index store reason [{}]", (Object)index, (Object)reason);
            if (predicate.apply(index, indexSettings)) {
                this.nodeEnv.deleteIndexDirectorySafe(index, 0L, indexSettings);
            }
            success = true;
        }
        catch (ShardLockObtainFailedException ex) {
            logger.debug(() -> new ParameterizedMessage("{} failed to delete index store - at least one shards is still locked", (Object)index), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.warn(() -> new ParameterizedMessage("{} failed to delete index", (Object)index), (Throwable)ex);
        }
        finally {
            if (!success) {
                this.addPendingDelete(index, indexSettings);
            }
            MetadataStateFormat.deleteMetaState((Path[])this.nodeEnv.indexPaths(index));
        }
    }

    @Override
    public void deleteShardStore(String reason, ShardLock lock, IndexSettings indexSettings) throws IOException {
        ShardId shardId = lock.getShardId();
        logger.trace("{} deleting shard reason [{}]", (Object)shardId, (Object)reason);
        this.nodeEnv.deleteShardDirectoryUnderLock(lock, indexSettings);
    }

    public void deleteShardStore(String reason, ShardId shardId, ClusterState clusterState) throws IOException, ShardLockObtainFailedException {
        IndexMetadata metadata = (IndexMetadata)clusterState.getMetadata().indices().get(shardId.getIndexName());
        IndexSettings indexSettings = this.buildIndexSettings(metadata);
        ShardDeletionCheckResult shardDeletionCheckResult = this.canDeleteShardContent(shardId, indexSettings);
        if (shardDeletionCheckResult != ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE) {
            throw new IllegalStateException("Can't delete shard " + String.valueOf(shardId) + " (cause: " + String.valueOf((Object)shardDeletionCheckResult) + ")");
        }
        this.nodeEnv.deleteShardDirectorySafe(shardId, indexSettings);
        logger.debug("{} deleted shard reason [{}]", (Object)shardId, (Object)reason);
        if (this.canDeleteIndexContents(shardId.getIndex(), indexSettings)) {
            if (this.nodeEnv.findAllShardIds(shardId.getIndex()).isEmpty()) {
                try {
                    this.deleteIndexStore("no longer used", metadata);
                }
                catch (Exception e) {
                    throw new SkyliteException("failed to delete unused index after deleting its last shard (" + String.valueOf(shardId) + ")", (Throwable)e, new Object[0]);
                }
            } else {
                logger.trace("[{}] still has shard stores, leaving as is", (Object)shardId.getIndex());
            }
        }
    }

    public boolean canDeleteIndexContents(Index index, IndexSettings indexSettings) {
        IndexService indexService = this.indexService(index);
        return indexService == null && this.nodeEnv.hasNodeFile();
    }

    @Nullable
    public IndexMetadata verifyIndexIsDeleted(Index index, ClusterState clusterState) {
        if (clusterState.metadata().index(index) != null) {
            throw new IllegalStateException("Cannot delete index [" + String.valueOf(index) + "], it is still part of the cluster state.");
        }
        if (this.nodeEnv.hasNodeFile() && FileSystemUtils.exists((Path[])this.nodeEnv.indexPaths(index))) {
            IndexMetadata metadata;
            try {
                metadata = this.metaStateService.loadIndexState(index);
                if (metadata == null) {
                    return null;
                }
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to load state file from a stale deleted index, folders will be left on disk", (Object)index), (Throwable)e);
                return null;
            }
            IndexSettings indexSettings = this.buildIndexSettings(metadata);
            try {
                this.deleteIndexStoreIfDeletionAllowed("stale deleted index", index, indexSettings, this.ALWAYS_TRUE);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to delete index on disk", (Object)metadata.getIndex()), (Throwable)e);
            }
            return metadata;
        }
        return null;
    }

    public ShardDeletionCheckResult canDeleteShardContent(ShardId shardId, IndexSettings indexSettings) {
        assert (shardId.getIndex().equals((Object)indexSettings.getIndex()));
        IndexService indexService = this.indexService(shardId.getIndex());
        if (this.nodeEnv.hasNodeFile()) {
            boolean isAllocated;
            boolean bl = isAllocated = indexService != null && indexService.hasShard(shardId.id());
            if (isAllocated) {
                return ShardDeletionCheckResult.STILL_ALLOCATED;
            }
            if (indexSettings.hasCustomDataPath()) {
                return Files.exists(this.nodeEnv.resolveCustomLocation(indexSettings.customDataPath(), shardId), new LinkOption[0]) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
            }
            return FileSystemUtils.exists((Path[])this.nodeEnv.availableShardPaths(shardId)) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
        }
        return ShardDeletionCheckResult.NO_LOCAL_STORAGE;
    }

    private IndexSettings buildIndexSettings(IndexMetadata metadata) {
        return new IndexSettings(metadata, this.settings);
    }

    @Override
    public void addPendingDelete(ShardId shardId, IndexSettings settings) {
        if (shardId == null) {
            throw new IllegalArgumentException("shardId must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings must not be null");
        }
        PendingDelete pendingDelete = new PendingDelete(shardId, settings);
        this.addPendingDelete(shardId.getIndex(), pendingDelete);
    }

    public void addPendingDelete(Index index, IndexSettings settings) {
        PendingDelete pendingDelete = new PendingDelete(index, settings);
        this.addPendingDelete(index, pendingDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingDelete(Index index, PendingDelete pendingDelete) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> list = this.pendingDeletes.get(index);
            if (list == null) {
                list = new ArrayList<PendingDelete>();
                this.pendingDeletes.put(index, list);
            }
            list.add(pendingDelete);
            this.numUncompletedDeletes.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingDeletes(Index index, IndexSettings indexSettings, TimeValue timeout) throws IOException, InterruptedException, ShardLockObtainFailedException {
        block20: {
            logger.debug("{} processing pending deletes", (Object)index);
            long startTimeNS = System.nanoTime();
            List shardLocks = this.nodeEnv.lockAllForIndex(index, indexSettings, "process pending deletes", timeout.millis());
            int numRemoved = 0;
            try {
                List<PendingDelete> remove;
                Object lock2;
                HashMap<ShardId, ShardLock> locks = new HashMap<ShardId, ShardLock>();
                for (Object lock2 : shardLocks) {
                    locks.put(lock2.getShardId(), (ShardLock)lock2);
                }
                lock2 = this.pendingDeletes;
                synchronized (lock2) {
                    remove = this.pendingDeletes.remove(index);
                }
                if (remove == null || remove.isEmpty()) break block20;
                numRemoved = remove.size();
                CollectionUtil.timSort(remove);
                long maxSleepTimeMs = 10000L;
                long sleepTime = 10L;
                do {
                    if (remove.isEmpty()) {
                        break;
                    }
                    Iterator<PendingDelete> iterator = remove.iterator();
                    while (iterator.hasNext()) {
                        PendingDelete delete = iterator.next();
                        if (delete.deleteIndex) {
                            assert (delete.shardId == -1);
                            logger.debug("{} deleting index store reason [{}]", (Object)index, (Object)"pending delete");
                            try {
                                this.nodeEnv.deleteIndexDirectoryUnderLock(index, indexSettings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                logger.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)index), (Throwable)ex);
                            }
                            continue;
                        }
                        assert (delete.shardId != -1);
                        ShardLock shardLock = (ShardLock)locks.get(new ShardId(delete.index, delete.shardId));
                        if (shardLock != null) {
                            try {
                                this.deleteShardStore("pending delete", shardLock, delete.settings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                logger.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)shardLock.getShardId()), (Throwable)ex);
                            }
                            continue;
                        }
                        logger.warn("{} no shard lock for pending delete", (Object)delete.shardId);
                        iterator.remove();
                    }
                    if (remove.isEmpty()) continue;
                    logger.warn("{} still pending deletes present for shards {} - retrying", (Object)index, (Object)remove.toString());
                    Thread.sleep(sleepTime);
                    sleepTime = Math.min(10000L, sleepTime * 2L);
                    logger.debug("{} schedule pending delete retry after {} ms", (Object)index, (Object)sleepTime);
                } while (System.nanoTime() - startTimeNS < timeout.nanos());
            }
            finally {
                IOUtils.close((Iterable)shardLocks);
                if (numRemoved > 0) {
                    int remainingUncompletedDeletes = this.numUncompletedDeletes.addAndGet(-numRemoved);
                    assert (remainingUncompletedDeletes >= 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numPendingDeletes(Index index) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> deleteList = this.pendingDeletes.get(index);
            if (deleteList == null) {
                return 0;
            }
            return deleteList.size();
        }
    }

    public boolean hasUncompletedPendingDeletes() {
        return this.numUncompletedDeletes.get() > 0;
    }

    public AnalysisRegistry getAnalysis() {
        return this.analysisRegistry;
    }

    public boolean canCache(ShardSearchRequest request, SearchContext context) {
        if (request.scroll() != null) {
            return false;
        }
        if (SearchType.QUERY_THEN_FETCH != context.searchType()) {
            return false;
        }
        if (request.source() != null && request.source().profile()) {
            return false;
        }
        IndexSettings settings = context.indexShard().indexSettings();
        if (request.requestCache() == null) {
            if (!((Boolean)settings.getValue(IndicesRequestCache.INDEX_CACHE_REQUEST_ENABLED_SETTING)).booleanValue()) {
                return false;
            }
            if (context.size() != 0) {
                return false;
            }
        } else if (!request.requestCache().booleanValue()) {
            return false;
        }
        assert (context.searcher().getIndexReader().getReaderCacheHelper() != null);
        return context.getQueryShardContext().isCacheable();
    }

    public void loadIntoContext(ShardSearchRequest request, SearchContext context, QueryPhase queryPhase) throws Exception {
        assert (this.canCache(request, context));
        DirectoryReader directoryReader = context.searcher().getDirectoryReader();
        boolean[] loadedFromCache = new boolean[]{true};
        BytesReference cacheKey = request.cacheKey();
        BytesReference bytesReference = this.cacheShardLevelResult(context.indexShard(), context.getQueryShardContext().mappingCacheKey(), directoryReader, cacheKey, (CheckedConsumer<StreamOutput, IOException>)((CheckedConsumer)out -> {
            queryPhase.execute((SearchExecutionContext)context);
            context.queryResult().writeToNoId(out);
            loadedFromCache[0] = false;
        }));
        if (loadedFromCache[0]) {
            QuerySearchResult result = context.queryResult();
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(bytesReference.streamInput(), this.namedWriteableRegistry);
            result.readFromWithId(context.id(), (StreamInput)in);
            result.setSearchShardTarget(context.shardTarget());
        } else if (context.queryResult().searchTimedOut()) {
            this.indicesRequestCache.invalidate(new IndexShardCacheEntity(context.indexShard()), context.getQueryShardContext().mappingCacheKey(), directoryReader, cacheKey);
            if (logger.isTraceEnabled()) {
                logger.trace("Query timed out, invalidating cache entry for request on shard [{}]:\n {}", (Object)request.shardId(), (Object)request.source());
            }
        }
    }

    public ByteSizeValue getTotalIndexingBufferBytes() {
        return this.indexingMemoryController.indexingBufferSize();
    }

    private BytesReference cacheShardLevelResult(BaseIndexShard shard, MappingLookup.CacheKey mappingCacheKey, DirectoryReader reader, BytesReference cacheKey, CheckedConsumer<StreamOutput, IOException> loader) throws Exception {
        IndexShardCacheEntity cacheEntity = new IndexShardCacheEntity(shard);
        CheckedSupplier supplier = () -> {
            int expectedSizeInBytes = 512;
            try (BytesStreamOutput out = new BytesStreamOutput(512);){
                loader.accept((Object)out);
                BytesReference bytesReference = out.bytes();
                return bytesReference;
            }
        };
        return this.indicesRequestCache.getOrCompute(cacheEntity, (CheckedSupplier<BytesReference, IOException>)supplier, mappingCacheKey, reader, cacheKey);
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, Set<String> resolvedExpressions) {
        CheckedFunction filterParser = bytes -> {
            try (StreamInput inputStream = bytes.streamInput();){
                QueryBuilder queryBuilder;
                block12: {
                    XContentParser parser = MediaTypeRegistry.xContentType((InputStream)inputStream).xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)inputStream);
                    try {
                        queryBuilder = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                        if (parser == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return queryBuilder;
            }
        };
        IndexMetadata indexMetadata = state.metadata().index(index);
        String[] aliases = this.indexNameExpressionResolver.filteringAliases(state, index, resolvedExpressions);
        return new AliasFilter(ShardSearchRequest.parseAliasFilter((CheckedFunction)filterParser, (IndexMetadata)indexMetadata, (String[])aliases), aliases);
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis) {
        return this.getRewriteContext(nowInMillis, false);
    }

    public QueryRewriteContext getValidationRewriteContext(LongSupplier nowInMillis) {
        return this.getRewriteContext(nowInMillis, true);
    }

    private QueryRewriteContext getRewriteContext(LongSupplier nowInMillis, boolean validate) {
        return new QueryRewriteContext(this.xContentRegistry, this.namedWriteableRegistry, (SkyliteClient)this.client, nowInMillis, validate);
    }

    public void clearIndexShardCache(ShardId shardId, boolean queryCache, boolean fieldDataCache, boolean requestCache, String ... fields) {
        IndexService service = this.indexService(shardId.getIndex());
        if (service != null) {
            IndexShard shard = service.getShardOrNull(shardId.id());
            boolean clearedAtLeastOne = service.clearCaches(queryCache, fieldDataCache, fields);
            if ((requestCache || !clearedAtLeastOne && fields.length == 0) && shard != null) {
                this.indicesRequestCache.clear(new IndexShardCacheEntity(shard));
            }
        }
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return this.mapperRegistry.getFieldFilter();
    }

    public boolean isMetadataField(String field) {
        return this.mapperRegistry.isMetadataField(field);
    }

    public boolean isIdFieldDataEnabled() {
        return this.idFieldDataEnabled;
    }

    private void setIdFieldDataEnabled(boolean value) {
        this.idFieldDataEnabled = value;
    }

    private void updateDanglingIndicesInfo(final Index index) {
        assert (DiscoveryNode.isDataNode((Settings)this.settings)) : "dangling indices information should only be persisted on data nodes";
        assert (this.nodeWriteDanglingIndicesInfo) : "writing dangling indices info is not enabled";
        assert (this.danglingIndicesThreadPoolExecutor != null) : "executor for dangling indices info is not available";
        if (this.danglingIndicesToWrite.add(index)) {
            logger.trace("triggered dangling indices update for {}", (Object)index);
            final long triggeredTimeMillis = this.threadPool.relativeTimeInMillis();
            try {
                this.danglingIndicesThreadPoolExecutor.execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception e) {
                        logger.warn(() -> new ParameterizedMessage("failed to write dangling indices state for index {}", (Object)index), (Throwable)e);
                    }

                    public void doRun() {
                        boolean exists = IndicesService.this.danglingIndicesToWrite.remove(index);
                        assert (exists) : "removed non-existing item for " + String.valueOf(index);
                        BaseIndexService baseIndexService = IndicesService.this.indices.get(index.getUUID());
                        IndexService indexService = (IndexService)baseIndexService;
                        if (indexService != null) {
                            long executedTimeMillis = IndicesService.this.threadPool.relativeTimeInMillis();
                            logger.trace("writing out dangling indices state for index {}, triggered {} ago", (Object)index, (Object)TimeValue.timeValueMillis((long)Math.min(0L, executedTimeMillis - triggeredTimeMillis)));
                            indexService.writeDanglingIndicesInfo();
                            long completedTimeMillis = IndicesService.this.threadPool.relativeTimeInMillis();
                            logger.trace("writing out of dangling indices state for index {} completed after {}", (Object)index, (Object)TimeValue.timeValueMillis((long)Math.min(0L, completedTimeMillis - executedTimeMillis)));
                        } else {
                            logger.trace("omit writing dangling indices state for index {} as index is deallocated on this node", (Object)index);
                        }
                    }
                });
            }
            catch (SkyliteRejectedExecutionException e) {
                assert (this.danglingIndicesThreadPoolExecutor.isShutdown());
            }
        } else {
            logger.trace("dangling indices update already pending for {}", (Object)index);
        }
    }

    private void setAllowExpensiveQueries(Boolean allowExpensiveQueries) {
        this.allowExpensiveQueries = allowExpensiveQueries;
    }

    public boolean allPendingDanglingIndicesWritten() {
        return !this.nodeWriteDanglingIndicesInfo || this.danglingIndicesToWrite.isEmpty() && this.danglingIndicesThreadPoolExecutor.getActiveCount() == 0;
    }

    private TimeValue getClusterDefaultRefreshInterval() {
        return this.clusterDefaultRefreshInterval;
    }

    public RemoteStoreSettings getRemoteStoreSettings() {
        return this.remoteStoreSettings;
    }

    private static final class CacheCleaner
    implements Runnable,
    Releasable {
        private final IndicesFieldDataCache cache;
        private final Logger logger;
        private final ThreadPool threadPool;
        private final TimeValue interval;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final IndicesRequestCache requestCache;

        CacheCleaner(IndicesFieldDataCache cache, IndicesRequestCache requestCache, Logger logger, ThreadPool threadPool, TimeValue interval) {
            this.cache = cache;
            this.requestCache = requestCache;
            this.logger = logger;
            this.threadPool = threadPool;
            this.interval = interval;
        }

        @Override
        public void run() {
            long startTimeNS = System.nanoTime();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("running periodic field data cache cleanup");
            }
            try {
                this.cache.getCache().refresh();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic field data cache cleanup:", (Throwable)e);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("periodic field data cache cleanup finished in {} milliseconds", (Object)TimeValue.nsecToMSec((long)(System.nanoTime() - startTimeNS)));
            }
            try {
                this.requestCache.cleanCache();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic request cache cleanup:", (Throwable)e);
            }
            if (!this.closed.get()) {
                this.threadPool.scheduleUnlessShuttingDown(this.interval, "same", (Runnable)this);
            }
        }

        public void close() {
            this.closed.compareAndSet(false, true);
        }
    }

    static class OldShardsStats
    implements IndexEventListener {
        final SearchStats searchStats = new SearchStats();
        final GetStats getStats = new GetStats();
        final IndexingStats indexingStats = new IndexingStats();
        final MergeStats mergeStats = new MergeStats();
        final RefreshStats refreshStats = new RefreshStats();
        final FlushStats flushStats = new FlushStats();
        final RecoveryStats recoveryStats = new RecoveryStats();

        OldShardsStats() {
        }

        public synchronized void beforeIndexShardClosed(ShardId shardId, @Nullable BaseIndexShard baseIndexShard, Settings indexSettings) {
            if (baseIndexShard != null) {
                IndexShard indexShard = (IndexShard)baseIndexShard;
                this.getStats.addTotals(indexShard.getStats());
                this.indexingStats.addTotals(indexShard.indexingStats());
                this.searchStats.addTotalsForClosingShard(indexShard.searchStats(new String[0]));
                this.mergeStats.addTotals(indexShard.mergeStats());
                this.refreshStats.addTotals(indexShard.refreshStats());
                this.flushStats.addTotals(indexShard.flushStats());
                this.recoveryStats.addTotals(indexShard.recoveryStats());
            }
        }
    }

    @FunctionalInterface
    static interface IndexDeletionAllowedPredicate {
        public boolean apply(Index var1, IndexSettings var2);
    }

    public static enum ShardDeletionCheckResult {
        FOLDER_FOUND_CAN_DELETE,
        STILL_ALLOCATED,
        NO_FOLDER_FOUND,
        NO_LOCAL_STORAGE;

    }

    private static final class PendingDelete
    implements Comparable<PendingDelete> {
        final Index index;
        final int shardId;
        final IndexSettings settings;
        final boolean deleteIndex;

        PendingDelete(ShardId shardId, IndexSettings settings) {
            this.index = shardId.getIndex();
            this.shardId = shardId.getId();
            this.settings = settings;
            this.deleteIndex = false;
        }

        PendingDelete(Index index, IndexSettings settings) {
            this.index = index;
            this.shardId = -1;
            this.settings = settings;
            this.deleteIndex = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.index).append("]");
            if (this.shardId != -1) {
                sb.append("[").append(this.shardId).append("]");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(PendingDelete o) {
            return Integer.compare(this.shardId, o.shardId);
        }
    }

    static final class IndexShardCacheEntity
    extends AbstractIndexShardCacheEntity {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IndexShardCacheEntity.class);
        private final IndexShard indexShard;

        protected IndexShardCacheEntity(BaseIndexShard indexShard) {
            this.indexShard = (IndexShard)indexShard;
        }

        @Override
        protected ShardRequestCache stats() {
            return this.indexShard.requestCache();
        }

        @Override
        public boolean isOpen() {
            return this.indexShard.state() != IndexShardState.CLOSED;
        }

        @Override
        public Object getCacheIdentity() {
            return this.indexShard;
        }

        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }
    }
}

